/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.IOrgSwitchFacade;
import com.kingdee.eas.basedata.org.MultiOrgsClientCacheImplFactory;
import com.kingdee.eas.basedata.org.MultiOrgsClientCacheImplUtil;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public abstract class MultiOrgsClientCacheSynchronizer {
    private static Logger logger = Logger.getLogger(MultiOrgsClientCacheSynchronizer.class);

    public static void doSynchronizing() {
        if (!UIConfig.isLocalStoreOrgUnit()) {
            MsgBox.showError((String)MultiOrgsClientCacheSynchronizer.getString("SYNC_ORG_CANNOT"));
            return;
        }
        Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        LongTimeDialog ltd = null;
        ltd = win instanceof Frame ? new LongTimeDialog((Frame)win) : (win instanceof Dialog ? new LongTimeDialog((Dialog)win) : new LongTimeDialog((Frame)new JFrame()));
        ltd.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                try {
                    MultiOrgsClientCacheSynchronizer.doSyncInternally();
                    MsgBox.showInfo((String)MultiOrgsClientCacheSynchronizer.getString("SYNC_ORG_SUCC"));
                }
                catch (Exception e) {
                    MsgBox.showInfo((String)MultiOrgsClientCacheSynchronizer.getString("SYNC_ORG_FAIL"));
                }
                return new Boolean(true);
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        ltd.show();
    }

    public static void doSynchronizingNew() throws Exception {
        MultiOrgsClientCacheSynchronizer.doSyncInternally();
    }

    private static String getString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OUResource", (String)key);
    }

    private static void doSyncInternally() throws Exception {
        MultiOrgsClientCacheSynchronizer.clearAllOrgCacheForCurrentUser();
        MultiOrgsClientCacheSynchronizer.storeAllMultiOrgsForAllOUsInOrgRangeOfCurrentUser();
        MultiOrgsClientCacheSynchronizer.updateSysContextForCurrentOU();
    }

    private static void clearAllOrgCacheForCurrentUser() {
        MultiOrgsClientCacheImplUtil.dropDirByPathStr(MultiOrgsClientCacheImplUtil.getOrgBaseCacheDir());
    }

    private static void storeAllMultiOrgsForAllOUsInOrgRangeOfCurrentUser() throws Exception {
        FullOrgUnitCollection fouc = PermissionFactory.getRemoteInstance().getOrgRanges((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        IOrgSwitchFacade iSwitch = OrgSwitchFacadeFactory.getRemoteInstance();
        int n = fouc.size();
        for (int i = 0; i < n; ++i) {
            MultiOrgsClientCacheImplFactory.create(fouc.get(i).getId().toString()).storeMultiOrgs(iSwitch.getOrgs(fouc.get(i).getId().toString()));
        }
    }

    private static void updateSysContextForCurrentOU() throws Exception {
        String ouID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        MultiOrgsClientCacheImplFactory.create(ouID).loadMultiOrgs();
    }
}

