/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.NodeFactory;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgTypeForF7;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.basedata.org.stepadd.StepAddParamInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class NewOrgViewHelper {
    private static Logger logger = Logger.getLogger(NewOrgViewHelper.class);
    private static OrgStructureInfo innerStructInfo = new OrgStructureInfo();

    public static OrgViewType convert(OrgType orgType) {
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(orgType);
        if (orgTypeInfo != null) {
            return orgTypeInfo.getOrgViewType();
        }
        return null;
    }

    public static OrgType convert(OrgViewType orgViewType) {
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgViewType);
        if (orgTypeInfo != null) {
            return orgTypeInfo.getOrgType();
        }
        return null;
    }

    public static OrgType transform(OrgTypeForF7 orgTypeForF7) {
        return OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgTypeForF7).getOrgType();
    }

    public static OrgTypeForF7 transform(OrgType orgType) {
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(orgType);
        if (orgTypeInfo != null) {
            return orgTypeInfo.getOrgTypeF7();
        }
        return null;
    }

    public static OrgType getOrgTypeFromOrgTreeID(String treeId) {
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(treeId);
        if (orgTypeInfo != null) {
            return orgTypeInfo.getOrgType();
        }
        return null;
    }

    public static OrgViewType getOrgViewTypeFromOrgTreeID(String treeId) {
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(treeId);
        if (orgTypeInfo != null) {
            return orgTypeInfo.getOrgViewType();
        }
        return null;
    }

    public static DefaultKingdeeTreeNode buildOUTreeByRowSet(FullOrgUnitCollection fulOrgCol, NodeFactory nodeFactory) throws BOSException {
        if (fulOrgCol == null) {
            return null;
        }
        if (fulOrgCol.size() == 0) {
            return nodeFactory.create(null);
        }
        DefaultKingdeeTreeNode rootTreeNode = null;
        HashMap<String, DefaultKingdeeTreeNode> nodeMap = new HashMap<String, DefaultKingdeeTreeNode>();
        for (int i = 0; i < fulOrgCol.size(); ++i) {
            String parentID;
            FullOrgUnitInfo fullInfo = fulOrgCol.get(i);
            if (rootTreeNode == null) {
                rootTreeNode = nodeFactory.create(fullInfo);
                nodeMap.put(fullInfo.getId().toString(), rootTreeNode);
                continue;
            }
            DefaultKingdeeTreeNode subTreeNode = nodeFactory.create(fullInfo);
            if (fullInfo.getParent() != null && fullInfo.getParent().getId() != null && nodeMap.containsKey(parentID = fullInfo.getParent().getId().toString())) {
                ((DefaultKingdeeTreeNode)nodeMap.get(parentID)).add((MutableTreeNode)subTreeNode);
            }
            nodeMap.put(fullInfo.getId().toString(), subTreeNode);
        }
        return rootTreeNode;
    }

    public static DefaultKingdeeTreeNode buildTreeByRowSet(OrgStructureCollection orgStructureCol, NodeFactory nodeFactory) throws BOSException {
        if (orgStructureCol == null || orgStructureCol.isEmpty()) {
            return null;
        }
        DefaultKingdeeTreeNode rootTreeNode = null;
        HashMap<String, DefaultKingdeeTreeNode> nodeMap = new HashMap<String, DefaultKingdeeTreeNode>();
        for (int i = 0; i < orgStructureCol.size(); ++i) {
            String parentID;
            OrgStructureInfo nodeInfo = orgStructureCol.get(i);
            if (rootTreeNode == null) {
                rootTreeNode = nodeFactory.create(nodeInfo);
                nodeMap.put(nodeInfo.getId().toString(), rootTreeNode);
                continue;
            }
            DefaultKingdeeTreeNode subTreeNode = nodeFactory.create(nodeInfo);
            if (nodeInfo.getParent() != null && nodeInfo.getParent().getId() != null && nodeMap.containsKey(parentID = nodeInfo.getParent().getId().toString())) {
                ((DefaultKingdeeTreeNode)nodeMap.get(parentID)).add((MutableTreeNode)subTreeNode);
            }
            nodeMap.put(nodeInfo.getId().toString(), subTreeNode);
        }
        return rootTreeNode;
    }

    public static DefaultKingdeeTreeNode buildTreeByRowSet(IRowSet rowset, NodeFactory nodeFactory) throws BOSException {
        OrgStructureCollection orgStructureCol;
        if (rowset == null || rowset.size() == 0) {
            return null;
        }
        Context ctx = ContextUtils.getContextFromSessionNoException();
        INewOrgViewFacade iNewOrgView = null;
        iNewOrgView = ctx == null ? NewOrgViewFacadeFactory.getRemoteInstance() : NewOrgViewFacadeFactory.getLocalInstance(ctx);
        try {
            orgStructureCol = iNewOrgView.createStructureCol(rowset, false);
        }
        catch (EASBizException e) {
            logger.error((Object)"error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return NewOrgViewHelper.buildTreeByRowSet(orgStructureCol, nodeFactory);
    }

    public static DefaultKingdeeTreeNode buildTreeByRowSet(IRowSet rowset) throws BOSException {
        return NewOrgViewHelper.buildTreeByRowSet(rowset, new NodeFactory(){

            @Override
            public DefaultKingdeeTreeNode create(Object obj) {
                return new DefaultKingdeeTreeNode(obj);
            }
        });
    }

    public static DefaultKingdeeTreeNode buildTreeByRowSet2(String rootUnitID, OrgStructureCollection structCol, StepAddParamInfo stepAddParamInfo, boolean isOriginalStructure) throws BOSException {
        OrgStructureInfo orgStructInfo;
        int i;
        if (structCol == null) {
            return null;
        }
        if (structCol.size() == 0) {
            return new DefaultKingdeeTreeNode();
        }
        OrgStructureInfo rootStr = null;
        if (isOriginalStructure) {
            for (i = structCol.size() - 1; i > -1; --i) {
                orgStructInfo = structCol.get(i);
                if (orgStructInfo.getParent() == null) {
                    rootStr = structCol.get(i);
                }
                if (rootUnitID == null || !rootUnitID.equals(orgStructInfo.getUnit().getId().toString())) continue;
                rootStr = structCol.get(i);
                structCol.removeObject(i);
            }
        } else {
            for (i = structCol.size() - 1; i > -1; --i) {
                orgStructInfo = structCol.get(i);
                if (orgStructInfo.get("isRoot") == null) continue;
                rootStr = orgStructInfo;
                structCol.removeObject(i);
            }
        }
        if (rootStr == null) {
            rootStr = new OrgStructureInfo();
            FullOrgUnitInfo fullOrgInfo = new FullOrgUnitInfo();
            fullOrgInfo.setId(BOSUuid.read((String)"11111111-1111-1111-1111-111111111111CCE7AED4"));
            fullOrgInfo.setParent(new FullOrgUnitInfo());
            rootStr.setId(BOSUuid.read((String)"11111111-1111-1111-1111-11111111111132B85C74"));
            rootStr.setUnit(fullOrgInfo);
        }
        DefaultKingdeeTreeNode virutalRootNode = new DefaultKingdeeTreeNode((Object)rootStr);
        DefaultKingdeeTreeNode[] treeNodes = new DefaultKingdeeTreeNode[structCol.size()];
        for (int i2 = 0; i2 < structCol.size(); ++i2) {
            OrgStructureInfo nodeInfo = structCol.get(i2);
            treeNodes[i2] = new DefaultKingdeeTreeNode((Object)nodeInfo);
        }
        NewOrgViewHelper.orderTreeNode(virutalRootNode, treeNodes);
        return virutalRootNode;
    }

    public static DefaultKingdeeTreeNode buildTreeByRowSet2(String rootUnitID, OrgStructureCollection structCol, StepAddParamInfo stepAddParamInfo) throws BOSException {
        return NewOrgViewHelper.buildTreeByRowSet2(rootUnitID, structCol, stepAddParamInfo, true);
    }

    public static void orderTreeNode(DefaultKingdeeTreeNode parentNode, DefaultKingdeeTreeNode[] treeNodes) {
        String rootLongNumber = (String)((CoreBaseInfo)parentNode.getUserObject()).get("longNumber");
        String longNumber = null;
        HashMap<String, DefaultKingdeeTreeNode> longNumberMap = new HashMap<String, DefaultKingdeeTreeNode>();
        for (int j = 0; j < treeNodes.length; ++j) {
            String tempLongNumber = (String)((CoreBaseInfo)treeNodes[j].getUserObject()).get("longNumber");
            longNumberMap.put(tempLongNumber, treeNodes[j]);
        }
        for (int i = 0; i < treeNodes.length; ++i) {
            longNumber = (String)((CoreBaseInfo)treeNodes[i].getUserObject()).get("longNumber");
            int index = longNumber.lastIndexOf("!");
            if (index < 0) continue;
            String parentLongNumber = longNumber.substring(0, index);
            if (parentLongNumber.equals(rootLongNumber)) {
                parentNode.add((MutableTreeNode)treeNodes[i]);
                continue;
            }
            DefaultKingdeeTreeNode tempNode = (DefaultKingdeeTreeNode)longNumberMap.get(parentLongNumber);
            if (tempNode == null) {
                parentNode.add((MutableTreeNode)treeNodes[i]);
                continue;
            }
            tempNode.add((MutableTreeNode)treeNodes[i]);
        }
    }

    public static DefaultKingdeeTreeNode buildTreeByRowSet2(OrgStructureCollection structCol) throws BOSException {
        if (structCol == null) {
            return null;
        }
        if (structCol.size() == 0) {
            return new DefaultKingdeeTreeNode();
        }
        DefaultKingdeeTreeNode rootTreeNode = null;
        HashMap<String, DefaultKingdeeTreeNode> nodeMap = new HashMap<String, DefaultKingdeeTreeNode>();
        for (int i = 0; i < structCol.size(); ++i) {
            String parentID;
            OrgStructureInfo nodeInfo = structCol.get(i);
            if (rootTreeNode == null) {
                rootTreeNode = new DefaultKingdeeTreeNode((Object)nodeInfo);
                nodeMap.put(nodeInfo.getId().toString(), rootTreeNode);
                continue;
            }
            DefaultKingdeeTreeNode subTreeNode = new DefaultKingdeeTreeNode((Object)nodeInfo);
            if (nodeInfo.getParent() != null && nodeInfo.getParent().getId() != null && nodeMap.containsKey(parentID = nodeInfo.getParent().getId().toString())) {
                ((DefaultKingdeeTreeNode)nodeMap.get(parentID)).add((MutableTreeNode)subTreeNode);
            }
            nodeMap.put(nodeInfo.getId().toString(), subTreeNode);
        }
        return rootTreeNode;
    }

    public static void reBuildBySortCode(TreeModel model, OrgTreeInfo orgTreeInfo) {
        if ("00000000-0000-0000-0000-0000000000034F2827FD".equals(orgTreeInfo.getId().toString())) {
            DefaultTreeModel treeModel = (DefaultTreeModel)model;
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
            if (root.getUserObject() != null && ((OrgStructureInfo)root.getUserObject()).getSortCode() != null) {
                NewOrgViewHelper.sortInTheSameLevel(root);
            }
            treeModel.setRoot((TreeNode)root);
        }
    }

    private static void sortInTheSameLevel(DefaultKingdeeTreeNode root) {
        int childCount = root.getChildCount();
        if (childCount > 0) {
            DefaultKingdeeTreeNode minSubNode;
            String minSortCode;
            int i;
            for (i = 0; i < childCount - 1 && (minSortCode = ((OrgStructureInfo)(minSubNode = (DefaultKingdeeTreeNode)root.getChildAt(i)).getUserObject()).getSortCode()) != null; ++i) {
                int minIndex = i;
                for (int j = i + 1; j < childCount; ++j) {
                    DefaultKingdeeTreeNode subNode = (DefaultKingdeeTreeNode)root.getChildAt(j);
                    String sortCode = ((OrgStructureInfo)subNode.getUserObject()).getSortCode();
                    if (StringUtils.isEmpty((String)sortCode) || sortCode.compareTo(minSortCode) >= 0) continue;
                    minSubNode = subNode;
                    minSortCode = sortCode;
                    minIndex = j;
                }
                if (minIndex == i) continue;
                root.insert((MutableTreeNode)minSubNode, i);
            }
            for (i = 0; i < childCount; ++i) {
                NewOrgViewHelper.sortInTheSameLevel((DefaultKingdeeTreeNode)root.getChildAt(i));
            }
        }
    }

    public static void reBuildAdminTreeBySortCode(DefaultKingdeeTreeNode root) {
        if (root != null && root.getUserObject() != null && ((OrgUnitInfo)root.getUserObject()).get("sortCode") != null) {
            NewOrgViewHelper.sortAdminInTheSameLevel(root);
        }
    }

    private static void sortAdminInTheSameLevel(DefaultKingdeeTreeNode root) {
        int childCount = root.getChildCount();
        if (childCount > 0) {
            DefaultKingdeeTreeNode minSubNode;
            String minSortCode;
            int i;
            for (i = 0; i < childCount - 1 && (minSortCode = (String)((OrgUnitInfo)(minSubNode = (DefaultKingdeeTreeNode)root.getChildAt(i)).getUserObject()).get("sortCode")) != null; ++i) {
                int minIndex = i;
                for (int j = i + 1; j < childCount; ++j) {
                    DefaultKingdeeTreeNode subNode = (DefaultKingdeeTreeNode)root.getChildAt(j);
                    String sortCode = (String)((OrgUnitInfo)subNode.getUserObject()).get("sortCode");
                    if (sortCode == null || sortCode.compareTo(minSortCode) >= 0) continue;
                    minSubNode = subNode;
                    minSortCode = sortCode;
                    minIndex = j;
                }
                if (minIndex == i) continue;
                root.insert((MutableTreeNode)minSubNode, i);
            }
            for (i = 0; i < childCount; ++i) {
                NewOrgViewHelper.sortAdminInTheSameLevel((DefaultKingdeeTreeNode)root.getChildAt(i));
            }
        }
    }

    public static DefaultKingdeeTreeNode buildTreeByOrgUnitCollection(AbstractObjectCollection col) throws BOSException {
        if (col == null) {
            return null;
        }
        if (col.size() == 0) {
            return new DefaultKingdeeTreeNode();
        }
        DefaultKingdeeTreeNode rootTreeNode = null;
        HashMap<String, DefaultKingdeeTreeNode> nodeMap = new HashMap<String, DefaultKingdeeTreeNode>();
        for (int i = 0; i < col.size(); ++i) {
            OrgUnitInfo unitInfo = (OrgUnitInfo)col.getObject(i);
            OrgUnitInfo parentInfo = (OrgUnitInfo)unitInfo.get("parent");
            if (rootTreeNode == null) {
                rootTreeNode = new DefaultKingdeeTreeNode((Object)unitInfo);
                nodeMap.put(unitInfo.getId().toString(), rootTreeNode);
                continue;
            }
            DefaultKingdeeTreeNode subTreeNode = new DefaultKingdeeTreeNode((Object)unitInfo);
            if (parentInfo == null) continue;
            if (nodeMap.containsKey(parentInfo.getId().toString())) {
                ((DefaultKingdeeTreeNode)nodeMap.get(parentInfo.getId().toString())).add((MutableTreeNode)subTreeNode);
            }
            nodeMap.put(unitInfo.getId().toString(), subTreeNode);
        }
        return rootTreeNode;
    }

    public static DefaultKingdeeTreeNode buildTreeByOrgStructCollection(OrgStructureCollection col) throws BOSException {
        if (col == null) {
            return null;
        }
        if (col.size() == 0) {
            return new DefaultKingdeeTreeNode();
        }
        DefaultKingdeeTreeNode rootNode = null;
        HashMap<String, DefaultKingdeeTreeNode> nodeMap = new HashMap<String, DefaultKingdeeTreeNode>();
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            OrgStructureInfo childInfo = col.get(i);
            OrgStructureInfo parentInfo = childInfo.getParent();
            if (rootNode == null) {
                rootNode = new DefaultKingdeeTreeNode((Object)childInfo);
                nodeMap.put(childInfo.getId().toString(), rootNode);
                continue;
            }
            DefaultKingdeeTreeNode subTreeNode = new DefaultKingdeeTreeNode((Object)childInfo);
            if (parentInfo == null) continue;
            if (nodeMap.containsKey(parentInfo.getId().toString())) {
                ((DefaultKingdeeTreeNode)nodeMap.get(parentInfo.getId().toString())).add((MutableTreeNode)subTreeNode);
            }
            nodeMap.put(childInfo.getId().toString(), subTreeNode);
        }
        return rootNode;
    }

    public static FullOrgUnitCollection rowset2Collection(IRowSet rowset) throws BOSException {
        FullOrgUnitCollection orgColl = new FullOrgUnitCollection();
        if (rowset == null) {
            return null;
        }
        Context ctx = ContextUtils.getContextFromSessionNoException();
        INewOrgViewFacade iNewOrgView = null;
        iNewOrgView = ctx == null ? NewOrgViewFacadeFactory.getRemoteInstance() : NewOrgViewFacadeFactory.getLocalInstance(ctx);
        try {
            orgColl = iNewOrgView.createFullOrgUnitCol(rowset);
            return orgColl;
        }
        catch (EASBizException e) {
            logger.error((Object)"error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static String convert2TreeId(OrgViewType orgViewType) {
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgViewType);
        if (orgTypeInfo != null) {
            return orgTypeInfo.getOrgTreeID();
        }
        return null;
    }

    public static String convert2TreeId(OrgType orgType) {
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(orgType);
        if (orgTypeInfo != null) {
            return orgTypeInfo.getOrgTreeID();
        }
        return null;
    }

    public static FullOrgUnitCollection getAllOrgs(Context ctx, OrgViewType orgView) throws EASBizException, BOSException {
        FullOrgUnitCollection orgColl = new FullOrgUnitCollection();
        INewOrgViewFacade iNew = null;
        iNew = ctx == null ? NewOrgViewFacadeFactory.getRemoteInstance() : NewOrgViewFacadeFactory.getLocalInstance(ctx);
        OrgStructureCollection orgStructCol = iNew.buildViewRowSetCommon2StructCol(NewOrgViewHelper.convert2TreeId(orgView), "00000000-0000-0000-0000-000000000000CCE7AED4", false, "ALL", false);
        int n = orgStructCol.size();
        for (int i = 0; i < n; ++i) {
            FullOrgUnitInfo fullOrgInfo = orgStructCol.get(i).getUnit();
            fullOrgInfo.put("treeType", new Integer(orgView.getValue()));
            orgColl.add(fullOrgInfo);
        }
        return orgColl;
    }

    public static FullOrgUnitCollection getAllOrgs(Context ctx, OrgType orgType) throws EASBizException, BOSException {
        FullOrgUnitCollection orgColl = new FullOrgUnitCollection();
        INewOrgViewFacade iNew = null;
        iNew = ctx == null ? NewOrgViewFacadeFactory.getRemoteInstance() : NewOrgViewFacadeFactory.getLocalInstance(ctx);
        IRowSet rowset = iNew.buildViewRowSet(NewOrgViewHelper.convert2TreeId(orgType), "00000000-0000-0000-0000-000000000000CCE7AED4", false);
        orgColl = NewOrgViewHelper.rowset2Collection(rowset);
        return orgColl;
    }

    public static String getNewStructID() {
        return BOSUuid.create((BOSObjectType)innerStructInfo.getBOSType()).toString();
    }

    public static String[] getAncestor(String longNumber) {
        if (longNumber == null || longNumber.length() == 0) {
            return new String[0];
        }
        String[] element = longNumber.split("!");
        String[] ancestor = new String[element.length];
        ancestor[0] = element[0];
        for (int i = 1; i < element.length; ++i) {
            ancestor[i] = ancestor[i - 1] + "!" + element[i];
        }
        return ancestor;
    }

    public static String getParentIDByLn(String ln, HashMap ln2IDs) {
        String id;
        String[] lns = NewOrgViewHelper.getAncestor(ln);
        String result = null;
        for (int i = 0; i < lns.length && (id = (String)ln2IDs.get(lns[i])) != null; ++i) {
            result = id;
        }
        return result;
    }

    public static TreeModel buildTreeModel(OrgType orgType, IMetaDataPK uiPK, IMetaDataPK actionPK) throws EASBizException, BOSException {
        return NewOrgViewHelper.buildTreeModel(orgType);
    }

    public static TreeModel buildTreeModel(OrgType orgType) throws EASBizException, BOSException {
        String treeID = NewOrgViewHelper.convert2TreeId(orgType);
        return OrgF7InnerUtils.buildTreeModel(treeID, "00000000-0000-0000-0000-000000000000CCE7AED4", null, false, false, true);
    }

    public static OrgUnitInfo getOrgUnitFromStructure(Context ctx, OrgStructureInfo strucInfo) throws BOSException, EASBizException {
        FullOrgUnitInfo unitInfo = strucInfo.getUnit();
        OrgTreeInfo treeInfo = strucInfo.getTree();
        IDynamicObject iDynamicObj = null;
        iDynamicObj = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(treeInfo.getId().toString());
        return (OrgUnitInfo)iDynamicObj.getValue(orgTypeInfo.getBosType(), (IObjectPK)new ObjectStringPK(unitInfo.getId().toString()));
    }

    public static OrgUnitInfo getOrgUnitInfo(Context ctx, String orgId, OrgType orgType) throws BOSException, EASBizException {
        return NewOrgViewHelper.getOrgUnitInfo(ctx, orgId, orgType, null);
    }

    public static OrgUnitCollection getOrgUnitCollection(Context ctx, OrgType orgType, EntityViewInfo viewInfo) throws BOSException, EASBizException {
        IDynamicObject iDynamicObj = null;
        iDynamicObj = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(orgType);
        if (orgTypeInfo == null) {
            return null;
        }
        return NewOrgViewHelper.trans(iDynamicObj.getCollection(orgTypeInfo.getBosType(), viewInfo));
    }

    public static OrgUnitCollection trans(IObjectCollection coreBaseCol) {
        OrgUnitCollection orgCol = new OrgUnitCollection();
        for (int i = 0; i < coreBaseCol.size(); ++i) {
            orgCol.add((OrgUnitInfo)coreBaseCol.getObject(i));
        }
        return orgCol;
    }

    public static OrgUnitCollection getOrgUnitCollection(Context ctx, OrgType orgType, String oql) throws BOSException, EASBizException {
        IDynamicObject iDynamicObj = null;
        iDynamicObj = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(orgType);
        if (orgTypeInfo == null) {
            return null;
        }
        return NewOrgViewHelper.trans(iDynamicObj.getCollection(orgTypeInfo.getBosType(), oql));
    }

    public static OrgUnitInfo getOrgUnitInfo(Context ctx, String orgId, OrgType orgType, SelectorItemCollection selector) throws BOSException, EASBizException {
        IDynamicObject iDynamicObj = null;
        iDynamicObj = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(orgType);
        if (selector == null) {
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
        }
        if (orgTypeInfo == null) {
            return null;
        }
        return (OrgUnitInfo)iDynamicObj.getValue(orgTypeInfo.getBosType(), (IObjectPK)new ObjectStringPK(orgId), selector);
    }

    public static OrgUnitCollection getOrgUnitCollection(Context ctx, List<String> orgIds, OrgType orgType, SelectorItemCollection selector) throws BOSException {
        OrgUnitCollection orgUnitCollection = new OrgUnitCollection();
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(orgType);
        if (orgTypeInfo == null || orgIds == null || orgIds.isEmpty()) {
            return orgUnitCollection;
        }
        if (selector == null) {
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
        }
        IDynamicObject iDynamicObj = null;
        iDynamicObj = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
        int MAX = 500;
        int arrSize = orgIds.size() / 500;
        if (arrSize * 500 != orgIds.size()) {
            ++arrSize;
        }
        Set[] orgidsArr = new Set[arrSize];
        HashSet<String> batchOrgIdsIn = new HashSet<String>();
        int k = 0;
        int size = orgIds.size();
        for (int i = 0; i < size; ++i) {
            batchOrgIdsIn.add(orgIds.get(i));
            if ((i + 1) % 500 == 0) {
                orgidsArr[k++] = batchOrgIdsIn;
                batchOrgIdsIn = new HashSet();
            }
            if (i != size - 1 || batchOrgIdsIn.isEmpty()) continue;
            orgidsArr[k] = batchOrgIdsIn;
        }
        for (Set orgidsIn : orgidsArr) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)orgidsIn, CompareType.INCLUDE));
            entityViewInfo.setFilter(filterInfo);
            entityViewInfo.setSelector(selector);
            IObjectCollection collection = iDynamicObj.getCollection(orgTypeInfo.getBosType(), entityViewInfo);
            if (collection == null) continue;
            int size2 = collection.size();
            for (int i = 0; i < size2; ++i) {
                orgUnitCollection.add((OrgUnitInfo)collection.getObject(i));
            }
        }
        return orgUnitCollection;
    }

    public static OrgUnitCollection getOrgUnitCollection(Context ctx, Collection orgIdCol, OrgType orgType, SelectorItemCollection selector) throws BOSException, EASBizException {
        IDynamicObject iDynamicObj = null;
        iDynamicObj = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(orgType);
        if (orgTypeInfo == null) {
            return null;
        }
        if (selector == null) {
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ToolUtils.aryToStr((Collection)orgIdCol), CompareType.INNER));
        view.setFilter(filter);
        view.setSelector(selector);
        IObjectCollection col = iDynamicObj.getCollection(orgTypeInfo.getBosType(), view);
        OrgUnitCollection orgCol = new OrgUnitCollection();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            orgCol.add((OrgUnitInfo)col.getObject(i));
        }
        return orgCol;
    }

    public static boolean existOrgUnitInfo(Context ctx, String orgId, OrgType orgType) throws BOSException, EASBizException {
        IDynamicObject iDynamicObj = null;
        iDynamicObj = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(orgType);
        if (orgTypeInfo == null) {
            return false;
        }
        return iDynamicObj.exists(orgTypeInfo.getBosType(), (IObjectPK)new ObjectStringPK(orgId));
    }

    public static DefaultKingdeeTreeNode buildTreeByList(DefaultKingdeeTreeNode root, List childNodes) {
        if (root == null) {
            if (childNodes == null || childNodes.size() == 0) {
                return new DefaultKingdeeTreeNode();
            }
            root = new DefaultKingdeeTreeNode(childNodes.get(0));
            for (int i = 1; i < childNodes.size(); ++i) {
                DefaultKingdeeTreeNode tmp = new DefaultKingdeeTreeNode(childNodes.get(i));
                root.add((MutableTreeNode)tmp);
            }
        } else {
            if (childNodes == null || childNodes.size() == 0) {
                return root;
            }
            int j = childNodes.size();
            for (int i = 0; i < j; ++i) {
                DefaultKingdeeTreeNode temp = new DefaultKingdeeTreeNode(childNodes.get(i));
                if (childNodes.get(i) instanceof OrgTreeInfo) {
                    temp.setText(childNodes.get(i).toString());
                }
                root.add((MutableTreeNode)temp);
            }
        }
        return root;
    }
}

