/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org;

import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgTypeRelationInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import java.util.ArrayList;
import java.util.HashMap;

public class OrgRelationInnerUtils {
    public static FullOrgUnitInfo[] getDelegateUnitsFromRelationCollection(OrgUnitRelationCollection col, OrgType fromType, OrgType toType) {
        ArrayList<FullOrgUnitInfo> list = new ArrayList<FullOrgUnitInfo>();
        if (col == null) {
            return new FullOrgUnitInfo[0];
        }
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            OrgUnitRelationInfo relationInfo = col.get(i);
            OrgTypeRelationInfo typeInfo = relationInfo.getTypeRelation();
            if (fromType.getValue() != typeInfo.getFromType().getValue() || toType.getValue() != typeInfo.getToType().getValue()) continue;
            list.add(relationInfo.getToUnit());
        }
        FullOrgUnitInfo[] ret = new FullOrgUnitInfo[list.size()];
        list.toArray(ret);
        return ret;
    }

    public static FullOrgUnitInfo getDefaultDelegateUnitsFromRelation(OrgUnitRelationCollection col, OrgType fromType, OrgType toType) {
        if (col == null || col.isEmpty()) {
            return new FullOrgUnitInfo();
        }
        ArrayList<FullOrgUnitInfo> mayRetList = new ArrayList<FullOrgUnitInfo>();
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            OrgUnitRelationInfo relationInfo = col.get(i);
            OrgTypeRelationInfo typeInfo = relationInfo.getTypeRelation();
            if (fromType.getValue() != typeInfo.getFromType().getValue() || toType.getValue() != typeInfo.getToType().getValue()) continue;
            mayRetList.add(relationInfo.getToUnit());
            if (!relationInfo.isIsDefault()) continue;
            return relationInfo.getToUnit();
        }
        if (!mayRetList.isEmpty()) {
            return (FullOrgUnitInfo)mayRetList.get(0);
        }
        return new FullOrgUnitInfo();
    }

    public static HashMap getDelegateUnitsFromRelationCollection2(OrgUnitRelationCollection col, OrgType fromType, OrgType toType) {
        HashMap<FullOrgUnitInfo, Boolean> map = new HashMap<FullOrgUnitInfo, Boolean>();
        if (col == null) {
            return map;
        }
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            OrgUnitRelationInfo relationInfo = col.get(i);
            OrgTypeRelationInfo typeInfo = relationInfo.getTypeRelation();
            if (fromType.getValue() != typeInfo.getFromType().getValue() || toType.getValue() != typeInfo.getToType().getValue()) continue;
            map.put(relationInfo.getToUnit(), new Boolean(relationInfo.isIsDefault()));
        }
        return map;
    }
}

