/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.basedata.org.NewOUInnerFacadeFactory;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.app.IOrgChangeAround;
import com.kingdee.eas.basedata.org.helper.OrgHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class AdminParentChangeAroundListener
implements IOrgChangeAround {
    private static Logger logger = Logger.getLogger((String)AdminParentChangeAroundListener.class.getName());
    private Context ctx = null;
    IObjectPK orgPk = null;
    private boolean isDeal = true;
    private String oldOrgParentId = null;
    private String oldAdminParentId = null;
    private String newOrgParentId = null;
    private String newAdminParentId = null;

    AdminParentChangeAroundListener(Context ctx, IObjectPK orgPk) {
        this.orgPk = orgPk;
        this.ctx = ctx;
    }

    @Override
    public void before() throws BOSException {
        try {
            if (!OrgHelper.isSupportSyncFromAdmin(this.ctx)) {
                this.isDeal = false;
                return;
            }
            if (this.orgPk == null) {
                this.isDeal = false;
                return;
            }
            this.oldOrgParentId = this.getParentId(this.ctx, this.orgPk.toString(), false);
            if (this.oldOrgParentId == null) {
                this.isDeal = false;
                return;
            }
            this.oldAdminParentId = this.getParentId(this.ctx, this.orgPk.toString(), true);
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.isDeal = false;
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public void after() throws EASBizException, BOSException {
        if (!this.isDeal) {
            return;
        }
        this.newOrgParentId = this.getParentId(this.ctx, this.orgPk.toString(), false);
        if (this.newOrgParentId == null) {
            return;
        }
        this.newAdminParentId = this.getParentId(this.ctx, this.orgPk.toString(), true);
        if (this.newAdminParentId == null || this.newAdminParentId.equals(this.oldAdminParentId)) {
            return;
        }
        if (!this.newOrgParentId.equals(this.newAdminParentId)) {
            if (this.oldAdminParentId != null && !this.oldAdminParentId.equals(this.oldOrgParentId)) {
                throw new OUException(OUException.ORG_AND_ADMIN_PARENT_NOTSAME);
            }
            NewOUInnerFacadeFactory.getLocalInstance(this.ctx).ouShift(this.orgPk, (IObjectPK)new ObjectStringPK(this.newAdminParentId));
        }
    }

    public String getParentId(Context ctx, String orgId, boolean isAdmin) throws BOSException {
        if (StringUtils.isEmpty((String)orgId)) {
            return "";
        }
        String tableName = "T_ORG_BASEUNIT";
        if (isAdmin) {
            tableName = "T_ORG_ADMIN";
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT FPARENTID  FROM  " + tableName + " where FID =  ?"), (Object[])new Object[]{orgId});
        try {
            if (rs.next()) {
                return rs.getString("FPARENTID") == null ? "" : rs.getString("FPARENTID");
            }
            return null;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }
}

