/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrgCacheManger {
    private static OrgCacheManger manager = null;
    private Logger logger = Logger.getLogger(this.getClass());
    private Map dcs = new Hashtable(5);
    private int count = 0;

    private OrgCacheManger() {
    }

    public static OrgCacheManger getInstance() {
        if (manager == null) {
            manager = new OrgCacheManger();
        }
        return manager;
    }

    public synchronized void putValueToCache(Context ctx, CoreBaseInfo model) {
        String dc = this.getDCFromContext(ctx);
        Hashtable table = (Hashtable)this.dcs.get(dc);
        assert (table != null);
        String id = (String)model.get("id");
        assert (!StringUtils.isEmpty((String)id));
        table.put(id, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreBaseInfo getValueFromCache(Context ctx, IObjectPK pk) {
        CoreBaseInfo cachedValue = null;
        if (ctx != null && pk != null) {
            String dc = this.getDCFromContext(ctx);
            Map map = this.dcs;
            synchronized (map) {
                Hashtable table = (Hashtable)this.dcs.get(dc);
                if (table == null) {
                    table = new Hashtable(100);
                    this.dcs.put(dc, table);
                } else {
                    cachedValue = (CoreBaseInfo)table.get(pk.toString());
                }
            }
        }
        if (cachedValue != null) {
            ++this.count;
            this.logger.debug((Object)("[ORG cache hit counts]:" + this.count));
        }
        return cachedValue;
    }

    public synchronized void clearCache(Context ctx) {
        String dc = this.getDCFromContext(ctx);
        Hashtable table = (Hashtable)this.dcs.get(dc);
        if (table != null) {
            table.clear();
        }
    }

    private String getDCFromContext(Context ctx) {
        assert (ctx != null);
        return ctx.getAIS().trim();
    }
}

