/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IBizDealOrgTreeDelete;
import com.kingdee.eas.basedata.org.IUnionVersionControllerFacade;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgException;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeException;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.UnionVersionControllerFacadeFactory;
import com.kingdee.eas.basedata.org.UnionVersionManager;
import com.kingdee.eas.basedata.org.UnionVersionStatusEnum;
import com.kingdee.eas.basedata.org.app.AbstractOrgTreeControllerBean;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Locale;

public class OrgTreeControllerBean
extends AbstractOrgTreeControllerBean {
    private static String LOGRESOURCE = "com.kingdee.eas.basedata.org.OrgLogResource";

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OrgTreeInfo treeInfo = (OrgTreeInfo)model;
        Object[] params = new Object[]{treeInfo.getName(), treeInfo.getNumber()};
        String detailMsg = MessageFormat.format(EASCommonResource.getString((String)LOGRESOURCE, (String)"ORGTREE_ADD", (Locale)ctx.getLocale()), params);
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)LOGRESOURCE, (String)"ORGTREE_EDIT"), (BOSObjectType)new OrgTreeInfo().getBOSType(), (IObjectPK)ctx.getCaller(), (String)detailMsg, (String)"OrgTree_AddNew");
        CtrlUnitInfo ctrlInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        this.checkOrgTreeInfo(ctx, model);
        treeInfo.setCU(ctrlInfo);
        IObjectPK orgTreePk = super._addnew(ctx, (IObjectValue)treeInfo);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        return orgTreePk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        OrgTreeInfo treeInfo = (OrgTreeInfo)model;
        OrgTreeInfo orgTreeInfo = OrgTreeFactory.getLocalInstance(ctx).getOrgTreeInfo(pk);
        Object[] params = new Object[]{orgTreeInfo.getName(), orgTreeInfo.getNumber()};
        String detailMsg = MessageFormat.format(EASCommonResource.getString((String)LOGRESOURCE, (String)"ORGTREE_UPDATE", (Locale)ctx.getLocale()), params);
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)LOGRESOURCE, (String)"ORGTREE_EDIT"), (BOSObjectType)new OrgTreeInfo().getBOSType(), (IObjectPK)ctx.getCaller(), (String)detailMsg, (String)"OrgTree_Update");
        CtrlUnitInfo ctrlInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        this.checkOrgTreeInfo(ctx, model);
        treeInfo.setCU(ctrlInfo);
        super._update(ctx, pk, (IObjectValue)treeInfo);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    void checkOrgTreeInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException, BOSException {
        this._checkNumberBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        this._checkNameBlank(ctx, model);
        this._checkNameDup(ctx, model);
        this.checkIsAdminOrgUnit(ctx, model);
        this.checkBasicExistOrgTree(ctx, model);
    }

    public void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OrgTreeInfo treeInfo = (OrgTreeInfo)model;
        if (treeInfo.getId() == null) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(treeInfo.getType().getValue())));
            filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)treeInfo.getName()));
            if (this._exists(ctx, filterInfo)) {
                throw new OrgException(OrgException.NAME_CAN_NOT_DUP);
            }
        } else {
            this.checkNameDupOnUpdate(ctx, treeInfo);
        }
    }

    /*
     * Exception decompiling
     */
    private void checkNameDupOnUpdate(Context ctx, OrgTreeInfo treeInfo) throws BOSException, EASBizException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OrgTreeInfo treeInfo = (OrgTreeInfo)model;
        if (treeInfo.getId() == null) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(treeInfo.getType().getValue())));
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)treeInfo.getNumber()));
            if (this._exists(ctx, filterInfo)) {
                throw new OrgException(OrgException.NUMBER_CAN_NOT_DUP);
            }
        } else {
            this.checkNumberDupOnUpdate(ctx, treeInfo);
        }
    }

    private void checkNumberDupOnUpdate(Context ctx, OrgTreeInfo treeInfo) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer().append("select fid from t_org_tree where ftype = 8 and fnumber = '").append(treeInfo.getNumber()).append("'");
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql.toString());
            if (!rs.next()) {
                return;
            }
            do {
                String fid;
                if (!(fid = rs.getString(1)).equals(treeInfo.getId().toString())) continue;
                return;
            } while (rs.next());
            throw new OrgException(OrgException.NUMBER_CAN_NOT_DUP);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    void checkBasicExistOrgTree(Context ctx, IObjectValue model) throws OrgTreeException, EASBizException, BOSException {
        OrgTreeInfo treeInfo = (OrgTreeInfo)model;
        if (!treeInfo.isBasic()) {
            return;
        }
        CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (!"00000000-0000-0000-0000-000000000000CCE7AED4".equals(cuInfo.getId().toString())) {
            throw new OrgTreeException(OrgTreeException.BASIC_TREE_CREATED_IN_DEF_CU);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(treeInfo.getType().getValue())));
        filterInfo.getFilterItems().add(new FilterItemInfo("basic", (Object)new Integer(1)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isForBudget", (Object)(treeInfo.isIsForBudget() ? new Integer(1) : new Integer(0))));
        if (treeInfo.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)treeInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filterInfo)) {
            String number = this.getBasicNumberForUnion(ctx, treeInfo.isIsForBudget() ? 1 : 0);
            if (number == null) {
                return;
            }
            if (number.equalsIgnoreCase(treeInfo.getNumber()) && treeInfo.getType() == OrgViewType.UNIONDEBT) {
                return;
            }
            throw new OrgTreeException(OrgTreeException.EXIST_BASIC_ORGTREE);
        }
    }

    private String getBasicNumberForUnion(Context ctx, int forBudget) throws BOSException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        String selectSql = "select fnumber from t_org_tree where ftype = 8 and fisbasic = 1 and fstatus != 2 and FIsForBudget = " + forBudget;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectSql);
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
                stmt = null;
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
                conn = null;
            }
        }
        return null;
    }

    void checkIsAdminOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OrgTreeInfo treeInfo = (OrgTreeInfo)model;
        OrgViewType orgViewType = treeInfo.getType();
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgViewType);
        if (!orgTypeInfo.isBasicOrgType()) {
            return;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(treeInfo.getType().getValue())));
        if (treeInfo.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)treeInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filterInfo)) {
            throw new OrgTreeException(OrgTreeException.EXIST_ADMIN_ORGTREE);
        }
    }

    @Override
    protected IObjectCollection _getCollectionWithType(Context ctx, OrgViewType orgViewType) throws BOSException, EASBizException {
        OrgTreeCollection coll = new OrgTreeCollection();
        EntityViewInfo evi = new EntityViewInfo();
        FilterItemInfo item = new FilterItemInfo("type", (Object)new Integer(orgViewType.getValue()));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(item);
        evi.setFilter(filter);
        CoreBaseCollection coreColl = this.getCollection(ctx, evi);
        for (int i = 0; i < coreColl.size(); ++i) {
            coll.add((OrgTreeInfo)coreColl.getObject(i));
        }
        return coll;
    }

    protected IObjectCollection _getOrgTreeCollection(Context ctx, EntityViewInfo view) throws BOSException {
        return this.getCollection(ctx, view);
    }

    @Override
    protected IObjectCollection _getCollectionWithType(Context ctx, OrgType orgType) throws BOSException, EASBizException {
        return this._getCollectionWithType(ctx, NewOrgViewHelper.convert(orgType));
    }

    @Override
    protected IObjectCollection _getUnionCollection(Context ctx) throws BOSException {
        OrgTreeCollection coll = new OrgTreeCollection();
        CoreBaseCollection coreColl = this.getCollection(ctx, "select * where type = 8 order by number");
        for (int i = 0; i < coreColl.size(); ++i) {
            if (UnionVersionManager.getInstance().isStarted()) {
                OrgTreeInfo treeInfo = (OrgTreeInfo)coreColl.getObject(i);
                if (treeInfo.getStatus() != UnionVersionStatusEnum.START && treeInfo.getStatus() != UnionVersionStatusEnum.ARCHIVE) continue;
                coll.add(treeInfo);
                continue;
            }
            coll.add((OrgTreeInfo)coreColl.getObject(i));
        }
        return coll;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        OrgTreeInfo orgTreeInfo = OrgTreeFactory.getLocalInstance(ctx).getOrgTreeInfo(pk);
        Object[] params = new Object[]{orgTreeInfo.getName(), orgTreeInfo.getNumber()};
        String detailMsg = MessageFormat.format(EASCommonResource.getString((String)LOGRESOURCE, (String)"ORGTREE_DELETE", (Locale)ctx.getLocale()), params);
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)LOGRESOURCE, (String)"ORGTREE_EDIT"), (BOSObjectType)new OrgTreeInfo().getBOSType(), (IObjectPK)ctx.getCaller(), (String)detailMsg, (String)"OrgTree_Delete");
        if (!this.otherDealOrgTreeDelete(ctx, pk)) {
            throw new OrgException(OrgException.CAN_NOT_REF_DELETE);
        }
        IUnionVersionControllerFacade iUnionVFacade = UnionVersionControllerFacadeFactory.getLocalInstance((Context)ctx);
        iUnionVFacade.deleteAllUnionByTreeID(pk.toString());
        super._delete(ctx, pk);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    private boolean otherDealOrgTreeDelete(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        boolean canDelete = true;
        try {
            String[] checks = RefCheckersDAO.getCheckers((Context)ctx, (String)"4F2827FD", IBizDealOrgTreeDelete.class);
            if (checks != null && checks.length > 0) {
                IBizDealOrgTreeDelete bizDealOrgTreeDelete = null;
                for (int i = 0; i < checks.length && (canDelete = (bizDealOrgTreeDelete = (IBizDealOrgTreeDelete)Class.forName(checks[i]).newInstance()).canDelete(ctx, pk)); ++i) {
                }
                canDelete = true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return canDelete;
    }

    @Override
    protected void _setTreeHide(Context ctx, String id) throws BOSException, EASBizException {
        this.updateIsHideOfTree(ctx, id, true);
    }

    @Override
    protected void _setTreeDisplay(Context ctx, String id) throws BOSException, EASBizException {
        this.updateIsHideOfTree(ctx, id, false);
    }

    private void updateIsHideOfTree(Context ctx, String id, boolean isHide) throws BOSException {
        String sqlStr = null;
        sqlStr = isHide ? "update T_org_tree set FIsHide = 1 where FID ='" + id + "'" : "update T_org_tree set FIsHide = 0 where FID ='" + id + "'";
        DbUtil.execute((Context)ctx, (String)sqlStr);
        ORMValueCacheService.getInstance().remove(ctx, new OrgTreeInfo().getBOSType(), id);
    }
}

