/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.TableAssistInfo;
import com.kingdee.eas.basedata.org.app.helper.FilterAssembleDecorator;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgTypeAppCenter;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class NormalFilter4F7Decorator
extends FilterAssembleDecorator {
    @Override
    protected List<String> handleFilterItems(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        ArrayList<String> filterItems = new ArrayList<String>();
        if (assistInfo.isNeedAddVirtualFilter() && (!assistInfo.isStructure() || assistInfo.getOrgViewType() == OrgViewType.ADMIN)) {
            filterItems.add("(\"OUPART\".FIsVirtual = 0 or \"OUPART\".FIsVirtual is null )");
        }
        if (assistInfo.isHideStartSHR()) {
            filterItems.add("\"OUPART\".FISSTARTSHR = 0 or \"OUPART\".FISSTARTSHR is null ");
        }
        if (assistInfo.isNeedAddSealUpFilter()) {
            if (!assistInfo.isStructure() || assistInfo.getOrgViewType() == OrgViewType.CTRLUNIT) {
                filterItems.add("\"BASEUNIT\".FIsOUSealup = 0");
            } else if (assistInfo.getOrgViewType() != OrgViewType.UNIONDEBT) {
                filterItems.add("\"OUPART\".FIsSealUp = 0");
            }
        }
        if (assistInfo.isNeedAddAssistantFilter()) {
            CompanyOrgUnitInfo currentCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
            if (currentCompany != null && currentCompany.isIsAssistantOrg()) {
                filterItems.add("\"BASEUNIT\".FIsAssistantOrg = 1");
            } else {
                filterItems.add("\"BASEUNIT\".FIsAssistantOrg = 0");
            }
        }
        if (!StringUtils.isEmpty((String)assistInfo.getQuickQueryValue())) {
            filterItems.add(this.appendQuickQuerySQL(ctx, assistInfo));
        }
        return filterItems;
    }

    private String getTableNameByOrgTypeView(OrgViewType orgViewType) {
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgViewType);
        IOrgAppHelper iHelper = OrgTypeAppCenter.getInstance().getHelper(orgTypeInfo.getOrgType());
        return iHelper.getOrgTypeSelfInfo().getTableName();
    }

    @Override
    protected List<TableAssistInfo> handleTables(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        OrgViewType viewType;
        ArrayList<TableAssistInfo> tables = new ArrayList<TableAssistInfo>();
        if (!assistInfo.isStructure() && assistInfo.isNeedAddVirtualFilter()) {
            tables.add(assistInfo.createTableAssistInfo("T_ORG_OUPARTADMIN", "\"OUPART\"", "FUnitId", "\"BASEUNIT\"", "FID"));
        } else if (assistInfo.isStructure() && (viewType = assistInfo.getOrgViewType()) != OrgViewType.UNIONDEBT && viewType != OrgViewType.CTRLUNIT) {
            tables.add(assistInfo.createTableAssistInfo(this.getTableNameByOrgTypeView(viewType), "\"OUPART\"", "FUnitId", "\"BASEUNIT\"", "FID"));
        }
        return tables;
    }

    private String appendQuickQuerySQL(Context ctx, OrgAssistInfo assistInfo) throws BOSException {
        StringBuffer result = new StringBuffer();
        if (assistInfo.isBlured()) {
            boolean isCapitalSensitiveQuery = assistInfo.isCapitalSensitiveQuery();
            if (isCapitalSensitiveQuery) {
                if (assistInfo.getQuickQueryField() == 2) {
                    result.append("\"BASEUNIT\"").append(" .FNAME_").append(ctx.getLocale().toString()).append(" like ? ");
                } else if (assistInfo.getQuickQueryField() == 1) {
                    result.append("\"BASEUNIT\"").append(" .FNUMBER like ? ");
                } else if (assistInfo.getQuickQueryField() == 8) {
                    result.append("(").append("\"BASEUNIT\"").append(".FNAME_").append(ctx.getLocale().toString()).append(" like ? ").append(" or ").append("\"BASEUNIT\"").append(" .FNUMBER like ? )");
                } else if (assistInfo.getQuickQueryField() == 5) {
                    result.append("\"BASEUNIT\"").append(" .FCODE like ? ");
                }
            } else if (assistInfo.getQuickQueryField() == 2) {
                result.append("upper(").append("\"BASEUNIT\"").append(" .FNAME_").append(ctx.getLocale().toString()).append(") like ? ");
            } else if (assistInfo.getQuickQueryField() == 1) {
                result.append("upper(").append("\"BASEUNIT\"").append(" .FNUMBER) like ? ");
            } else if (assistInfo.getQuickQueryField() == 8) {
                result.append("(upper(").append("\"BASEUNIT\"").append(".FNAME_").append(ctx.getLocale().toString()).append(") like ? ").append(" or upper(").append("\"BASEUNIT\"").append(" .FNUMBER) like ? )");
            } else if (assistInfo.getQuickQueryField() == 5) {
                result.append("upper(").append("\"BASEUNIT\"").append(" .FCODE) like ? ");
            }
        } else if (assistInfo.getQuickQueryField() == 2) {
            result.append("\"BASEUNIT\"").append(" .FNAME_").append(ctx.getLocale().toString()).append(" = ? ");
        } else if (assistInfo.getQuickQueryField() == 1) {
            result.append("\"BASEUNIT\"").append(" .FNUMBER = ? ");
        } else if (assistInfo.getQuickQueryField() == 8) {
            result.append("(").append("\"BASEUNIT\"").append(" .FNAME_").append(ctx.getLocale().toString()).append(" = ?").append(" or ").append("\"BASEUNIT\"").append(" .FNUMBER = ?)");
        } else if (assistInfo.getQuickQueryField() == 5) {
            result.append("\"BASEUNIT\"").append(" .FCODE = ? ");
        }
        return result.toString();
    }

    @Override
    protected List<Object> getObjParams(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        ArrayList<Object> objParams = new ArrayList<Object>();
        if (assistInfo.isBlured()) {
            boolean isCapitalSensitiveQuery = assistInfo.isCapitalSensitiveQuery();
            if (isCapitalSensitiveQuery) {
                if (assistInfo.getQuickQueryField() == 2) {
                    objParams.add("%" + assistInfo.getQuickQueryValue() + "%");
                } else if (assistInfo.getQuickQueryField() == 1) {
                    objParams.add("%" + assistInfo.getQuickQueryValue() + "%");
                } else if (assistInfo.getQuickQueryField() == 8) {
                    objParams.add("%" + assistInfo.getQuickQueryValue() + "%");
                    objParams.add("%" + assistInfo.getQuickQueryValue() + "%");
                } else if (assistInfo.getQuickQueryField() == 5) {
                    objParams.add("%" + assistInfo.getQuickQueryValue() + "%");
                }
            } else if (assistInfo.getQuickQueryField() == 2) {
                objParams.add("%" + assistInfo.getQuickQueryValue().toUpperCase() + "%");
            } else if (assistInfo.getQuickQueryField() == 1) {
                objParams.add("%" + assistInfo.getQuickQueryValue().toUpperCase() + "%");
            } else if (assistInfo.getQuickQueryField() == 8) {
                objParams.add("%" + assistInfo.getQuickQueryValue().toUpperCase() + "%");
                objParams.add("%" + assistInfo.getQuickQueryValue().toUpperCase() + "%");
            } else if (assistInfo.getQuickQueryField() == 5) {
                objParams.add("%" + assistInfo.getQuickQueryValue().toUpperCase() + "%");
            }
        } else if (assistInfo.getQuickQueryField() == 2) {
            objParams.add(assistInfo.getQuickQueryValue());
        } else if (assistInfo.getQuickQueryField() == 1) {
            objParams.add(assistInfo.getQuickQueryValue());
        } else if (assistInfo.getQuickQueryField() == 8) {
            objParams.add(assistInfo.getQuickQueryValue());
            objParams.add(assistInfo.getQuickQueryValue());
        } else if (assistInfo.getQuickQueryField() == 5) {
            objParams.add(assistInfo.getQuickQueryValue());
        }
        return objParams;
    }
}

