/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo2;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgTypeAppCenter;
import com.kingdee.eas.basedata.org.app.stetpadd.SqlMgrHelper;
import com.kingdee.eas.basedata.org.helper.BizOrgQueryParam;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.basedata.org.stepadd.StepAddParamInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.apache.log4j.Logger;

public class QueryOrgStructSqlHelper {
    private static Logger logger = Logger.getLogger(QueryOrgStructSqlHelper.class);

    public OrgStructureCollection createOrgStructureCol(Context ctx, IRowSet row, boolean isRevised, boolean isSimpleField) throws EASBizException, BOSException {
        OrgStructureCollection orgStrCol = new OrgStructureCollection();
        try {
            while (row.next()) {
                OrgStructureInfo orgStrInfo = this.createOrgStructureInfo(ctx, row, isRevised, isSimpleField);
                orgStrCol.add(orgStrInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return orgStrCol;
    }

    public OrgStructureCollection createOrgStructureCol(Context ctx, IRowSet row, boolean isRevised) throws EASBizException, BOSException {
        return this.createOrgStructureCol(ctx, row, isRevised, false);
    }

    public OrgStructureInfo createOrgStructureInfo(Context ctx, IRowSet row, boolean isRevised, boolean isSimpleField, OrgTypeInfo orgTypeInfo) throws EASBizException, BOSException {
        try {
            OrgStructureInfo structInfo = null;
            structInfo = isRevised ? new OrgStructureInfo2() : new OrgStructureInfo();
            structInfo.setId(BOSUuid.read((String)row.getString("id")));
            structInfo.setLongNumber(row.getString("longNumber"));
            structInfo.setSortCode(row.getString("sortCode"));
            structInfo.setLevel(row.getInt("level"));
            structInfo.setIsLeaf(row.getBoolean("isLeaf"));
            structInfo.setIsValid(row.getBoolean("isValid"));
            FullOrgUnitInfo fullUnitInfo = this.createFullOrgUnitInfo(ctx, row, isSimpleField, orgTypeInfo);
            fullUnitInfo.setLongNumber(row.getString("longNumber"));
            fullUnitInfo.put("treeType", new Integer(row.getInt("tree.type")));
            String treeNumber = row.getString("tree.number");
            if (treeNumber != null) {
                fullUnitInfo.put("treeNumber", treeNumber);
            }
            structInfo.setUnit(fullUnitInfo);
            OrgStructureInfo parentStructInfo = null;
            if (row.getString("parent.id") != null && !row.getString("parent.id").equals("")) {
                parentStructInfo = new OrgStructureInfo();
                parentStructInfo.setId(BOSUuid.read((String)row.getString("parent.id")));
            }
            structInfo.setParent(parentStructInfo);
            OrgTreeInfo treeInfo = new OrgTreeInfo();
            treeInfo.setId(BOSUuid.read((String)row.getString("tree.id")));
            structInfo.setTree(treeInfo);
            return structInfo;
        }
        catch (UuidException e) {
            logger.error((Object)"error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public OrgStructureInfo createOrgStructureInfo(Context ctx, IRowSet row, boolean isRevised, boolean isSimpleField) throws EASBizException, BOSException {
        return this.createOrgStructureInfo(ctx, row, isRevised, isSimpleField, null);
    }

    public OrgStructureInfo createOrgStructureInfo(Context ctx, IRowSet row, boolean isRevised) throws EASBizException, BOSException {
        return this.createOrgStructureInfo(ctx, row, isRevised, false);
    }

    public FullOrgUnitCollection createFullOrgUnitCol(Context ctx, IRowSet row) throws EASBizException, BOSException {
        FullOrgUnitCollection retCol = new FullOrgUnitCollection();
        try {
            while (row.next()) {
                FullOrgUnitInfo fullInfo = this.createFullOrgUnitInfo(ctx, row);
                retCol.add(fullInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return retCol;
    }

    public FullOrgUnitInfo createFullOrgUnitInfo(Context ctx, IRowSet row, boolean isSimpleField, OrgTypeInfo orgTypeInfo) throws EASBizException, BOSException {
        try {
            FullOrgUnitInfo fullUnitInfo = new FullOrgUnitInfo();
            fullUnitInfo.setId(BOSUuid.read((String)row.getString("unit.id")));
            fullUnitInfo.setNumber(row.getString("unit.number"));
            fullUnitInfo.setName(row.getString("unit.name"));
            fullUnitInfo.setIsGrouping(row.getBoolean("unit.isGrouping"));
            fullUnitInfo.setIsFreeze(row.getBoolean("unit.isFreeze"));
            fullUnitInfo.setInvalidDate(row.getDate("unit.invalidDate"));
            fullUnitInfo.setEffectDate(row.getDate("unit.effectDate"));
            fullUnitInfo.setLongNumber(row.getString("longNumber"));
            fullUnitInfo.setOrgTypeStr(row.getString("UNIT.FOrgTypeStr"));
            OrgTypeHelper.createOrgType4FullOrg(fullUnitInfo, fullUnitInfo.getOrgTypeStr());
            if (orgTypeInfo == null) {
                String treeID = row.getString("TREE.ID");
                orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(treeID);
                if (orgTypeInfo == null) {
                    orgTypeInfo = this.getOrgTypeByTreeID(ctx, treeID);
                }
            }
            OrgTypeAppCenter.getInstance().fillFullOrgUnit(ctx, fullUnitInfo, row, "BIZOBJ_PART", isSimpleField, orgTypeInfo);
            fullUnitInfo.setIsAssistantOrg(row.getBoolean("unit.isAssistantOrg"));
            return fullUnitInfo;
        }
        catch (UuidException e) {
            logger.error((Object)"error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public FullOrgUnitInfo createFullOrgUnitInfo(Context ctx, IRowSet row, boolean isSimpleField) throws EASBizException, BOSException {
        return this.createFullOrgUnitInfo(ctx, row, isSimpleField, null);
    }

    public FullOrgUnitInfo createFullOrgUnitInfo(Context ctx, IRowSet row) throws EASBizException, BOSException {
        return this.createFullOrgUnitInfo(ctx, row, false);
    }

    public OrgStructureCollection getOrgStructureDetailCol(Context ctx, String treeID, String rootUnitID, boolean isContainSealUp, boolean isShowVirtual, int level, boolean isShowAssistantOrg, StepAddParamInfo stepAddParamInfo, boolean isRevised, boolean isSimpleField) throws EASBizException, BOSException {
        int count = 0;
        String querySql = this.getViewRowSet4(ctx, treeID, rootUnitID, isContainSealUp, isShowVirtual, level, isShowAssistantOrg, stepAddParamInfo, isSimpleField);
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        OrgStructureCollection orgStructCol = new OrgStructureCollection();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
        }
        try {
            JdbcRowSet rowset;
            int fetched;
            statement = conn.createStatement();
            rs = statement.executeQuery(querySql);
            OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(treeID);
            if (orgTypeInfo == null) {
                orgTypeInfo = this.getOrgTypeByTreeID(ctx, treeID);
            }
            while ((fetched = (rowset = new JdbcRowSet()).populate(rs, 0, 1, true)) != 0) {
                rowset.next();
                orgStructCol.add(this.createOrgStructureInfo(ctx, (IRowSet)rowset, isRevised, isSimpleField, orgTypeInfo));
                ++count;
            }
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)("333 sql is:" + querySql), (Throwable)exc);
                throw new BOSException("Sql3 execute exception : " + querySql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return orgStructCol;
    }

    public OrgStructureCollection getOrgStructureDetailCol(Context ctx, String treeID, String rootUnitID, boolean isContainSealUp, boolean isShowVirtual, int level, boolean isShowAssistantOrg, StepAddParamInfo stepAddParamInfo, boolean isRevised) throws EASBizException, BOSException {
        return this.getOrgStructureDetailCol(ctx, treeID, rootUnitID, isContainSealUp, isShowVirtual, level, isShowAssistantOrg, stepAddParamInfo, isRevised, false);
    }

    private String getStruLongNumber(Context ctx, String cuID, String orgViewID) throws BOSException {
        IOrgStructure iStr = OrgStructureFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo1 = new EntityViewInfo();
        FilterInfo fi1 = new FilterInfo();
        fi1.getFilterItems().add(new FilterItemInfo("tree.id", (Object)orgViewID));
        fi1.getFilterItems().add(new FilterItemInfo("unit.id", (Object)cuID));
        fi1.setMaskString("#0 and #1");
        viewInfo1.setFilter(fi1);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("longNumber"));
        viewInfo1.getSelector().addObjectCollection((IObjectCollection)sic);
        OrgStructureCollection orgStruColl = iStr.getOrgStructureCollection(viewInfo1);
        if (orgStruColl.size() == 0) {
            return "";
        }
        return orgStruColl.get(0).getLongNumber();
    }

    private String getRowSetByCUWhereSql(Context ctx, String cuID, String orgViewID, OrgStructureInfo structInfo, boolean isShowSub, String structNameAlias, String baseUnitDbname) throws BOSException, EASBizException {
        StringBuffer retSqlBuf = new StringBuffer("");
        retSqlBuf.append(" tree.fid ='").append(orgViewID).append("'");
        if (structInfo != null) {
            retSqlBuf.append(" and (").append(structNameAlias).append(" ='").append(structInfo.getLongNumber()).append("'");
            if (isShowSub) {
                retSqlBuf.append(" or ").append(structNameAlias).append(" like '").append(structInfo.getLongNumber()).append("%')");
            } else {
                retSqlBuf.append(")");
            }
        }
        return retSqlBuf.toString();
    }

    public IRowSet getRowSetByCU(Context ctx, String cuID, String orgViewID, OrgStructureInfo structInfo, boolean isShowSub) throws BOSException, EASBizException {
        String whereSql = this.getRowSetByCUWhereSql(ctx, cuID, orgViewID, structInfo, isShowSub, "ORGSTRUCTURE", "UNIT");
        return this.getRowSetByWhereSql(ctx, whereSql);
    }

    public IRowSet getUnionRows(Context ctx, String unitID, String treeID) throws BOSException, EASBizException {
        String longNumber = this.getStruLongNumber(ctx, unitID, treeID);
        StringBuffer sqlWhereBuf = new StringBuffer("");
        sqlWhereBuf.append("tree.fid='").append(treeID).append("'");
        sqlWhereBuf.append(" and (ORGSTRUCTURE.flongNumber ='").append(longNumber).append("'").append(" or ORGSTRUCTURE.flongNumber like '").append(longNumber).append("%')");
        return this.getRowSetByWhereSql(ctx, sqlWhereBuf.toString());
    }

    public IRowSet getViewRowSetCommon(Context ctx, String treeID, String rootUnitID, boolean isContainSealUp, String isVirtualType, boolean isSimpleField) throws BOSException, EASBizException {
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        String oql = "select longNumber where unit.id = '" + rootUnitID + "' and tree.id = '" + treeID + "' order by longNumber asc";
        String rootLongNumber = "";
        rootLongNumber = iStruct.exists(oql) ? iStruct.getOrgStructureCollection(oql).get(0).getLongNumber() : "###@$@###";
        StringBuffer sqlSb = new StringBuffer("");
        sqlSb.append(" TREE.FID ='").append(treeID).append("'").append(" and ORGSTRUCTURE.FIsValid = 1 ");
        if (!rootUnitID.equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
            sqlSb.append(" and ( ORGSTRUCTURE.flongNumber ='").append(rootLongNumber).append("'").append(" or ORGSTRUCTURE.flongNumber like '").append(rootLongNumber).append("!%')");
        }
        if (!isContainSealUp) {
            if (treeID.equals("00000000-0000-0000-0000-0000000000014F2827FD")) {
                sqlSb.append(" and unit.fisOUSealUp = 0 ");
            } else {
                BizOrgQueryParam queryParam = new BizOrgQueryParam();
                queryParam.setOrgOUSealType("TRUE");
                queryParam.setBizObjType("BIZOBJ_PART");
                if ("00000000-0000-0000-0000-0000000000094F2827FD".equals(treeID)) {
                    sqlSb.append(this.sqlAppendByOrgTree("00000000-0000-0000-0000-0000000000054F2827FD", queryParam));
                    sqlSb.append(this.sqlAppendByOrgTree("00000000-0000-0000-0000-0000000000044F2827FD", queryParam));
                    sqlSb.append(this.sqlAppendByOrgTree("00000000-0000-0000-0000-0000000000024F2827FD", queryParam));
                } else {
                    sqlSb.append(this.sqlAppendByOrgTree(treeID, queryParam));
                }
            }
        }
        if ("FALSE".equals(isVirtualType) && OrgType.Admin.equals((Object)OrgTypeInfoMgr.getInstance().getOrgTypeInfo(treeID).getOrgType())) {
            sqlSb.append(" and ( unit.fid not in ( SELECT funitid FROM   t_org_oupartadmin where FIsVirtual=1 )) ");
        }
        sqlSb.append(" and ").append("UNIT.FIsAssistantOrg = 0 ");
        return this.getRowSetByWhereSql(ctx, sqlSb.toString(), treeID, isSimpleField);
    }

    public IRowSet getViewRowSetCommon(Context ctx, String treeID, String rootUnitID, boolean isContainSealUp, String isVirtualType) throws BOSException, EASBizException {
        return this.getViewRowSetCommon(ctx, treeID, rootUnitID, isContainSealUp, isVirtualType, false);
    }

    private String sqlAppendByOrgTree(String treeID, BizOrgQueryParam queryParam) {
        IOrgAppHelper orgAppHelper = OrgTypeAppCenter.getInstance().getHelper(OrgTypeInfoMgr.getInstance().getOrgTypeInfo(treeID).getOrgType());
        String sql = OrgAppHelper.getSqlQueryOrgInfo(orgAppHelper.getOrgTypeSelfInfo().getTableName(), queryParam);
        if (!StringUtils.isEmpty((String)sql)) {
            return " and unit.fid not in (" + sql + ")";
        }
        return "";
    }

    public IRowSet getRowSetByWhereSql(Context ctx, String whereSql) throws BOSException, EASBizException {
        return this.getRowSetByWhereSql(ctx, whereSql, null, false);
    }

    public IRowSet getRowSetByWhereSql(Context ctx, String whereSql, String treeID, boolean isSimpleField) throws BOSException, EASBizException {
        StringBuffer queryAllSql = new StringBuffer("");
        queryAllSql.append("select ").append(this.getQueryFieldStr(ctx, treeID, isSimpleField)).append(this.getJoinTable()).append(" where (\"UNIT\".FID <> '11111111-1111-1111-1111-111111111111CCE7AED4')").append(" and ").append(whereSql).append(" order by ORGSTRUCTURE.flongNumber ");
        String queryStr = queryAllSql.toString();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)queryStr);
        return rowSet;
    }

    public IRowSet getRowSetByOrgId(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        String whereSql = "\"UNIT\".FID = '" + orgUnitId + "'";
        return this.getRowSetByWhereSql(ctx, whereSql);
    }

    public IRowSet getRowSetByOrgNumber(Context ctx, String orgUnitNumber) throws BOSException, EASBizException {
        String whereSql = "\"UNIT\".FNumber = '" + orgUnitNumber + "'";
        return this.getRowSetByWhereSql(ctx, whereSql);
    }

    private String getViewRowSet4(Context ctx, String treeID, String rootUnitID, boolean isContainSealUp, boolean isShowVirtual, int level, boolean isShowAssistantOrg, StepAddParamInfo stepAddParamInfo, boolean isSimpleField) throws BOSException, EASBizException {
        if (stepAddParamInfo != null) {
            stepAddParamInfo.setNeedLeafField(false);
            stepAddParamInfo.setUserOql(false);
        }
        StringBuffer queryAllSql = new StringBuffer("");
        queryAllSql.append("select ").append(this.getQueryFieldStr(ctx, treeID, isSimpleField)).append(this.getJoinTable()).append(SqlMgrHelper.needStepAddWhere(stepAddParamInfo, "ORGSTRUCTURE")).append("(\"UNIT\".FID <> '11111111-1111-1111-1111-111111111111CCE7AED4')").append(" and ").append(this.getSqlWhere(ctx, treeID, rootUnitID, isContainSealUp, isShowVirtual, level, isShowAssistantOrg)).append(" order by ORGSTRUCTURE.flongNumber ");
        String queryStr = queryAllSql.toString();
        return queryStr;
    }

    public String getQueryFieldStr(Context ctx, String treeID, boolean isSimpleField) throws EASBizException, BOSException {
        if (isSimpleField) {
            return this.getSimpleQueryFieldStr(ctx, treeID);
        }
        return this.getQueryFieldStr(ctx);
    }

    private OrgTypeInfo getOrgTypeByTreeID(Context ctx, String treeID) throws BOSException {
        String sql = "select ftype from t_org_tree where fid='" + treeID + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        int type = 0;
        try {
            if (rs.next()) {
                type = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(OrgType.getEnum(type));
    }

    public String getSimpleQueryFieldStr(Context ctx, String treeID) throws EASBizException, BOSException {
        OrgTypeInfo orgTypeInfo = this.getOrgTypeByTreeID(ctx, treeID);
        String simpleLeftJoinField = OrgTypeAppCenter.getInstance().getLeftJoinSimpleFiledByOrgType(ctx, "BIZOBJ_PART", orgTypeInfo);
        StringBuffer sb = new StringBuffer("");
        sb.append("\"ORGSTRUCTURE\".FID AS \"ID\",").append("\"ORGSTRUCTURE\".FLongNumber AS \"LONGNUMBER\",").append("\"ORGSTRUCTURE\".FLevel AS \"LEVEL\",").append("\"ORGSTRUCTURE\".FIsLeaf AS \"ISLEAF\",").append("\"ORGSTRUCTURE\".FIsValid AS \"ISVALID\",").append("\"ORGSTRUCTURE\".FParentID AS \"PARENT.ID\",").append("\"UNIT\".FID AS \"UNIT.ID\",").append("\"UNIT\".FNumber AS \"UNIT.NUMBER\",").append("\"UNIT\".FName_L2 AS \"UNIT.NAME\",").append("\"UNIT\".FSimpleName AS \"UNIT.SIMPLENAME\",").append("\"UNIT\".FLongNumber AS \"UNIT.LONGNUMBER\",").append("\"UNIT\".FLevel AS \"UNIT.LEVEL\",").append("\"UNIT\".FIsLeaf AS \"UNIT.ISLEAF\",").append("\"UNIT\".FIsGrouping AS \"UNIT.ISGROUPING\",").append("\"UNIT\".FIsUnion AS \"UNIT.ISUNION\",").append("\"UNIT\".FEffectDate AS \"UNIT.EFFECTDATE\",").append("\"UNIT\".FInvalidDate AS \"UNIT.INVALIDDATE\",").append("\"UNIT\".FIsFreeze AS \"UNIT.ISFREEZE\",").append("\"UNIT\".FOrgTypeStr AS \"UNIT.FOrgTypeStr\",").append("\"TREE\".FID AS \"TREE.ID\",").append("\"TREE\".FType AS \"TREE.TYPE\",").append("\"TREE\".FNumber AS \"TREE.NUMBER\",").append("\"UNIT\".FIsAssistantOrg AS \"UNIT.ISASSISTANTORG\",").append("\"ORGSTRUCTURE\".FSortCode AS \"SORTCODE\",").append(simpleLeftJoinField);
        Locale curlocal = ctx.getLocale();
        String querySql = StringUtils.replace((String)sb.toString(), (String)"_L2", (String)("_" + curlocal));
        return querySql;
    }

    public String getQueryFieldStr(Context ctx) throws EASBizException, BOSException {
        String leftJoinField = OrgTypeAppCenter.getInstance().getLeftJoinSimpleFiled(ctx, "BIZOBJ_PART");
        StringBuffer sb = new StringBuffer("");
        sb.append("\"ORGSTRUCTURE\".FID AS \"ID\",").append("\"ORGSTRUCTURE\".FLongNumber AS \"LONGNUMBER\",").append("\"ORGSTRUCTURE\".FLevel AS \"LEVEL\",").append("\"ORGSTRUCTURE\".FIsLeaf AS \"ISLEAF\",").append("\"ORGSTRUCTURE\".FIsValid AS \"ISVALID\",").append("\"ORGSTRUCTURE\".FParentID AS \"PARENT.ID\",").append("\"UNIT\".FID AS \"UNIT.ID\",").append("\"UNIT\".FNumber AS \"UNIT.NUMBER\",").append("\"UNIT\".FName_L2 AS \"UNIT.NAME\",").append("\"UNIT\".FSimpleName AS \"UNIT.SIMPLENAME\",").append("\"UNIT\".FDescription_L2 AS \"UNIT.DESCRIPTION\",").append("\"UNIT\".FLongNumber AS \"UNIT.LONGNUMBER\",").append("\"UNIT\".FLevel AS \"UNIT.LEVEL\",").append("\"UNIT\".FIsLeaf AS \"UNIT.ISLEAF\",").append("\"UNIT\".FIsGrouping AS \"UNIT.ISGROUPING\",").append("\"UNIT\".FIsUnion AS \"UNIT.ISUNION\",").append("\"UNIT\".FEffectDate AS \"UNIT.EFFECTDATE\",").append("\"UNIT\".FInvalidDate AS \"UNIT.INVALIDDATE\",").append("\"UNIT\".FIsFreeze AS \"UNIT.ISFREEZE\",").append("\"UNIT\".FCreateTime AS \"UNIT.CREATETIME\",").append("\"UNIT\".FLastUpdateTime AS \"UNIT.LASTUPDATETIME\",").append("\"UNIT\".FOrgTypeStr AS \"UNIT.FOrgTypeStr\",").append("\"UNIT\".FCode AS \"UNIT.Code\",").append("\"TREE\".FID AS \"TREE.ID\",").append("\"TREE\".FType AS \"TREE.TYPE\",").append("\"TREE\".FNumber AS \"TREE.NUMBER\",").append("\"UNIT\".FIsAssistantOrg AS \"UNIT.ISASSISTANTORG\",").append("\"ORGSTRUCTURE\".FSortCode AS \"SORTCODE\",").append(leftJoinField);
        Locale curlocal = ctx.getLocale();
        String querySql = StringUtils.replace((String)sb.toString(), (String)"_L2", (String)("_" + curlocal));
        return querySql;
    }

    public String getJoinTable() throws EASBizException, BOSException {
        String leftJoinTable = OrgTypeAppCenter.getInstance().getLeftJoinTableSql("UNIT.FID");
        StringBuffer retStr = new StringBuffer("");
        retStr.append(" FROM T_ORG_Structure AS \"ORGSTRUCTURE\" ").append(" INNER JOIN T_ORG_BaseUnit AS \"UNIT\"").append(" ON \"ORGSTRUCTURE\".FUnitId = \"UNIT\".FID ").append(" INNER JOIN T_ORG_Tree AS \"TREE\" ").append(" ON \"ORGSTRUCTURE\".FTreeId = \"TREE\".FID").append(" LEFT OUTER JOIN T_ORG_Structure AS \"PARENT\"").append(" ON \"ORGSTRUCTURE\".FParentID = \"PARENT\".FID").append(leftJoinTable);
        return retStr.toString();
    }

    private String getSqlWhere(Context ctx, String treeID, String rootUnitID, boolean isContainSealUp, boolean isShowVirtual, int level, boolean isShowAssistantOrg) throws BOSException, EASBizException {
        boolean isBasicOrg = false;
        if (StringUtils.isEmpty((String)treeID)) {
            isBasicOrg = true;
        } else {
            OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(treeID);
            if (orgTypeInfo != null) {
                isBasicOrg = orgTypeInfo.isBasicOrgType();
            }
        }
        String rootLongNumber = null;
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("SELECT TOP 1 T0.FLONGNUMBER FROM T_ORG_STRUCTURE T0 INNER JOIN T_ORG_TREE t1 ON T0.FTREEID = T1.FID INNER JOIN T_ORG_BASEUNIT t2 ON T0.FUNITID = T2.FID ").append(" WHERE T2.FID = '").append(rootUnitID).append("' AND T1.FID ='").append(treeID).append("' ORDER BY T0.FLONGNUMBER ASC");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlbf.toString());
        try {
            while (rs.next()) {
                rootLongNumber = rs.getString(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (rootLongNumber == null) {
            rootLongNumber = "###@$@###";
        }
        StringBuffer queryWhereSb = new StringBuffer();
        queryWhereSb.append(" TREE.fID ='").append(treeID).append("'").append(" and  ORGSTRUCTURE.fISVALID = 1 ");
        if (!rootUnitID.equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
            queryWhereSb.append(" and (ORGSTRUCTURE.flongNumber ='").append(rootLongNumber).append("'").append(" or ORGSTRUCTURE.flongNumber like '").append(rootLongNumber).append("!%')");
        }
        if (!isContainSealUp && isBasicOrg) {
            if (!treeID.equals("00000000-0000-0000-0000-0000000000014F2827FD") && !treeID.equals("00000000-0000-0000-0000-0000000000094F2827FD")) {
                queryWhereSb.append("  and ").append(this.getSealUpColumnName(treeID)).append(" = 0");
            } else if (treeID.equals("00000000-0000-0000-0000-0000000000014F2827FD")) {
                queryWhereSb.append(" and UNIT.fisOUSealUp = 0 ");
            }
        }
        if (!isShowVirtual && treeID.equals("00000000-0000-0000-0000-0000000000034F2827FD")) {
            String adminTableAlias = OrgTypeAppCenter.getInstance().getHelper(OrgType.Admin).getOrgTypeSelfInfo().getTableNameAlias();
            queryWhereSb.append(" and ").append(adminTableAlias).append(".fisVirtual = 0");
        }
        if (level > 0) {
            queryWhereSb.append(" and ORGSTRUCTURE.flevel <=").append(level);
        }
        if (!isShowAssistantOrg) {
            queryWhereSb.append(" and UNIT.fisAssistantOrg = 0");
        }
        return queryWhereSb.toString();
    }

    private Object getSealUpColumnName(String treeID) {
        OrgType orgType = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(treeID).getOrgType();
        String adminTableAlias = OrgTypeAppCenter.getInstance().getHelper(orgType).getOrgTypeSelfInfo().getTableNameAlias();
        return adminTableAlias + ".fisSealUp";
    }
}

