/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.TableAssistInfo;
import com.kingdee.eas.basedata.org.app.helper.TreeNodeTypeAssemblage;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UnitAssemblage
extends TreeNodeTypeAssemblage {
    private static Logger logger = Logger.getLogger((String)UnitAssemblage.class.getName());

    @Override
    protected List buildInfoByResultSet(Context ctx, IRowSet rs) throws BOSException {
        ArrayList<FullOrgUnitInfo> result = new ArrayList<FullOrgUnitInfo>();
        try {
            while (rs.next()) {
                FullOrgUnitInfo info = new FullOrgUnitInfo();
                info.setId(BOSUuid.read((String)rs.getString(1)));
                info.setName(rs.getString(2));
                info.setNumber(rs.getString(3));
                info.setLongNumber(rs.getString(4));
                info.setLevel(rs.getInt(5));
                info.setIsLeaf(rs.getBoolean(6));
                info.setIsUnion(rs.getBoolean(7));
                info.setIsCU(rs.getBoolean(8));
                result.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected Map<String, List<String>> handleSelectors(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        if (null == ctx) {
            throw new BOSException("context can't be null.");
        }
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("FID");
        columns.add("FName_" + ctx.getLocale().toString());
        columns.add("FNumber");
        columns.add("FLongnumber");
        columns.add("FLevel");
        columns.add("FIsleaf");
        columns.add("FIsUnion");
        columns.add("FIsCU");
        result.put("\"BASEUNIT\"", columns);
        return result;
    }

    @Override
    protected List<String> handleSortItems(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        ArrayList<String> sortItems = new ArrayList<String>();
        sortItems.add("\"BASEUNIT\".FLongNumber");
        return sortItems;
    }

    @Override
    protected List<TableAssistInfo> handleTables(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        ArrayList<TableAssistInfo> result = new ArrayList<TableAssistInfo>();
        TableAssistInfo tableInfo = new TableAssistInfo();
        tableInfo.setTableName("T_ORG_BASEUNIT");
        tableInfo.setTableAlias("\"BASEUNIT\"");
        result.add(tableInfo);
        return result;
    }

    @Override
    protected String buildQuerySQL(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        if (!StringUtils.isEmpty((String)assistInfo.getQuickQueryValue()) || assistInfo.isNeedConsiderFaultTree()) {
            String sortItems;
            StringBuffer querySQL = new StringBuffer();
            String filterItems = this.buildFilterItems(ctx, selectedNode, assistInfo);
            String selectors = this.buildSelectors(ctx, selectedNode, assistInfo);
            if (StringUtils.isEmpty((String)selectors)) {
                throw new BOSException("selectors can't be null.");
            }
            querySQL.append("select ").append(selectors).append(" from ").append("T_ORG_BASEUNIT ").append("\"BASEUNIT\"");
            if (!StringUtils.isEmpty((String)filterItems)) {
                querySQL.append(" where ").append(filterItems);
            }
            if (!StringUtils.isEmpty((String)(sortItems = this.buildOrderItems(ctx, selectedNode, assistInfo)))) {
                querySQL.append(" order by ").append(sortItems);
            }
            return querySQL.toString();
        }
        return super.buildQuerySQL(ctx, selectedNode, assistInfo);
    }

    @Override
    protected String buildFilterItems(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        if (!StringUtils.isEmpty((String)assistInfo.getQuickQueryValue()) || assistInfo.isNeedConsiderFaultTree()) {
            String tables;
            String selectedNodeLNum = (String)selectedNode.get("longNumber");
            if (StringUtils.isEmpty((String)selectedNodeLNum)) {
                logger.info((Object)"selectedNode's longNumber is null.Get Default root longNumber instead.");
                selectedNodeLNum = this.getDefaultRootLongNumber(ctx);
            }
            StringBuffer tmp = new StringBuffer();
            String filterItems = super.buildFilterItems(ctx, selectedNode, assistInfo);
            if (!StringUtils.isEmpty((String)filterItems)) {
                tmp.append(" where ").append(filterItems);
                if (!StringUtils.isEmpty((String)assistInfo.getExtraFilters())) {
                    tmp.append(" ").append(assistInfo.getExtraFilters());
                }
            } else if (!StringUtils.isEmpty((String)assistInfo.getExtraFilters())) {
                tmp.append(" where ").append(assistInfo.getExtraFilters());
            }
            if (StringUtils.isEmpty((String)(tables = this.buildTables(ctx, selectedNode, assistInfo)))) {
                throw new BOSException("tables can't be null.");
            }
            StringBuffer result = new StringBuffer();
            StringBuffer longNumber = new StringBuffer().append("\"BASEUNIT\"").append(".FLongNumber");
            result.append("\"BASEUNIT\"").append(".FParentId ='").append(selectedNode.getId().toString()).append("' and ").append(longNumber).append(" in (").append("select distinct substring(").append(longNumber).append(", 0, CHARINDEX('!', ").append(longNumber).append("||'!', ").append(selectedNodeLNum.length() + 2).append(")-1) ").append("AS FVALIDLN").append(" from ").append(tables).append(tmp).append(")");
            return result.toString();
        }
        return super.buildFilterItems(ctx, selectedNode, assistInfo);
    }

    @Override
    protected List<String> handleFilterItems(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        ArrayList<String> filterItems = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        if (!StringUtils.isEmpty((String)assistInfo.getQuickQueryValue()) || assistInfo.isNeedConsiderFaultTree()) {
            sb.append("\"BASEUNIT\"").append(".FLongNumber like ?");
        } else {
            sb.append("\"BASEUNIT\"").append(".FParentID = ?");
        }
        filterItems.add(sb.toString());
        return filterItems;
    }

    @Override
    protected List<Object> getObjParams(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        ArrayList<Object> objParams = new ArrayList<Object>();
        if (!StringUtils.isEmpty((String)assistInfo.getQuickQueryValue()) || assistInfo.isNeedConsiderFaultTree()) {
            String selectedNodeLNum = selectedNode.getString("longNumber");
            if (StringUtils.isEmpty((String)selectedNodeLNum)) {
                objParams.add("nodata");
            } else {
                objParams.add(selectedNodeLNum + "!%");
            }
        } else {
            objParams.add(selectedNode.getId().toString());
        }
        return objParams;
    }

    private String getDefaultRootLongNumber(Context ctx) throws BOSException {
        try {
            FullOrgUnitInfo defaultRoot = FullOrgUnitFactory.getLocalInstance(ctx).getFullOrgUnitInfo((IObjectPK)new ObjectStringPK("00000000-0000-0000-0000-000000000000CCE7AED4"));
            if (defaultRoot != null) {
                return defaultRoot.getLongNumber();
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }
}

