/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.helper;

import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OUPartCtrlInfo;
import com.kingdee.eas.basedata.org.OrgAlterPageEnum;
import com.kingdee.eas.basedata.org.OrgSpecialTalbesEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgTypeForEntityEnum;
import com.kingdee.eas.basedata.org.OrgTypeForF7;
import com.kingdee.eas.basedata.org.OrgTypeForOrgSwitchingEnum;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.helper.IOrgTypeAddNewInfo;
import com.kingdee.eas.basedata.org.helper.OrgConfigHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ClassUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class OrgTypeInfoMgr {
    private static Logger logger = Logger.getLogger((String)OrgTypeInfoMgr.class.getName());
    public static final String PROPERTIES_DIR_ENV_NAME = "eas.deploy";
    private static Map allBizOrgMap = new HashMap();
    private static OrgTypeInfoMgr instance = null;
    private static boolean loadExtOrgType = false;
    public static final String CLIENTROOT_DIR_ENV_NAME = "easclient.root";
    private static Map allStandardOrgMap = new HashMap();
    private static Set allBizOrgSet = new TreeSet();

    private OrgTypeInfoMgr() {
        OrgTypeInfo none = new OrgTypeInfo("", OrgType.NONE, "com.kingdee.eas.basedata.org.client.uihelper.imp.OrgTypeNoneHelper", "com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.OrgAppNoneImpl", null, null, OrgTypeForEntityEnum.NULL, null, OrgTypeForOrgSwitchingEnum.ALL, new FullOrgUnitInfo().getBOSType(), null, OrgTypeForF7.All, OrgAlterPageEnum.PAGE_BASIC);
        allBizOrgMap.put(none.getOrgType(), none);
        OrgTypeInfo ctrl = new OrgTypeInfo("", OrgType.ControlUnit, "com.kingdee.eas.basedata.org.client.uihelper.imp.OrgTypeAdminHelper", "com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.OrgAppCtrlImpl", OrgSpecialTalbesEnum.CtrlUnit, "00000000-0000-0000-0000-0000000000014F2827FD", null, OrgViewType.CTRLUNIT, OrgTypeForOrgSwitchingEnum.CU, new CtrlUnitInfo().getBOSType(), new OUPartCtrlInfo().getBOSType(), OrgTypeForF7.ControlUnit, null);
        allBizOrgMap.put(ctrl.getOrgType(), ctrl);
    }

    public static synchronized OrgTypeInfoMgr getInstance() {
        if (instance == null) {
            instance = new OrgTypeInfoMgr();
        }
        if (!loadExtOrgType) {
            OrgTypeInfoMgr.initOrgTypeMgrExt();
            loadExtOrgType = true;
        }
        return instance;
    }

    public void clear() {
        instance = null;
        allBizOrgMap.clear();
    }

    public void clearAll() {
        instance = null;
        allBizOrgMap.clear();
        loadExtOrgType = false;
        allBizOrgSet.clear();
    }

    public static void addOrgTypeInfo(OrgTypeInfo[] orgTypeInfo) {
        if (orgTypeInfo == null || orgTypeInfo.length == 0) {
            return;
        }
        OrgType orgType = null;
        for (int i = 0; i < orgTypeInfo.length; ++i) {
            orgType = orgTypeInfo[i].getOrgType();
            if (orgType == null) continue;
            OrgTypeInfoMgr.addOrgTypeInfo(orgTypeInfo[i]);
        }
    }

    public static void addOrgTypeInfo(OrgTypeInfo orgTypeInfo) {
        if (orgTypeInfo == null || orgTypeInfo.getOrgType() == null) {
            return;
        }
        OrgType orgType = orgTypeInfo.getOrgType();
        if (!allBizOrgMap.containsKey((Object)orgTypeInfo.getOrgType())) {
            allBizOrgMap.put(orgTypeInfo.getOrgType(), orgTypeInfo);
            loadExtOrgType = true;
        }
    }

    public Collection getAllOrgTypeInfo() {
        return Collections.unmodifiableCollection(allBizOrgMap.values());
    }

    public OrgTypeInfo getOrgTypeInfoByOrgType(OrgType orgType) {
        return (OrgTypeInfo)allBizOrgMap.get((Object)orgType);
    }

    public OrgTypeInfo getOrgTypeInfo(String treeID) {
        if (StringUtils.isEmpty((String)treeID)) {
            throw new IllegalArgumentException(" treeID is null!");
        }
        Collection orgTypeInfoCol = this.getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : orgTypeInfoCol) {
            if (orgTypeInfo.getOrgTreeID() == null || !orgTypeInfo.getOrgTreeID().equals(treeID)) continue;
            return orgTypeInfo;
        }
        return null;
    }

    public OrgTypeInfo getOrgTypeInfo(OrgTypeForEntityEnum entityOrgTypeEnum) {
        Collection orgTypeInfoCol = this.getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : orgTypeInfoCol) {
            if (entityOrgTypeEnum != orgTypeInfo.getOrgTypeForEntityEnum()) continue;
            return orgTypeInfo;
        }
        throw new IllegalArgumentException(" treeID is not support! OrgTypeForEntityEnum is:" + (Object)((Object)entityOrgTypeEnum));
    }

    public OrgTypeInfo getOrgTypeInfo(OrgViewType orgViewType) {
        Collection orgTypeInfoCol = this.getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : orgTypeInfoCol) {
            if (orgViewType != orgTypeInfo.getOrgViewType()) continue;
            return orgTypeInfo;
        }
        throw new IllegalArgumentException(" treeID is not support! OrgViewType is:" + (Object)((Object)orgViewType));
    }

    public OrgTypeInfo getOrgTypeInfo(OrgTypeForOrgSwitchingEnum switchOrgType) {
        Collection orgTypeInfoCol = this.getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : orgTypeInfoCol) {
            if (switchOrgType != orgTypeInfo.getOrg4Switch()) continue;
            return orgTypeInfo;
        }
        throw new IllegalArgumentException(" treeID is not support! OrgTypeForOrgSwitchingEnum is:" + (Object)((Object)switchOrgType));
    }

    public OrgTypeInfo getOrgTypeInfoByOrgAlterPageEnum(int alterPage) {
        Collection orgTypeInfoCol = this.getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : orgTypeInfoCol) {
            if (orgTypeInfo == null || orgTypeInfo.getOrgAlterEnum() == null || alterPage != orgTypeInfo.getOrgAlterEnum().getValue()) continue;
            return orgTypeInfo;
        }
        throw new IllegalArgumentException(" treeID is not support! OrgAlterPageEnum is:" + alterPage);
    }

    public OrgTypeInfo getOrgTypeInfoByOrgTypeIntValue(int alterPage) {
        Collection orgTypeInfoCol = this.getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : orgTypeInfoCol) {
            if (alterPage != orgTypeInfo.getOrgType().getValue()) continue;
            return orgTypeInfo;
        }
        throw new IllegalArgumentException(" treeID is not support! OrgType is:" + alterPage);
    }

    public OrgTypeInfo getOrgTypeInfo(OrgTypeForF7 orgTypeForF7) {
        Collection orgTypeInfoCol = this.getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : orgTypeInfoCol) {
            if (orgTypeForF7 != orgTypeInfo.getOrgTypeF7()) continue;
            return orgTypeInfo;
        }
        throw new IllegalArgumentException(" treeID is not support! orgTypeForF7 is:" + (Object)((Object)orgTypeForF7));
    }

    public OrgTypeInfo getOrgTypeInfo(BOSObjectType bosType) {
        Collection orgTypeInfoCol = this.getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : orgTypeInfoCol) {
            if (!bosType.equals((Object)orgTypeInfo.getBosType()) && !bosType.equals((Object)orgTypeInfo.getPartBosType())) continue;
            return orgTypeInfo;
        }
        throw new IllegalArgumentException(" treeID is not support! bosType is:" + bosType);
    }

    public OrgTypeInfo getOrgTypeInfo(OrgSpecialTalbesEnum entityOrgTypeEnum) {
        Collection orgTypeInfoCol = this.getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : orgTypeInfoCol) {
            if (entityOrgTypeEnum != orgTypeInfo.getSpecialTalbesEnum()) continue;
            return orgTypeInfo;
        }
        if (OrgSpecialTalbesEnum.AdminToHR == entityOrgTypeEnum || OrgSpecialTalbesEnum.AdminToFI == entityOrgTypeEnum) {
            return null;
        }
        throw new IllegalArgumentException(" treeID is not support! OrgSpecialTalbesEnum is:" + (Object)((Object)entityOrgTypeEnum));
    }

    public OrgTypeInfo getOrgTypeInfo(OrgType orgType) {
        Collection orgTypeInfoCol = this.getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : orgTypeInfoCol) {
            if (orgType != orgTypeInfo.getOrgType()) continue;
            return orgTypeInfo;
        }
        throw new IllegalArgumentException(" treeID is not support! orgType is:" + (Object)((Object)orgType));
    }

    public boolean isLoadExtOrgType() {
        return loadExtOrgType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAllOrgType() {
        Set set = allBizOrgSet;
        synchronized (set) {
            if (allBizOrgSet.isEmpty()) {
                allBizOrgSet.addAll(allBizOrgMap.keySet());
            }
        }
        return allBizOrgSet;
    }

    private static void initOrgTypeMgrExt() {
        List clazzList = OrgTypeInfoMgr.initClazzList();
        List orgTypeInitList = OrgTypeInfoMgr.createOrgTypeInitList(clazzList);
        for (int i = 0; i < orgTypeInitList.size(); ++i) {
            IOrgTypeAddNewInfo iOrgTypeAdd = (IOrgTypeAddNewInfo)orgTypeInitList.get(i);
            OrgTypeInfo[] orgTypeInfo = iOrgTypeAdd.getOrgType();
            OrgTypeInfoMgr.addOrgTypeInfo(orgTypeInfo);
        }
    }

    private static List initClazzList() {
        return OrgConfigHelper.getItemValues("OrgTypeInit");
    }

    private static List createOrgTypeInitList(List clazzList) {
        ArrayList<IOrgTypeAddNewInfo> retList = new ArrayList<IOrgTypeAddNewInfo>();
        for (int i = 0; i < clazzList.size(); ++i) {
            String clzName = (String)clazzList.get(i);
            IOrgTypeAddNewInfo newOrgTypeInfo = null;
            try {
                newOrgTypeInfo = (IOrgTypeAddNewInfo)ClassUtils.getObject4Class((String)clzName);
            }
            catch (EASBizException e) {
                logger.error((Object)"error", (Throwable)e);
            }
            if (newOrgTypeInfo == null) continue;
            retList.add(newOrgTypeInfo);
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getAllStandardOrgMap() {
        Map map = allStandardOrgMap;
        synchronized (map) {
            if (allStandardOrgMap.isEmpty()) {
                allStandardOrgMap.put(OrgType.Admin.getName(), OrgType.Admin);
                allStandardOrgMap.put(OrgType.Company.getName(), OrgType.Company);
                allStandardOrgMap.put(OrgType.Sale.getName(), OrgType.Sale);
                allStandardOrgMap.put(OrgType.Purchase.getName(), OrgType.Purchase);
                allStandardOrgMap.put(OrgType.Storage.getName(), OrgType.Storage);
                allStandardOrgMap.put(OrgType.CostCenter.getName(), OrgType.CostCenter);
                allStandardOrgMap.put(OrgType.ProfitCenter.getName(), OrgType.ProfitCenter);
                allStandardOrgMap.put(OrgType.UnionDebt.getName(), OrgType.UnionDebt);
                allStandardOrgMap.put(OrgType.ControlUnit.getName(), OrgType.ControlUnit);
                allStandardOrgMap.put(OrgType.HRO.getName(), OrgType.HRO);
                allStandardOrgMap.put(OrgType.Transport.getName(), OrgType.Transport);
                allStandardOrgMap.put(OrgType.Quality.getName(), OrgType.Quality);
            }
        }
        return allStandardOrgMap;
    }
}

