/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.metadata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.metadata.ColMetaInfo;
import com.kingdee.eas.basedata.org.metadata.OrgTypeCollection;
import com.kingdee.eas.basedata.org.metadata.OrgTypeInfo;
import com.kingdee.eas.basedata.org.metadata.cache.OrgMetaDataCacheFactory;
import com.kingdee.eas.basedata.org.metadata.ormapping.ResultSetUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class MetaDataConvertUtils {
    public static OrgTypeInfo createOrgTypeInfoFromRowSet(Context ctx, IRowSet rowset) throws BOSException {
        OrgTypeInfo orgTypeInfo = null;
        try {
            if (rowset.next()) {
                orgTypeInfo = new OrgTypeInfo();
                IRowSetMetaData rowsetMD = rowset.getRowSetMetaData();
                for (int i = 1; i <= rowsetMD.getColumnCount(); ++i) {
                    String columnName = rowsetMD.getColumnName(i);
                    ColMetaInfo colMetaInfo = OrgMetaDataCacheFactory.getCache(ctx).getColMetaInfo("T_ORG_ORGTYPE", columnName);
                    String dataType = colMetaInfo.getDataType();
                    Object columnValue = rowset.getObject(i);
                    if (columnValue == null) continue;
                    orgTypeInfo.put(columnName.toLowerCase(), ResultSetUtils.getColumnValue(columnValue, dataType));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return orgTypeInfo;
    }

    public static OrgTypeCollection createOrgTypeCollectionFromRowSet(Context ctx, IRowSet rowset) throws BOSException {
        OrgTypeCollection orgTypeCol = new OrgTypeCollection();
        OrgTypeInfo orgTypeInfo = null;
        try {
            while (rowset.next()) {
                orgTypeInfo = new OrgTypeInfo();
                IRowSetMetaData rowsetMD = rowset.getRowSetMetaData();
                for (int i = 1; i <= rowsetMD.getColumnCount(); ++i) {
                    String columnName = rowsetMD.getColumnName(i);
                    ColMetaInfo colMetaInfo = OrgMetaDataCacheFactory.getCache(ctx).getColMetaInfo("T_ORG_ORGTYPE", columnName);
                    String dataType = colMetaInfo.getDataType();
                    Object columnValue = rowset.getObject(i);
                    if (columnValue == null) continue;
                    orgTypeInfo.put(columnName.toLowerCase(), ResultSetUtils.getColumnValue(columnValue, dataType));
                }
                orgTypeCol.add(orgTypeInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return orgTypeCol;
    }

    public static ColMetaInfo createColMetaInfoFromRowSet(Context ctx, IRowSet rowset) throws BOSException {
        ColMetaInfo colMetaInfo = null;
        try {
            if (rowset.next()) {
                colMetaInfo = new ColMetaInfo();
                colMetaInfo.setTableName(rowset.getString("TABLE_NAME").toUpperCase());
                colMetaInfo.setColumnName(rowset.getString("COLUMN_NAME").toUpperCase());
                colMetaInfo.setColumnID(rowset.getInt("COLUMN_ID"));
                colMetaInfo.setDataType(rowset.getString("DATA_TYPE"));
                colMetaInfo.setColumnType(rowset.getString("COLUMN_TYPE"));
                colMetaInfo.setColumnLength(rowset.getInt("COLUMN_LENGTH"));
                colMetaInfo.setColumnPrecision(rowset.getInt("COLUMN_PRECISION"));
                colMetaInfo.setColumnScale(rowset.getInt("COLUMN_SCALE"));
                colMetaInfo.setNullable(rowset.getBoolean("NULLABLE"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return colMetaInfo;
    }

    public static Map createColMetaInfosFromRowSet(Context ctx, IRowSet rowset) throws BOSException {
        HashMap<String, ColMetaInfo> colMetaMap = new HashMap<String, ColMetaInfo>();
        try {
            ColMetaInfo colMetaInfo = null;
            while (rowset.next()) {
                colMetaInfo = new ColMetaInfo();
                colMetaInfo.setTableName(rowset.getString("TABLE_NAME").toUpperCase());
                String columnName = rowset.getString("COLUMN_NAME").toUpperCase();
                colMetaInfo.setColumnName(columnName);
                colMetaInfo.setColumnID(rowset.getInt("COLUMN_ID"));
                colMetaInfo.setDataType(rowset.getString("DATA_TYPE"));
                colMetaInfo.setColumnType(rowset.getString("COLUMN_TYPE"));
                colMetaInfo.setColumnLength(rowset.getInt("COLUMN_LENGTH"));
                colMetaInfo.setColumnPrecision(rowset.getInt("COLUMN_PRECISION"));
                colMetaInfo.setColumnScale(rowset.getInt("COLUMN_SCALE"));
                colMetaInfo.setNullable(rowset.getBoolean("NULLABLE"));
                colMetaMap.put(columnName, colMetaInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return colMetaMap;
    }
}

