/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.metadata.cache;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.IOrgMetaDataFacade;
import com.kingdee.eas.basedata.org.OrgMetaDataFacadeFactory;
import com.kingdee.eas.basedata.org.metadata.ColMetaInfo;
import com.kingdee.eas.basedata.org.metadata.OrgTypeCollection;
import com.kingdee.eas.basedata.org.metadata.OrgTypeInfo;
import com.kingdee.eas.basedata.org.metadata.cache.AbstractOrgMetaDataCache;
import com.kingdee.eas.basedata.org.metadata.cache.MetaDataCacheException;
import java.util.Map;
import org.apache.log4j.Logger;

public class DBOrgMetaDataHeavyCache
extends AbstractOrgMetaDataCache {
    private static final Logger logger = Logger.getLogger((String)DBOrgMetaDataHeavyCache.class.getName());

    protected DBOrgMetaDataHeavyCache(Context ctx) {
        super(ctx);
    }

    @Override
    protected OrgTypeInfo getOrgTypeInfoFromMDSource(int value) {
        OrgTypeCollection orgTypeCol = this.getOrgTypeCollectionFromMDSource();
        return orgTypeCol.get(new Integer(value));
    }

    @Override
    protected OrgTypeInfo getOrgTypeInfoFromMDSource(String name) {
        OrgTypeCollection orgTypeCol = this.getOrgTypeCollectionFromMDSource();
        return this.getOrgTypeInfoByName(orgTypeCol, name);
    }

    @Override
    protected OrgTypeInfo getOrgTypeInfoByTreeIDFromMDSource(String treeID) {
        OrgTypeCollection orgTypeCol = this.getOrgTypeCollectionFromMDSource();
        return this.getOrgTypeInfoByTreeID(orgTypeCol, treeID);
    }

    @Override
    protected OrgTypeCollection getOrgTypeCollectionFromMDSource() {
        if (this.cachedOrgTypeCol == null || this.cachedOrgTypeCol.size() == 0) {
            try {
                IOrgMetaDataFacade iMetaData = null;
                iMetaData = this.ctx == null ? OrgMetaDataFacadeFactory.getRemoteInstance() : OrgMetaDataFacadeFactory.getLocalInstance(this.ctx);
                this.cachedOrgTypeCol = iMetaData.getOrgTypeCollectionFromDB();
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new MetaDataCacheException(e);
            }
        }
        return this.cachedOrgTypeCol;
    }

    @Override
    protected Map getColMetaInfosFromMDSource(String tabName) {
        try {
            IOrgMetaDataFacade iMetaData = null;
            iMetaData = this.ctx == null ? OrgMetaDataFacadeFactory.getRemoteInstance() : OrgMetaDataFacadeFactory.getLocalInstance(this.ctx);
            Map colMetaMap = iMetaData.getColMetaInfosFromDB(tabName);
            if (colMetaMap != null && colMetaMap.size() > 0) {
                this.tableColMetaMap.put(tabName, colMetaMap);
            }
            return colMetaMap;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new MetaDataCacheException(e);
        }
    }

    @Override
    protected ColMetaInfo getColMetaInfoFromMDSource(String tabName, String colName) {
        ColMetaInfo colMetaInfo = null;
        Map colMetaMap = this.getColMetaInfosFromMDSource(tabName);
        if (colMetaMap != null) {
            colMetaInfo = (ColMetaInfo)colMetaMap.get(colName);
        }
        return colMetaInfo;
    }
}

