/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.privacy.PrivacyPropertyAccess;
import com.kingdee.bos.privacy.PrivacyPropertyManager;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.basedata.org.util.CharTools;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class OrgPrivacyDbUtil {
    private static Logger logger = Logger.getLogger(OrgPrivacyDbUtil.class);
    private static List<String> supportPrivacyTables = new ArrayList<String>();

    public static void executeInsertSelect(Context ctx, String sql, Object[] params) throws BOSException {
        if (!OrgPrivacyDbUtil.isInsertSelect(ctx, sql) || !OrgPrivacyDbUtil.isNeedPrivacy(ctx, sql)) {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
            return;
        }
        String[] insertSelect = OrgPrivacyDbUtil.parseInsertSelect(sql);
        if (insertSelect[0] == null || insertSelect[1] == null || insertSelect[2] == null) {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
            return;
        }
        String insertSql = insertSelect[0];
        String selectSql = insertSelect[1];
        int valuesSize = Integer.valueOf(insertSelect[2]);
        Connection conn = null;
        PreparedStatement insertPs = null;
        PreparedStatement selectPs = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            selectPs = conn.prepareStatement(selectSql);
            for (int i = 0; i < params.length; ++i) {
                selectPs.setObject(i + 1, params[i]);
            }
            rs = selectPs.executeQuery();
            int batchSize = 0;
            insertPs = conn.prepareStatement(insertSql);
            while (rs.next()) {
                for (int i = 0; i < valuesSize; ++i) {
                    insertPs.setObject(i + 1, rs.getObject(i + 1));
                }
                insertPs.addBatch();
                if (++batchSize <= 1000) continue;
                insertPs.executeBatch();
                batchSize = 0;
            }
            if (batchSize > 0) {
                insertPs.executeBatch();
            }
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)exc);
                throw new BOSException((Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, selectPs, (Connection)conn);
                SQLUtils.cleanup(insertPs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)selectPs, (Connection)conn);
        SQLUtils.cleanup((Statement)insertPs);
    }

    private static boolean isInsertSelect(Context ctx, String sql) {
        String cleanSplitSql = CharTools.cleanMulSplitChar(sql);
        String upperCaseSql = cleanSplitSql.toUpperCase();
        return upperCaseSql.startsWith("INSERT INTO ") && (upperCaseSql.indexOf(" SELECT ", 12) > -1 || upperCaseSql.indexOf(")SELECT ", 12) > -1);
    }

    private static boolean isNeedPrivacy(Context ctx, String sql) throws BOSException {
        sql = sql.toUpperCase();
        for (String tableName : supportPrivacyTables) {
            if (!sql.contains(tableName.toUpperCase())) continue;
            PrivacyPropertyAccess privacyPropertyAccess = PrivacyPropertyManager.getPrivacyPropertyAccess((Context)ctx, (String)tableName.toUpperCase());
            return privacyPropertyAccess != null;
        }
        return false;
    }

    private static String[] parseInsertSelect(String sql) {
        String cleanSplitSql = CharTools.cleanMulSplitChar(sql);
        cleanSplitSql = cleanSplitSql.toUpperCase();
        String[] insertSelect = new String[3];
        int selectStart = CharTools.getStartIndex(cleanSplitSql, "SELECT", true);
        if (selectStart < 0) {
            selectStart = cleanSplitSql.indexOf(")SELECT ") + 1;
        }
        if (selectStart < 0) {
            return insertSelect;
        }
        String selectSql = cleanSplitSql.substring(selectStart);
        String insertSql = cleanSplitSql.substring(0, selectStart);
        String[] valueParams = insertSql.split(",");
        for (int i = 0; i < valueParams.length; ++i) {
            valueParams[i] = "?";
        }
        String valueParamsStr = ToolUtils.aryToStr(Arrays.asList(valueParams), (boolean)false);
        insertSelect[0] = insertSql = insertSql + " values (" + valueParamsStr + ")";
        insertSelect[1] = selectSql;
        insertSelect[2] = String.valueOf(valueParams.length);
        return insertSelect;
    }

    public static void main(String[] args) {
        String sql = "insert into T_ORG_Company (\r\nFID,\r\nFName_L1,\r\nFName_L2,\r\nFName_L3,\r\nFNumber,\r\nFDescription_L1,\r\nFDescription_L2,\r\nFDescription_L3,\r\nFSimpleName,\r\nFIsGrouping,\r\nFEffectDate,\r\nFInvalidDate,\r\nFIsFreeze,\r\nFIsCompanyOrgUnit,\r\nFIsAdminOrgUnit,\r\nFIsSaleOrgUnit,\r\nFIsPurchaseOrgUnit,\r\nFIsStorageOrgUnit,\r\nFIsProfitOrgUnit,\r\nFIsCostOrgUnit,\r\nFIsCU,\r\nFIsUnion,\r\nFIsHROrgUnit,\r\nFCreatorID,\r\nFCreateTime,\r\nFLastUpdateUserID,\r\nFLastUpdateTime,\r\nFControlUnitID,\r\nFIsLeaf,\r\nFLevel,\r\nFLongNumber,\r\nFParentID,\r\nFTaxNumber,\r\nFIsGroup,\r\nFIsOnlyUnion,\r\nFIndustry,\r\nFBankID,\r\nFReportCurrencyID,\r\nFAccountPeriodID,\r\nFJuridicalPersonID,\r\nFAccountTableID,\r\nFAddressID,\r\nFBaseCurrencyID,\r\nFBaseExgTableID,\r\nFAdjustExgTableID,\r\nFReportConvertMode,\r\nFReportExgTableID,\r\nFIsSealUp,\r\nFIsBizUnit,\r\nFIsStart,\r\nFIsOUSealUp,\r\nFDisplayName_L1,\r\nFDisplayName_L2,\r\nFDisplayName_L3,\r\nFCompanyID, \r\nFRegion,\r\nFEconomicType,\r\nFRegisteredCapital,\r\nFSetupDate,\r\nFEndupDate,\r\nFTerritory_L1,\r\nFTerritory_L2,\r\nFTerritory_L3,\r\nFIsChurchyard,\r\nFRegisteredCode,\r\nFPropertySealUpDate,\r\nFVersionNumber,\r\nFCode,\r\nFIsAssistantOrg,\r\nFMainOrgID,\r\nFAccountSchemeID,\r\nFIsTransportOrgUnit,\r\nforgTypeStr,\r\nFIsQualityOrgUnit,\r\nFTaxRegisterName,\r\nFTaxpayerID,\r\nFAuthorizationCode,\r\nFAuthorizationKey,\r\nFActivityDate,\r\nFContact,\r\nFInvoiceNumber,\r\nFInvoiceCount,\r\nFTaxType,\r\nFBankName,\r\nFTaxCode,\r\nFContactPhone,\r\nFBankAccount,\r\nFTaxAddress)\r\nSELECT\r\nou.FID,\r\nou.FName_L1,\r\nou.FName_L2,\r\nou.FName_L3,\r\nou.FNumber,\r\nou.FDescription_L1,\r\nou.FDescription_L2,\r\nou.FDescription_L3,\r\nou.FSimpleName,\r\nou.FIsGrouping,\r\nou.FEffectDate,\r\nou.FInvalidDate,\r\nou.FIsFreeze,\r\nou.FIsCompanyOrgUnit,\r\nou.FIsAdminOrgUnit,\r\nou.FIsSaleOrgUnit,\r\nou.FIsPurchaseOrgUnit,\r\nou.FIsStorageOrgUnit,\r\nou.FIsProfitOrgUnit,\r\nou.FIsCostOrgUnit,\r\nou.FIsCU,\r\nou.FIsUnion,\r\nou.FIsHROrgUnit,\r\nou.FCreatorID,\r\nou.FCreateTime,\r\nou.FLastUpdateUserID,\r\nou.FLastUpdateTime,\r\nou.FControlUnitID,\r\nstru.FIsLeaf,\r\nstru.FLevel,\r\nstru.FLongNumber,\r\nstru1.FUnitId AS FParentID,\r\nfi.FTaxNumber,\r\nfi.FIsGroup,\r\nfi.FIsOnlyUnion,\r\nfi.FIndustry,\r\nfi.FBankID,\r\nfi.FReportCurrencyID,\r\nfi.FAccountPeriodID,\r\nfi.FJuridicalPersonID,\r\nfi.FAccountTableID,\r\nfi.FAddressID,\r\nfi.FBaseCurrencyID,\r\nfi.FBaseExgTableID,\r\nfi.FAdjustExgTableID,\r\nfi.FReportConvertMode,\r\nfi.FReportExgTableID,\r\nfi.FIsSealUp,\r\nfi.FIsBizUnit,\r\nou.FIsStart,\r\nou.FIsOUSealUp,\r\nstru.FDisplayName_L1,\r\nstru.FDisplayName_L2,\r\nstru.FDisplayName_L3,\r\nNULL AS FCompanyID, \r\nfi.FRegion,\r\nfi.FEconomicType,\r\nfi.FRegisteredCapital,\r\nfi.FSetupDate,\r\nfi.FEndupDate,\r\nfi.FTerritory_L1,\r\nfi.FTerritory_L2,\r\nfi.FTerritory_L3,\r\nfi.FIsChurchyard,\r\nfi.FRegisteredCode,\r\nfi.FPropertySealUpDate,\r\nou.FVersionNumber,\r\nou.FCode,\r\nou.FIsAssistantOrg,\r\nou.FMainOrgID,\r\nfi.FAccountSchemeID,\r\nou.FIsTransportOrgUnit,\r\nou.forgTypeStr,\r\nou.FIsQualityOrgUnit,\r\nfi.FTaxRegisterName,\r\nfi.FTaxpayerID,\r\nfi.FAuthorizationCode,\r\nfi.FAuthorizationKey,\r\nfi.FActivityDate,\r\nfi.FContact,\r\nfi.FInvoiceNumber,\r\nfi.FInvoiceCount,\r\nfi.FTaxType,\r\nfi.FBankName,\r\nfi.FTaxCode,\r\nfi.FContactPhone,\r\nfi.FBankAccount,\r\nFTaxAddress\r\nFROM T_ORG_BaseUnit ou INNER JOIN\r\nT_ORG_Structure stru ON ou.FID = stru.FUnitId LEFT OUTER JOIN\r\nT_ORG_Structure stru1 ON stru.FParentID = stru1.FID INNER JOIN\r\nT_ORG_OUPartFI fi ON ou.FID = fi.FUnitID\r\nWHERE (stru.FTreeId = '00000000-0000-0000-0000-0000000000024F2827FD')\r\n and (ou.fid=? OR stru.flongnumber like ?)";
        if (!OrgPrivacyDbUtil.isInsertSelect(null, sql)) {
            System.out.println(sql);
            return;
        }
        String[] splitInsertSelect = OrgPrivacyDbUtil.parseInsertSelect(sql);
        System.out.println(splitInsertSelect[0]);
        System.out.println(splitInsertSelect[1]);
        System.out.println(splitInsertSelect[2]);
    }

    static {
        supportPrivacyTables.add("T_ORG_COMPANY");
    }
}

