/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgView;
import com.kingdee.eas.basedata.org.OUPartCoreBaseCollection;
import com.kingdee.eas.basedata.org.OrgSpecialTalbesEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewFactory;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.common.EASBizException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class OrgTypeUtils {
    private static Logger logger = Logger.getLogger((String)OrgTypeUtils.class.getName());

    public static boolean isOrgType(OrgUnitInfo orgUnit, OrgType orgType) {
        boolean result = false;
        if (orgUnit == null || orgType == null) {
            return result;
        }
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper(orgUnit);
        return orgTypeHelper.isOrgType(orgType);
    }

    public static boolean isNeedRebuildOrgViews(FullOrgUnitInfo unitInfo, int enumValue) {
        boolean result = false;
        if (unitInfo == null) {
            return result;
        }
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(OrgSpecialTalbesEnum.getEnum(enumValue));
        if (orgTypeInfo == null) {
            return result;
        }
        return OrgTypeUtils.isOrgType((OrgUnitInfo)unitInfo, orgTypeInfo.getOrgType());
    }

    public static String getTreeid(OrgSpecialTalbesEnum orgTreeIdType) {
        return OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgTreeIdType).getOrgTreeID();
    }

    public static boolean isOrgType(OrgUnitInfo orgUnit, int intOrgType) {
        OrgType orgType = OrgType.getEnum(intOrgType);
        return OrgTypeUtils.isOrgType(orgUnit, orgType);
    }

    public static IObjectValue getPartDetailInfo(FullOrgUnitInfo fullOrgInfo, OrgType orgType) throws BOSException, EASBizException {
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add(new SelectorItemInfo("*"));
        return OrgTypeUtils.getPartDetailInfo(fullOrgInfo, orgType, sel);
    }

    public static IObjectValue getPartDetailInfo(FullOrgUnitInfo fullOrgInfo, OrgType orgType, SelectorItemCollection selector) throws BOSException, EASBizException {
        IOrgView iOrgView = OrgViewFactory.getRemoteInstance();
        ArrayList<String> orgIdList = new ArrayList<String>();
        orgIdList.add(fullOrgInfo.getId().toString());
        OUPartCoreBaseCollection oupartCol = iOrgView.getOUPartByOrgInfo(orgIdList, orgType, selector);
        if (oupartCol == null || oupartCol.isEmpty()) {
            throw new IllegalArgumentException("oupart info is not found!");
        }
        return oupartCol.getObject(0);
    }
}

