/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cloud.bean;

import com.kingdee.bos.Context;
import com.kingdee.bos.cloud.bean.AppInfo;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.MDProject;
import com.kingdee.bos.tool.PFileUtils;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class AppManager {
    private static long loadTime = -1L;
    private static Hashtable apps = new Hashtable();
    private static final String CONFIG_FILE_NAME = "applications_config.xml";
    public static final String KEY_SYS_APP_ROOT = "%cloud_app_root%";
    public static String defaultBaseMetaRoot;
    public static String defaultProjectRoot;

    public static InetAddress getLocleAddress() throws SocketException {
        InetAddress loopbackAddress = null;
        InetAddress locleAddress = null;
        Enumeration<NetworkInterface> e1 = NetworkInterface.getNetworkInterfaces();
        while (e1.hasMoreElements()) {
            NetworkInterface netif = e1.nextElement();
            Enumeration<InetAddress> e2 = netif.getInetAddresses();
            while (e2.hasMoreElements()) {
                InetAddress addr = e2.nextElement();
                if (addr.isLoopbackAddress()) {
                    loopbackAddress = addr;
                }
                if (addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isMulticastAddress()) continue;
                locleAddress = addr;
            }
        }
        return locleAddress == null ? loopbackAddress : locleAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        String appPath = System.getProperty(KEY_SYS_APP_ROOT);
        File appConfigFile = new File(appPath, CONFIG_FILE_NAME);
        if (appConfigFile == null || !appConfigFile.exists()) {
            return;
        }
        if (!apps.isEmpty() && loadTime == appConfigFile.lastModified()) {
            return;
        }
        Class<AppManager> clazz = AppManager.class;
        synchronized (AppManager.class) {
            Document doc;
            if (!apps.isEmpty() && loadTime == appConfigFile.lastModified()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            String ip = "127.0.0.1";
            try {
                InetAddress addr = AppManager.getLocleAddress();
                ip = addr.getHostAddress();
            }
            catch (SocketException e1) {
                e1.printStackTrace();
            }
            SAXBuilder builder = new SAXBuilder();
            try {
                doc = builder.build(appConfigFile);
            }
            catch (Exception e) {
                e.printStackTrace();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            Element root = doc.getRootElement();
            Element envEl = root.getChild("env");
            defaultBaseMetaRoot = envEl.getChildText("defaultBaseMetaRoot");
            String path = StringUtils.replace((String)defaultBaseMetaRoot, (String)KEY_SYS_APP_ROOT, (String)appPath);
            File defBaseRoot = new File(path);
            defaultProjectRoot = envEl.getChildText("defaultProjectRoot");
            path = StringUtils.replace((String)defaultProjectRoot, (String)KEY_SYS_APP_ROOT, (String)appPath);
            File defProjRoot = new File(path);
            List appList = root.getChild("applications").getChildren("app");
            int n = appList.size();
            for (int i = 0; i < n; ++i) {
                Element appEl = (Element)appList.get(i);
                String name = appEl.getChildText("name");
                AppInfo info = new AppInfo();
                Element contextEl = appEl.getChild("context");
                Context context = new Context();
                context.setAIS(contextEl.getChildText("ais"));
                context.setSolution(contextEl.getChildText("solution"));
                context.setLocale(new Locale(contextEl.getChildText("locale")));
                info.setContext(context);
                path = appEl.getChildText("baseMetaRoot");
                File baseRoot = null;
                if (StringUtils.isEmpty((String)path)) {
                    baseRoot = defBaseRoot;
                } else {
                    path = StringUtils.replace((String)path, (String)KEY_SYS_APP_ROOT, (String)appPath);
                    baseRoot = new File(path);
                }
                path = appEl.getChildText("projectRoot");
                File projectRoot = null;
                if (StringUtils.isEmpty((String)path)) {
                    projectRoot = new File(defProjRoot, name);
                } else {
                    path = StringUtils.replace((String)path, (String)KEY_SYS_APP_ROOT, (String)appPath);
                    projectRoot = new File(path);
                }
                File metadataRoot = new File(projectRoot, "metadata");
                MDProject project = new MDProject(projectRoot, name, baseRoot, metadataRoot);
                info.setProject((IMDProject)project);
                boolean save2Disk = Boolean.valueOf(appEl.getChildText("save2Disk"));
                info.setSave2Disk(save2Disk);
                String ormrpcUrl = appEl.getChildText("ormrpcUrl");
                ormrpcUrl = StringUtils.replace((String)ormrpcUrl, (String)"127.0.0.1", (String)ip);
                ormrpcUrl = StringUtils.replace((String)ormrpcUrl, (String)"localhost", (String)ip);
                info.setOrmrpcUrl(ormrpcUrl);
                String testUrl = appEl.getChildText("testUrl");
                testUrl = StringUtils.replace((String)testUrl, (String)"127.0.0.1", (String)ip);
                testUrl = StringUtils.replace((String)testUrl, (String)"localhost", (String)ip);
                info.setTestUrl(testUrl);
                apps.put(name, info);
            }
            loadTime = appConfigFile.lastModified();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(String name, AppInfo info) {
        Class<AppManager> clazz = AppManager.class;
        synchronized (AppManager.class) {
            apps.put(name, info);
            AppManager.store();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store() {
        String appPath = System.getProperty(KEY_SYS_APP_ROOT);
        File appConfigFile = new File(appPath, CONFIG_FILE_NAME);
        if (appConfigFile == null || !appConfigFile.exists()) {
            return;
        }
        Class<AppManager> clazz = AppManager.class;
        synchronized (AppManager.class) {
            Document doc = new Document();
            Element root = new Element("configs");
            doc.setRootElement(root);
            Element envEl = new Element("env");
            root.addContent((Content)envEl);
            Element defaultBaseMetaRootEl = new Element("defaultBaseMetaRoot");
            defaultBaseMetaRootEl.setText(defaultBaseMetaRoot);
            envEl.addContent((Content)defaultBaseMetaRootEl);
            Element defaultProjectRootEl = new Element("defaultProjectRoot");
            defaultProjectRootEl.setText(defaultProjectRoot);
            envEl.addContent((Content)defaultProjectRootEl);
            Element appsEl = new Element("applications");
            root.addContent((Content)appsEl);
            for (String name : apps.keySet()) {
                AppInfo info = (AppInfo)apps.get(name);
                Element appEl = new Element("app");
                appsEl.addContent((Content)appEl);
                appEl.addContent((Content)new Element("name").setText(name));
                appEl.addContent((Content)new Element("ormrpcUrl").setText(info.getOrmrpcUrl()));
                appEl.addContent((Content)new Element("testUrl").setText(info.getTestUrl()));
                Context ctx = info.getContext();
                Element contextEl = new Element("context");
                appEl.addContent((Content)contextEl);
                contextEl.addContent((Content)new Element("ais").setText(ctx.getAIS()));
                contextEl.addContent((Content)new Element("solution").setText(ctx.getSolution()));
                contextEl.addContent((Content)new Element("locale").setText(ctx.getLocale().getLanguage()));
                appEl.addContent((Content)new Element("save2Disk").setText(String.valueOf(info.isSave2Disk())));
                IMDProject proj = info.getProject();
                appEl.addContent((Content)new Element("baseMetaRoot").setText(proj.getBaseMetadataDir().getAbsolutePath()));
                appEl.addContent((Content)new Element("projectRoot").setText(proj.toFile().getAbsolutePath()));
            }
            Format format = Format.getRawFormat();
            format.setIndent("  ");
            XMLOutputter out = new XMLOutputter(format);
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(appConfigFile);
                out.output(doc, (OutputStream)fileOutputStream);
                loadTime = appConfigFile.lastModified();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static AppInfo getAppInfo(String projectName) {
        AppManager.init();
        return (AppInfo)apps.get(projectName);
    }

    public static Context getContext(String projectName) {
        AppInfo info = AppManager.getAppInfo(projectName);
        if (info == null) {
            return null;
        }
        return info.getContext();
    }

    public static boolean checkValid(String projectName, String userName) {
        AppInfo info = AppManager.getAppInfo(projectName);
        return info != null;
    }

    public static void remove(String projectName) {
        AppManager.init();
        AppInfo info = (AppInfo)apps.remove(projectName);
        if (info != null) {
            try {
                PFileUtils.deleteFile((File)info.getProject().toFile());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        AppManager.store();
    }
}

