/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cloud.bean;

import com.kingdee.bos.cloud.bean.ProjectInfo;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.util.Hashtable;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class ProjectInfoManager {
    private static long loadTime = -1L;
    private static Hashtable projects = new Hashtable();
    private static final String CONFIG_FILE_NAME = "projects_config.xml";
    public static final String KEY_SYS_APP_ROOT = "%cloud_web_root%";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        String appPath = System.getProperty(KEY_SYS_APP_ROOT);
        File appConfigFile = new File(appPath, CONFIG_FILE_NAME);
        if (appConfigFile == null || !appConfigFile.exists()) {
            return;
        }
        if (!projects.isEmpty() && loadTime == appConfigFile.lastModified()) {
            return;
        }
        Class<ProjectInfoManager> clazz = ProjectInfoManager.class;
        synchronized (ProjectInfoManager.class) {
            Document doc;
            if (!projects.isEmpty() && loadTime == appConfigFile.lastModified()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            SAXBuilder builder = new SAXBuilder();
            try {
                doc = builder.build(appConfigFile);
            }
            catch (Exception e) {
                e.printStackTrace();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            projects.clear();
            Element root = doc.getRootElement();
            Element projectsEl = root.getChild("projects");
            List projectList = projectsEl.getChildren("project");
            for (int i = 0; i < projectList.size(); ++i) {
                Element projectEl = (Element)projectList.get(i);
                String name = projectEl.getChildText("name");
                String url = projectEl.getChildText("url");
                ProjectInfo info = new ProjectInfo();
                info.setName(name);
                info.setUrl(url);
                projects.put(name, info);
            }
            loadTime = appConfigFile.lastModified();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static ProjectInfo getProjectInfo(String projectName) {
        ProjectInfoManager.init();
        return (ProjectInfo)projects.get(projectName);
    }

    public static ProjectInfo[] listProjectInfo(String userName) {
        ProjectInfoManager.init();
        return projects.values().toArray(new ProjectInfo[projects.size()]);
    }

    public static int checkValid(String userName, String projectName) {
        if (!StringUtils.isEmpty((String)userName) && ProjectInfoManager.getProjectInfo(projectName) != null) {
            return 0;
        }
        return -1;
    }
}

