/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cloud.command.impl;

import com.kingdee.bos.cloud.bean.AppInfo;
import com.kingdee.bos.cloud.bean.AppManager;
import com.kingdee.bos.cloud.command.AbstractCommand;
import com.kingdee.bos.cloud.utils.LogUtil;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.tools.BizMetadataUtil;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.configure.IServerMetadataStore;
import com.kingdee.bos.tool.PFileUtils;
import com.kingdee.eas.base.uict.ICloudMainMenuFacade;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import javax.servlet.ServletException;

public class DeployMetadataCommand
extends AbstractCommand {
    private static final String UPDATE_VIEW_SQL = "update T_BIM_MDVIEW SET fDeployUser=?, fDeployTime=? WHERE fProjectName=? AND fPath=?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws IOException, ServletException {
        String[] pks = this.request.getParameter("metadatapks").split(";");
        IServerMetadataStore store = this.getServerMetadataStore();
        logger.info((Object)LogUtil.filterLogForging("User:" + this.getUserName() + " deploy metadata :" + this.request.getParameter("metadatapks")));
        String projectName = this.getProjectName();
        AppInfo info = AppManager.getAppInfo(projectName);
        IMetaDataPK[] tablePKs = null;
        IMDProject project = info.getProject();
        ArrayList list = new ArrayList();
        IMDFolder root = project.getRoot();
        for (int i = 0; i < pks.length; ++i) {
            IMDFile file = root.getChildFile(pks[i]);
            BizMetadataUtil.getBizRelateMetas((IMDFile)file, list, (boolean)false);
        }
        ArrayList<MetaDataPK> tables = new ArrayList<MetaDataPK>();
        Connection conn = null;
        try {
            conn = this.getConnection();
            conn.setAutoCommit(true);
            PreparedStatement pstmt = conn.prepareStatement(UPDATE_VIEW_SQL);
            pstmt.setString(1, this.getUserName());
            pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            pstmt.setString(3, this.getProjectName());
            HashSet<IMDFile> set = new HashSet<IMDFile>();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                IMDFile file = (IMDFile)list.get(i);
                if (file.getExtension().equals("table")) {
                    tables.add(file.getMetaDataPK());
                }
                if (!file.toFile().exists()) continue;
                String xml = PFileUtils.getFileContent((File)file.toFile());
                logger.info((Object)("sotre to db:" + file.getPath()));
                store.saveXml(DEFAULT_PROJECT, (IMetaDataPK)file.getMetaDataPK(), file.getBOSType(), xml);
                pstmt.setString(4, file.getPath());
                pstmt.executeUpdate();
                IMDFolder folder = file.getParent();
                while (!folder.isRoot()) {
                    IMDFile pkFile = folder.getChildFile(folder.getName() + ".package");
                    if (!set.contains(pkFile) && pkFile.toFile().exists()) {
                        set.add(pkFile);
                    }
                    folder = folder.getParent();
                }
            }
            for (IMDFile file : set) {
                logger.info((Object)("sotre to db:" + file.getPath()));
                String xml = PFileUtils.getFileContent((File)file.toFile());
                store.saveXml(DEFAULT_PROJECT, (IMetaDataPK)file.getMetaDataPK(), file.getBOSType(), xml);
                pstmt.setString(4, file.getPath());
                pstmt.executeUpdate();
            }
            pstmt.close();
        }
        catch (Exception ex) {
            this.response.sendError(401, "store to db error:" + this.getTrace(ex));
            return;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        tablePKs = tables.toArray(new IMetaDataPK[tables.size()]);
        ICloudMainMenuFacade facade = this.getCloudFacade();
        try {
            facade.synchronizeTables(tablePKs);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.response.sendError(401, "synchronize db error:" + this.getTrace(e));
            return;
        }
    }
}

