/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cloud.command.impl;

import com.kingdee.bos.cloud.command.AbstractCommand;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;

public class QueryMetadataStatusCommand
extends AbstractCommand {
    private static final String SQL_SELECT = "SELECT fMD5, fCheckOutUser, fLastModifyUser, fLastModifyTime, fDeployTime, fCreateTime, fCreator FROM T_BIM_MDVIEW WHERE fProjectName=? AND fPath=?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws IOException, ServletException {
        String[] mainPKs = this.request.getParameter("metadatapks").trim().split(";");
        Connection conn = null;
        HashMap<String, Properties> status = new HashMap<String, Properties>();
        try {
            conn = this.getConnection();
            PreparedStatement pstmt = conn.prepareStatement(SQL_SELECT);
            String projName = this.getProjectName();
            pstmt.setString(1, projName);
            for (int i = 0; i < mainPKs.length; ++i) {
                String path = mainPKs[i].trim();
                pstmt.setString(2, path);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    Timestamp time;
                    Properties prop = new Properties();
                    prop.setProperty("md5", rs.getString(1));
                    if (!StringUtils.isEmpty((String)rs.getString(2))) {
                        prop.setProperty("checkoutuser", rs.getString(2));
                    }
                    if (!StringUtils.isEmpty((String)rs.getString(3))) {
                        prop.setProperty("lastmodifyuser", rs.getString(3));
                    }
                    if ((time = rs.getTimestamp(4)) != null) {
                        prop.setProperty("lastmodifytime", String.valueOf(time.getTime()));
                    }
                    if ((time = rs.getTimestamp(5)) != null) {
                        prop.setProperty("deploytime", String.valueOf(time.getTime()));
                    }
                    if ((time = rs.getTimestamp(6)) != null) {
                        prop.setProperty("createtime", String.valueOf(time.getTime()));
                    }
                    if (!StringUtils.isEmpty((String)rs.getString(7))) {
                        prop.setProperty("creator", rs.getString(7));
                    }
                    status.put(path, prop);
                } else {
                    status.put(path, null);
                }
                rs.close();
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bout);
            out.writeObject(status);
            out.flush();
            ServletOutputStream rOut = this.response.getOutputStream();
            rOut.write(bout.toByteArray());
            rOut.flush();
            rOut.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.response.sendError(601, "get connection error, the track is:" + this.getTrace(ex));
            return;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

