/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.definition;

import com.kingdee.bos.eventbus.application.IApplication;
import com.kingdee.bos.eventbus.definition.ComponentClassLoaderHolder;
import com.kingdee.bos.eventbus.definition.ComponentType;
import com.kingdee.bos.eventbus.definition.IComponentInitialize;
import com.kingdee.bos.eventbus.definition.IDefinition;
import com.kingdee.bos.eventbus.definition.IMetaMerge;
import com.kingdee.bos.eventbus.definition.MethodDefinition;
import com.kingdee.bos.eventbus.definition.Property;
import com.kingdee.bos.eventbus.exception.ComponentInstanceCreateException;
import com.kingdee.bos.eventbus.exception.EventCreateException;
import com.kingdee.bos.eventbus.expression.ExpressionParser;
import com.kingdee.bos.eventbus.expression.ValueExpressionEvaluator;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.beanutils.BeanUtils;

public abstract class AbstractComponentMeta
implements Serializable,
IDefinition,
Cloneable {
    private String name;
    private Collection<Property> properties;
    protected ComponentType type;
    private MethodDefinition initMethod;
    private MethodDefinition destroyMethod;

    protected AbstractComponentMeta() {
    }

    public AbstractComponentMeta(String name) {
        this.name = name;
    }

    private MethodDefinition getInitMethod() {
        return this.initMethod;
    }

    void setInitMethod(MethodDefinition initMethod) {
        this.initMethod = initMethod;
    }

    void setDestroyMethod(MethodDefinition destroyMethod) {
        this.destroyMethod = destroyMethod;
    }

    MethodDefinition getDestroyMethod() {
        return this.destroyMethod;
    }

    void setProperties(Collection<Property> properties) {
        this.properties = properties;
    }

    public void addProperty(Property property) {
        if (this.properties == null) {
            this.properties = new ArrayList<Property>();
        } else {
            Iterator<Property> iter = this.properties.iterator();
            while (iter.hasNext()) {
                if (!property.getName().equals(iter.next().getName())) continue;
                iter.remove();
                break;
            }
        }
        this.properties.add(property);
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    protected final void executePropertySetter(IApplication application, Object instance) {
        if (this.properties == null || this.properties.size() == 0) {
            return;
        }
        for (Property property : this.properties) {
            try {
                Object value = property.getValue();
                ValueExpressionEvaluator evaluator = new ValueExpressionEvaluator(application.getServicesAccess(), value);
                BeanUtils.setProperty((Object)instance, (String)property.getName(), (Object)evaluator.evaluate());
            }
            catch (Exception e) {
                throw new EventCreateException(String.format("The property {%s} of {%s} event {%s} was not built right!", property.getName(), this.type.toString(), this.name), e);
            }
        }
    }

    public final Object createInstance() {
        return this.createInstance(null);
    }

    public final Object createInstance(IApplication application) {
        Object instance = null;
        try {
            instance = this.findClass().newInstance();
            this.executePropertySetter(application, instance);
            if (application instanceof IComponentInitialize) {
                ((IComponentInitialize)((Object)application)).afterComponentCreate(instance);
            }
            this.executeInitMethod(instance);
        }
        catch (Exception e) {
            throw new ComponentInstanceCreateException(String.format("\u7c7b {%s} \u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5! component {%s} created unsuccessfully!", this.name, this.type.toString()), e);
        }
        return instance;
    }

    protected final void executeInitMethod(Object instance) throws Exception {
        if (this.initMethod == null) {
            return;
        }
        this.initMethod.execute(instance);
    }

    public final Class findClass() {
        try {
            Class<?> clazz = this.getDefaultClassLoader().loadClass(this.name.trim());
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new ComponentInstanceCreateException(String.format("\u7c7b  %s \u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5! component %s created unsuccessfully!", this.name, this.type.toString()));
        }
    }

    @Override
    public void mergeFrom(IMetaMerge from) {
        if (from == null || !(from instanceof AbstractComponentMeta)) {
            return;
        }
        AbstractComponentMeta fromComp = (AbstractComponentMeta)from;
        if (StringUtils.isEmpty((String)this.getName())) {
            this.setName(fromComp.getName());
        }
        if (this.initMethod == null) {
            this.initMethod = fromComp.getInitMethod();
        }
        if (this.properties == null) {
            this.properties = fromComp.properties;
        } else if (fromComp.properties != null) {
            HashMap<String, Property> map = new HashMap<String, Property>(this.properties.size());
            for (Property property : this.properties) {
                map.put(property.getName(), property);
            }
            for (Property property : fromComp.properties) {
                if (!map.containsKey(property.getName())) {
                    this.properties.add(property);
                    continue;
                }
                if (!(((Property)map.get(property.getName())).getValue() instanceof String)) continue;
                String value = (String)((Property)map.get(property.getName())).getValue();
                String fromValue = (String)property.getValue();
                String expr = this.mergeArrayString(value.trim(), fromValue.trim());
                if (expr == null) continue;
                this.properties.add(new Property(property.getName(), expr));
            }
        }
    }

    private String mergeArrayString(String value, String fromValue) {
        if (!ExpressionParser.getInstance().isJSONArray(value)) {
            return null;
        }
        String expr1 = value.substring(1, value.length() - 1);
        String expr2 = fromValue.substring(1, fromValue.length() - 1);
        return "[" + expr2 + "," + expr1 + "]";
    }

    @Override
    public boolean isIntegral() {
        return false;
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractComponentMeta c = (AbstractComponentMeta)super.clone();
        if (this.properties != null) {
            Collection ps;
            c.properties = ps = (Collection)((ArrayList)this.properties).clone();
        }
        return c;
    }

    Collection<Property> getProperties() {
        return this.properties;
    }

    public boolean isSimple() {
        return (this.properties == null || this.properties.size() == 0) && this.initMethod == null;
    }

    public final void destroyInstance(Object instance) throws Exception {
        if (this.destroyMethod == null) {
            return;
        }
        this.destroyMethod.execute(instance);
    }

    ClassLoader getDefaultClassLoader() {
        return ComponentClassLoaderHolder.getComponentClassLoader();
    }
}

