/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.definition;

import com.kingdee.bos.eventbus.exception.RuleExecuteException;
import com.kingdee.bos.expression.ExpressionEvaluator;
import com.kingdee.bos.expression.ExpressionExecutor;
import com.kingdee.bos.expression.ExpressionToken;
import com.kingdee.bos.meta.entity.IEntityMetadata;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class RuleDefinition {
    private String id;
    private String description;
    private String expression;
    private String preparedExpression;
    private Map<String, Set<String>> expressionVariables;

    public RuleDefinition(String id, String description, String expression) {
        this.id = id;
        this.description = description;
        this.expression = expression;
    }

    public String getId() {
        return this.id;
    }

    public String getExpression() {
        return this.expression;
    }

    public RuleDefinition(String expression) {
        this.expression = expression;
    }

    public Object evaluateValue(List context) {
        if (this.preparedExpression == null) {
            throw new RuleExecuteException("Please execute cprepareExpression(IEntityMetadata entityMetadata) method first.");
        }
        return ExpressionEvaluator.evaluate(this.preparedExpression, context);
    }

    public boolean hasVariableWithPrefix(String prefix) {
        return this.expressionVariables.containsKey(prefix);
    }

    public Set<String> getVariableWithPrefix(String prefix) {
        return this.expressionVariables.get(prefix);
    }

    public void prepareExpression(IEntityMetadata entityMetadata) {
        if (this.preparedExpression != null) {
            return;
        }
        this.expressionVariables = new HashMap<String, Set<String>>();
        Set<String> properties = entityMetadata.getPropertyNames();
        ExpressionExecutor ee = new ExpressionExecutor();
        List<ExpressionToken> expTokens = ee.analyze(this.expression);
        int size = expTokens.size();
        for (int i = 0; i < size; ++i) {
            ExpressionToken expToken = expTokens.get(i);
            String prefix = this.getVariableRightPreffix(properties, expTokens, i, expToken);
            if (prefix == null) continue;
            String variableName = prefix + expToken.getVariable().getVariableName();
            expTokens.set(i, ExpressionToken.createVariableToken(variableName));
            this.putVaribleInMap(prefix, expToken.getVariable().getVariableName());
        }
        this.preparedExpression = ee.tokensToExpression(expTokens);
    }

    private void putVaribleInMap(String preffix, String variableName) {
        Set<String> set = this.expressionVariables.get(preffix);
        if (set == null) {
            set = new HashSet<String>();
            this.expressionVariables.put(preffix, set);
        }
        set.add(variableName);
    }

    private String getVariableRightPreffix(Set<String> properties, List<ExpressionToken> expTokens, int i, ExpressionToken expToken) {
        if (ExpressionToken.ETokenType.ETOKEN_TYPE_VARIABLE == expToken.getTokenType()) {
            if (properties.contains(expToken.getVariable().getVariableName())) {
                return "m.";
            }
            if (expToken.getVariable().getVariableName().startsWith("UIContext(")) {
                return "p.";
            }
        }
        return null;
    }
}

