/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.definition;

import com.kingdee.bos.eventbus.definition.AbstractComponentMeta;
import com.kingdee.bos.eventbus.definition.ComponentType;
import com.kingdee.bos.eventbus.definition.IDefinitionVisitor;
import com.kingdee.bos.eventbus.definition.IMetaMerge;
import com.kingdee.util.StringUtils;

public final class Service
extends AbstractComponentMeta
implements Cloneable {
    private String id;
    private String interfaceName;
    private boolean lazyInit = false;

    Service(String name, String id, String interfaceName) {
        super(name);
        this.id = id;
        this.interfaceName = interfaceName;
        this.type = ComponentType.SERVICE;
    }

    private Service(String id) {
        this.id = id;
    }

    public static Service createService(String id) {
        return new Service(id);
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public boolean isIntegral() {
        return this.id != null && this.getName() != null && this.interfaceName != null;
    }

    @Override
    public void mergeFrom(IMetaMerge from) {
        if (from == null || !(from instanceof Service)) {
            return;
        }
        Service serviceFrom = (Service)from;
        if (StringUtils.isEmpty((String)this.getName())) {
            this.setName(serviceFrom.getName());
        }
        if (StringUtils.isEmpty((String)this.interfaceName)) {
            this.interfaceName = serviceFrom.interfaceName;
        }
        if (!this.lazyInit) {
            this.lazyInit = serviceFrom.lazyInit;
        }
        super.mergeFrom(from);
    }

    public boolean isLazyInit() {
        return this.lazyInit;
    }

    void setLazyInit(boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        Service s = (Service)super.clone();
        return s;
    }

    @Override
    public void accept(IDefinitionVisitor visitor) {
        visitor.visit(this);
    }
}

