/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.definition;

import com.kingdee.bos.eventbus.HandlerType;
import com.kingdee.bos.eventbus.PointCutEnum;
import com.kingdee.bos.eventbus.definition.ActionDefinition;
import com.kingdee.bos.eventbus.definition.ApplicationDefinition;
import com.kingdee.bos.eventbus.definition.IDefinition;
import com.kingdee.bos.eventbus.definition.IDefinitionVisitor;
import com.kingdee.bos.eventbus.definition.IMetaMerge;
import com.kingdee.bos.eventbus.definition.IUIConfigCache;
import com.kingdee.bos.eventbus.definition.Plugin;
import com.kingdee.bos.eventbus.definition.RuleDefinition;
import com.kingdee.bos.eventbus.definition.Service;
import com.kingdee.bos.eventbus.exception.UIConfigException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class UIConfig
implements IDefinition {
    private String name;
    private String resource;
    private UIConfig parent;
    private Collection<Plugin> plugins;
    private Collection<Plugin> serverPlugins;
    private Map<String, ActionDefinition> actions;
    private Map<String, ActionDefinition> fullActions;
    private Map<String, Service> services;
    private Map<String, Service> fullServices;
    private Map<String, Service> servicesByInterface;
    private Collection<UIConfig> imports;
    private boolean isMerged = false;
    private Map<String, RuleDefinition> ruleset;
    private ApplicationDefinition application;
    private Map<HandlerType, Map<String, Collection<Plugin>>> pluginMap = new HashMap<HandlerType, Map<String, Collection<Plugin>>>();
    private boolean isInitForRegister = false;

    private UIConfig(String name) {
        this.name = name;
    }

    public Collection<Plugin> getPlugins() {
        return this.plugins;
    }

    UIConfig(String name, String resource) {
        this.name = name;
        this.resource = resource;
    }

    public static UIConfig createUIConfig(IUIConfigCache uiConfigCache, String name, String parentName) {
        UIConfig uiConfig = new UIConfig(name);
        uiConfig.setParent(uiConfigCache.getUIConfig(parentName));
        return uiConfig;
    }

    public String getName() {
        return this.name;
    }

    void setImports(Collection<UIConfig> imports) {
        this.imports = imports;
    }

    public UIConfig getParent() {
        return this.parent;
    }

    public void setParent(UIConfig parent) {
        this.parent = parent;
    }

    void setPlugins(Collection<Plugin> plugins) {
        this.plugins = plugins;
    }

    void setServerPlugins(Collection<Plugin> serverPlugins) {
        this.serverPlugins = serverPlugins;
    }

    public Map<String, ActionDefinition> getActions() {
        return this.actions;
    }

    void setActionDefinitions(Map<String, ActionDefinition> actions) {
        this.actions = actions;
    }

    public ActionDefinition getActionDefinition(String actionName) {
        ActionDefinition action = this.getThisActionDefinition(actionName);
        if (action == null && this.parent != null) {
            return this.parent.getActionDefinition(actionName);
        }
        if (action != null && this.parent != null) {
            action.mergeFrom(this.parent.getActionDefinition(actionName));
        }
        return action;
    }

    public ActionDefinition getThisActionDefinition(String actionName) {
        ActionDefinition action = this.getFullActionDefinition(actionName);
        if (action != null) {
            return action;
        }
        if (this.actions != null) {
            action = this.actions.get(actionName);
        }
        if (action == null) {
            return null;
        }
        try {
            action = (ActionDefinition)action.clone();
            this.addFullActionDefinition(action);
            return action;
        }
        catch (CloneNotSupportedException e) {
            throw new UIConfigException("ActionDefinition clone failed.", e);
        }
    }

    private ActionDefinition getFullActionDefinition(String actionName) {
        if (this.fullActions == null) {
            return null;
        }
        return this.fullActions.get(actionName);
    }

    private void addFullActionDefinition(ActionDefinition action) {
        if (this.fullActions == null) {
            this.fullActions = new HashMap<String, ActionDefinition>(this.actions.size());
        }
        this.fullActions.put(action.getActionName(), action);
    }

    public void addActionDefinition(ActionDefinition actionDefinition) {
        if (this.actions == null) {
            this.actions = new HashMap<String, ActionDefinition>();
        }
        this.actions.put(actionDefinition.getActionName(), actionDefinition);
    }

    public Map<String, Collection<Plugin>> getRegisterPlugins(HandlerType handlerType) {
        if (!this.isInitForRegister) {
            HashSet<String> overwrited = new HashSet<String>();
            this.collectPlugins(this.pluginMap, overwrited);
            this.isInitForRegister = true;
        }
        return this.pluginMap.get((Object)handlerType);
    }

    public void putRegisterPlugins(HandlerType handlerType, Map<String, Collection<Plugin>> plugins) {
        this.pluginMap.put(handlerType, plugins);
    }

    public Collection<Plugin> getServerPlugins() {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        this.collectServerPlugins(plugins);
        return plugins;
    }

    private void collectServerPlugins(Collection<Plugin> plugins) {
        if (this.serverPlugins != null) {
            plugins.addAll(this.serverPlugins);
        }
        if (this.parent != null) {
            this.parent.collectServerPlugins(plugins);
        }
    }

    private Map<String, Collection<Plugin>> getMap(Map<HandlerType, Map<String, Collection<Plugin>>> pluginMap, HandlerType handlerType) {
        if (pluginMap.containsKey((Object)handlerType)) {
            return pluginMap.get((Object)handlerType);
        }
        HashMap<String, Collection<Plugin>> map = new HashMap<String, Collection<Plugin>>();
        pluginMap.put(handlerType, map);
        return map;
    }

    private void collectPlugins(Map<HandlerType, Map<String, Collection<Plugin>>> pluginMap, Set<String> overwrited) {
        Collection<Plugin> plugins = this.plugins;
        HashSet<String> lastOverwrited = new HashSet<String>();
        lastOverwrited.addAll(overwrited);
        this.collectPlugins(PointCutEnum.BEFORE, pluginMap, plugins, overwrited, this);
        this.collectPlugins(PointCutEnum.OVERWRITE, pluginMap, plugins, overwrited, this);
        if (this.parent != null) {
            this.parent.collectPlugins(pluginMap, overwrited);
        }
        this.collectPlugins(PointCutEnum.AFTER, pluginMap, plugins, lastOverwrited, this);
    }

    private void collectPlugins(PointCutEnum pointcut, Map<HandlerType, Map<String, Collection<Plugin>>> pluginMap, Collection<Plugin> plugins, Set<String> overwrited, UIConfig uic) {
        if (plugins == null) {
            return;
        }
        for (Plugin plugin : plugins) {
            Map<String, Collection<Plugin>> map = this.getMap(pluginMap, plugin.getHandler().getHandlerType());
            plugin.collectPlugin(map, pointcut, overwrited, this);
        }
    }

    void setServices(Map<String, Service> services) {
        this.services = services;
    }

    public Service getService(String id) {
        Service service = this.getThisService(id);
        if (service == null && this.parent != null) {
            return this.parent.getService(id);
        }
        if (this.parent != null && service != null && !service.isIntegral()) {
            Service parentService = this.parent.getService(id);
            service.mergeFrom(parentService);
        }
        return service;
    }

    public Service getServiceByInterface(String interfaceName) {
        Service service = this.getThisServiceByInterface(interfaceName);
        if (service == null && this.parent != null) {
            return this.parent.getThisServiceByInterface(interfaceName);
        }
        if (this.parent != null && service != null && !service.isIntegral()) {
            Service parentService = this.parent.getThisServiceByInterface(interfaceName);
            service.mergeFrom(parentService);
        }
        return service;
    }

    private Service getThisServiceByInterface(String interfaceName) {
        if (this.services == null) {
            return null;
        }
        if (this.servicesByInterface == null) {
            this.initServicesByInterface();
        }
        return this.servicesByInterface.get(interfaceName);
    }

    private void initServicesByInterface() {
        this.servicesByInterface = new HashMap<String, Service>(this.services.size());
        for (Service service : this.services.values()) {
            this.servicesByInterface.put(service.getInterfaceName(), service);
        }
    }

    private Service getThisService(String id) {
        Service service = this.getFullService(id);
        if (service != null) {
            return service;
        }
        if (this.services != null) {
            service = this.services.get(id);
        }
        if (service == null) {
            return null;
        }
        try {
            service = (Service)service.clone();
            this.addFullService(service);
            return service;
        }
        catch (CloneNotSupportedException e) {
            throw new UIConfigException("Service clone failed.", e);
        }
    }

    private Service getFullService(String id) {
        if (this.fullServices == null) {
            return null;
        }
        return this.fullServices.get(id);
    }

    private void addFullService(Service service) {
        if (this.fullServices == null) {
            this.fullServices = new HashMap<String, Service>(this.services.size());
        }
        this.fullServices.put(service.getId(), service);
    }

    public Collection<Service> getIntegralServices() {
        HashMap<String, Service> results = new HashMap<String, Service>();
        this.getIntegralServices(results);
        return results.values();
    }

    private void getIntegralServices(Map<String, Service> results) {
        if (this.services != null) {
            for (String id : this.services.keySet()) {
                if (results.containsKey(id)) continue;
                results.put(id, this.getService(id));
            }
        }
        if (this.parent != null) {
            this.parent.getIntegralServices(results);
        }
    }

    @Override
    public boolean isIntegral() {
        return true;
    }

    @Override
    public void mergeFrom(IMetaMerge from) {
        if (from == null || !(from instanceof UIConfig)) {
            return;
        }
        UIConfig configFrom = (UIConfig)from;
        this.mergePlugins(configFrom);
    }

    private void mergePlugins(UIConfig configFrom) {
        if (configFrom.plugins == null) {
            return;
        }
        HashSet<String> set = new HashSet<String>();
        if (this.plugins != null) {
            for (Plugin plugin : this.plugins) {
                set.add(plugin.getEventType());
            }
        }
        for (Plugin plugin : configFrom.plugins) {
            if (set.contains(plugin.getEventType())) continue;
            this.plugins.add(plugin);
        }
    }

    private void mergeImports() {
        if (this.isMerged || this.imports == null) {
            return;
        }
        for (UIConfig uiConfig : this.imports) {
            this.mergeFrom(uiConfig);
        }
        this.isMerged = true;
    }

    void setRuleset(Map<String, RuleDefinition> ruleset) {
        this.ruleset = ruleset;
    }

    public RuleDefinition getRuleDefinition(String id) {
        RuleDefinition rule = this.getThisRuleDefinition(id);
        if (rule == null && this.parent != null) {
            return this.parent.getRuleDefinition(id);
        }
        return rule;
    }

    private RuleDefinition getThisRuleDefinition(String id) {
        RuleDefinition rule = null;
        if (this.ruleset != null) {
            rule = this.ruleset.get(id);
        }
        return rule;
    }

    public boolean isExtendFrom(String parentName) {
        if (this.parent == null) {
            return false;
        }
        if (this.parent.name.equals(parentName)) {
            return true;
        }
        return this.parent.isExtendFrom(parentName);
    }

    public ApplicationDefinition getApplicationDefinition() {
        if (this.application == null && this.parent != null) {
            return this.parent.getApplicationDefinition();
        }
        if (this.parent != null && this.application != null && !this.application.isIntegral()) {
            ApplicationDefinition parentPresenter = this.parent.getApplicationDefinition();
            this.application.mergeFrom(parentPresenter);
        }
        return this.application;
    }

    void setApplicationDefinition(ApplicationDefinition applicationDefinition) {
        this.application = applicationDefinition;
    }

    public void addService(Service service) {
        if (this.services == null) {
            this.services = new HashMap<String, Service>();
        }
        this.services.put(service.getId(), service);
    }

    Map<String, Service> getServices() {
        return this.services;
    }

    @Override
    public void accept(IDefinitionVisitor visitor) {
        visitor.visit(this);
    }
}

