/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.expression;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ExpressionParser {
    public static final Pattern JSONARRAY_PATTERN = Pattern.compile("^\\[.*\\]$");
    public static final Pattern FUNSYMBOL_PATTERN = Pattern.compile("([a-zA-Z]+)[\\s]*\\(.*\\)$");
    public static final Pattern BRACKET_PATTERN = Pattern.compile("\\((.*)\\)");

    private ExpressionParser() {
    }

    public static ExpressionParser getInstance() {
        return new ExpressionParser();
    }

    public boolean isJSONArray(String expr) {
        Matcher matcher = JSONARRAY_PATTERN.matcher(expr);
        return matcher.find();
    }

    public String[] splitJSONArray(String expr) {
        expr = expr.substring(1, expr.length() - 1);
        return expr.split("\\s*,\\s*");
    }

    public boolean isFunction(String expr) {
        Matcher matcher = FUNSYMBOL_PATTERN.matcher(expr);
        return matcher.find();
    }
}

