/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.handler.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.eventbus.application.IApplication;
import com.kingdee.bos.eventbus.event.model.IModelCreateEventHandler;
import com.kingdee.bos.eventbus.event.model.ModelCreateEvent;
import com.kingdee.bos.eventbus.model.ModelCreateException;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;

public abstract class AbstractModelCreateEventHandler
implements IModelCreateEventHandler {
    protected abstract IApplication getApplication();

    @Override
    public void onModelCreate(ModelCreateEvent event) throws BOSException {
        IObjectValue ov = event.getModel();
        if (ov != null) {
            return;
        }
        ov = this.getApplication().getModelService().createModel();
        event.setModel(ov);
        String entryName = this.getApplication().getModelService().getEntryName();
        if (StringUtils.isEmpty((String)entryName)) {
            return;
        }
        EntityObjectInfo mainEO = this.getEntityInfo(this.getApplication().getMainOrgContext(), this.getApplication().getModelService().getBosType());
        String occ = mainEO.getObjectCollectionClass();
        try {
            ArrayList<IObjectValue> collection = new ArrayList<IObjectValue>();
            collection.add(this.getApplication().getModelService().createEntryModel(entryName));
            ov.put(entryName, collection);
        }
        catch (Exception e) {
            throw new ModelCreateException(e);
        }
    }

    protected final EntityObjectInfo getEntityInfo(Context ctx, BOSObjectType bosType) {
        EntityObjectInfo mainEO = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(bosType);
        return mainEO;
    }
}

