/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.handler.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.eventbus.application.IApplication;
import com.kingdee.bos.eventbus.event.model.IModelLoadHandler;
import com.kingdee.bos.eventbus.event.model.ModelFieldSelectorEvent;
import com.kingdee.bos.eventbus.event.model.ModelLoadEvent;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;

public abstract class AbstractModelLoadEventHandler
implements IModelLoadHandler {
    protected abstract IApplication getApplication();

    @Override
    public void onModelLoad(ModelLoadEvent event) throws BOSException {
        this.loadModel(event);
    }

    private void loadModel(ModelLoadEvent event) throws BOSException {
        SelectorItemCollection selector = this.getApplication().getModelService().getModelLoadSelector();
        SelectorItemCollection dynSelector = this.getApplication().getModelService().getDynSelector();
        if (selector == null) {
            selector = new SelectorItemCollection();
        }
        if (dynSelector != null && dynSelector.size() > 0) {
            for (int i = 0; i < dynSelector.size(); ++i) {
                selector.add(dynSelector.get(i));
            }
        }
        if (event.getSelector() != null) {
            for (Object sel : event.getSelector()) {
                if (sel instanceof SelectorItemInfo) {
                    selector.add((SelectorItemInfo)sel);
                    continue;
                }
                if (!(sel instanceof String)) continue;
                selector.add((String)sel);
            }
        }
        ModelFieldSelectorEvent modelFieldSelectorEvent = new ModelFieldSelectorEvent();
        modelFieldSelectorEvent.setSelectorItemCollection(selector);
        this.getApplication().getEventBus().fireEvent(modelFieldSelectorEvent);
        selector = modelFieldSelectorEvent.getSelectorItemCollection();
        IObjectValue vo = null;
        try {
            vo = this.getValueObject(event.getPk().toString(), selector.toString());
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        event.setModel(vo);
    }

    public IObjectValue getValueObject(String id, String selector) throws BOSException, EASBizException {
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        if (selector != null) {
            String[] properties;
            for (String property : properties = selector.split(",")) {
                SelectorItemInfo selectorItemInfo = new SelectorItemInfo(property);
                selectorItemCollection.add(selectorItemInfo);
            }
        }
        ICoreBase iCoreBase = (ICoreBase)this.getApplication().getBizInterface();
        CoreBaseInfo objectValue = iCoreBase.getValue((IObjectPK)new ObjectUuidPK(id), selectorItemCollection);
        return objectValue;
    }
}

