/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.expression.format.reader;

import com.kingdee.bos.expression.format.ExpressionReader;
import com.kingdee.bos.expression.format.FormatException;
import com.kingdee.bos.expression.format.reader.DateTypeReader;
import com.kingdee.bos.expression.format.reader.ElementReader;
import com.kingdee.bos.expression.format.reader.FunctionTypeReader;
import com.kingdee.bos.expression.format.reader.NumberTypeReader;
import com.kingdee.bos.expression.format.reader.OperatorTypeReader;
import com.kingdee.bos.expression.format.reader.SplitorTypeReader;
import com.kingdee.bos.expression.format.reader.StringTypeReader;
import com.kingdee.bos.expression.format.reader.VariableTypeReader;
import java.io.IOException;

public class ElementReaderFactory {
    public static ElementReader createElementReader(ExpressionReader reader) throws IOException, FormatException {
        reader.mark(0);
        int b = reader.read();
        reader.reset();
        if (b != -1) {
            char c = (char)b;
            try {
                if (c == '\"') {
                    return (ElementReader)StringTypeReader.class.newInstance();
                }
                if (c == '{') {
                    return (ElementReader)DateTypeReader.class.newInstance();
                }
                if (c == '$') {
                    return (ElementReader)FunctionTypeReader.class.newInstance();
                }
                if ("(),".indexOf(c) >= 0) {
                    return (ElementReader)SplitorTypeReader.class.newInstance();
                }
                if ("01234567890.".indexOf(c) >= 0) {
                    return (ElementReader)NumberTypeReader.class.newInstance();
                }
                if (OperatorTypeReader.isOperatorStart(reader)) {
                    return (ElementReader)OperatorTypeReader.class.newInstance();
                }
                return (ElementReader)VariableTypeReader.class.newInstance();
            }
            catch (Exception e) {
                throw new FormatException(e);
            }
        }
        throw new FormatException("\u6d41\u5df2\u7ed3\u675f");
    }
}

