/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.meta.ui;

import com.kingdee.bos.meta.MetadataCache;
import com.kingdee.bos.meta.entity.BizDataType;
import com.kingdee.bos.meta.entity.IEntityMetadata;
import com.kingdee.bos.meta.entity.MetaProperty;
import com.kingdee.bos.meta.query.IQueryMetadata;
import com.kingdee.bos.meta.query.MetaField;
import com.kingdee.bos.meta.ui.IListUIMetadata;
import com.kingdee.bos.meta.ui.MetaAction;
import com.kingdee.bos.meta.ui.MetaColumn;
import com.kingdee.bos.meta.ui.MetaComponent;
import com.kingdee.bos.meta.ui.MetaDataObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.access.query.SimpleQuery;
import com.kingdee.bos.util.BOSObjectType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetaListUI
implements Serializable,
IListUIMetadata {
    String name;
    String alias;
    String description;
    boolean userDefined;
    String title;
    MetaListUI parent;
    SimpleQuery mainQueryInfo;
    List<MetaComponent> components;
    List<MetaDataObject> dataObjects;
    List<MetaAction> actions;
    List<MetaColumn> columns;
    BOSObjectType mainObjectBosType;
    IMetaDataPK mainQueryPK;
    private transient Map<BizDataType, List<String>> columnNamesByBizDataType = new HashMap<BizDataType, List<String>>();

    public BOSObjectType getMainObjectBosType() {
        return this.mainObjectBosType;
    }

    public void setMainObjectBosType(BOSObjectType mainObjectBosType) {
        this.mainObjectBosType = mainObjectBosType;
    }

    public IMetaDataPK getMainQueryPK() {
        return this.mainQueryPK;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isUserDefined() {
        return this.userDefined;
    }

    public String getTitle() {
        return this.title;
    }

    public MetaListUI getParent() {
        return this.parent;
    }

    public List<MetaComponent> getComponents() {
        return this.components;
    }

    public List<MetaDataObject> getDataObjects() {
        return this.dataObjects;
    }

    public List<MetaAction> getActions() {
        return this.actions;
    }

    @Override
    public List<MetaColumn> getColumns() {
        return this.columns;
    }

    @Override
    public List<String> getColumnNamesByBizDataType(BizDataType bizDataType) {
        List<String> columnsWithBizDataType;
        if (this.columnNamesByBizDataType == null) {
            this.columnNamesByBizDataType = new HashMap<BizDataType, List<String>>();
        }
        if ((columnsWithBizDataType = this.columnNamesByBizDataType.get((Object)bizDataType)) == null) {
            columnsWithBizDataType = this.retriveColumnsByBizDataType(bizDataType);
        }
        return columnsWithBizDataType;
    }

    private List<String> retriveColumnsByBizDataType(BizDataType bizDataType) {
        ArrayList<String> columnsWithBizDataType = new ArrayList<String>();
        IEntityMetadata metaEntity = MetadataCache.getInstance().getEntityMetadata(this.mainObjectBosType);
        IQueryMetadata metaQuery = MetadataCache.getInstance().getQueryMetadata(this.mainQueryPK.getFullName());
        List<MetaProperty> properties = metaEntity.getPropertiesByBizDataType(bizDataType);
        for (MetaProperty property : properties) {
            String propertyName = property.getName();
            for (MetaField field : metaQuery.getQueryFields()) {
                if (!propertyName.equals(field.getFullPropertyName())) continue;
                for (MetaColumn column : this.columns) {
                    if (!field.getName().equals(column.getFieldName())) continue;
                    columnsWithBizDataType.add(column.getName());
                }
            }
        }
        this.columnNamesByBizDataType.put(bizDataType, columnsWithBizDataType);
        return columnsWithBizDataType;
    }
}

