/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.json.adapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.cdo.CommonDataObject;
import com.kingdee.bos.cdo.utils.CDOUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.json.Kson;
import com.kingdee.bos.json.adapter.BosObjectTypeAdapter;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import java.lang.reflect.Type;
import java.util.HashMap;

public class CommonDataObjectTypeAdapter
implements JsonSerializer<CommonDataObject>,
JsonDeserializer<CommonDataObject> {
    public JsonElement serialize(CommonDataObject dataObject, Type type, JsonSerializationContext context) {
        JsonObject result = null;
        IObjectValue objectValue = null;
        try {
            objectValue = CDOUtils.convertCDOToObjectInfo(Kson.getBOSContext(), dataObject);
            BosObjectTypeAdapter bosObjectTypeAdapter = new BosObjectTypeAdapter();
            result = bosObjectTypeAdapter.serialize(objectValue, type, context);
        }
        catch (BOSException e) {
            throw new JsonParseException(e.getMessage());
        }
        catch (EASBizException e) {
            throw new JsonParseException(e.getMessage());
        }
        return result;
    }

    public CommonDataObject deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        HashMap jsonMap = null;
        try {
            jsonMap = JSONUtils.convertJsonToObject((Context)Kson.getBOSContext(), (String)json.toString());
        }
        catch (BOSException e) {
            throw new JsonParseException((Throwable)e);
        }
        String bosType = (String)jsonMap.get("bosType");
        Class destClass = null;
        IObjectValue objectValue = null;
        CommonDataObject dataObject = null;
        try {
            destClass = CommonDataObjectTypeAdapter.getBizObjectValueClass(Kson.getBOSContext(), BOSObjectType.create((String)bosType));
            objectValue = (IObjectValue)JSONUtils.convertJsonToObject((Context)Kson.getBOSContext(), (String)json.toString(), (Class)destClass);
            dataObject = (CommonDataObject)CDOUtils.convertObjectInfoToCDO(Kson.getBOSContext(), objectValue);
        }
        catch (BOSException exception) {
            throw new JsonParseException((Throwable)exception);
        }
        catch (EASBizException exception) {
            throw new JsonParseException((Throwable)exception);
        }
        return dataObject;
    }

    public static final Class getBizObjectValueClass(Context ctx, BOSObjectType bosType) throws BOSException {
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(bosType);
        String clzObjectValueName = entityObjectInfo.getObjectValueClass();
        Class<?> clzObjectValue = null;
        try {
            clzObjectValue = Class.forName(clzObjectValueName);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException("can't find " + clzObjectValueName);
        }
        return clzObjectValue;
    }
}

