/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.json.adapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.json.Kson;
import com.kingdee.bos.meta.ui.MetaComponent;
import com.kingdee.bos.meta.ui.MetaComponentProperty;
import com.kingdee.bos.meta.ui.MetaEventBinding;
import com.kingdee.bos.meta.ui.MetaPropertyBinding;
import com.kingdee.eas.base.commonquery.BooleanEnum;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetaComponentTypeAdapter
implements JsonSerializer<MetaComponent> {
    public JsonElement serialize(MetaComponent component, Type type, JsonSerializationContext context) {
        String field;
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("id", component.getName());
        jsonObject.addProperty("componentType", component.getClassType());
        if (component.getPropertyBindings().size() > 0 && (field = ((MetaPropertyBinding)component.getPropertyBindings().get(0)).getBindingField()) != null) {
            field = field.substring(0, 1).toLowerCase() + field.substring(1);
            jsonObject.addProperty("field", field);
        }
        if (component.getParent() != null && component.getParent().getParent() != null) {
            jsonObject.addProperty("parent", component.getParent().getName());
        } else {
            jsonObject.addProperty("parent", "mainContent");
        }
        if (component.getParent() != null && component.getParent().getParent() != null) {
            String parentComponentID = component.getParent().getName();
            if ("com.kingdee.bos.ctrl.web.Section".equals(component.getParent().getClassType())) {
                jsonObject.addProperty("parentEl", parentComponentID + "_content");
            } else {
                jsonObject.addProperty("parentEl", parentComponentID);
            }
        } else {
            jsonObject.addProperty("parentEl", "mainContent");
        }
        JsonObject properties = new JsonObject();
        for (int nIndex = 0; nIndex < component.getProperties().size(); ++nIndex) {
            Matcher matcher;
            List enumList;
            MetaComponentProperty property = (MetaComponentProperty)component.getProperties().get(nIndex);
            if (property == null || property.getName() == null) continue;
            if (property.getName().equals("enumSource")) {
                enumList = MetaComponentTypeAdapter.getEnumSource(property.getValue(), Kson.getBOSContext().getOriginLocale());
                if (enumList == null || enumList.size() == 0) {
                    properties.add("enumSource", context.serialize((Object)property.getValue()));
                    continue;
                }
                properties.add("enumSource", context.serialize((Object)enumList));
                continue;
            }
            if (property.getName().equals("items") && property.getValue() instanceof String) {
                enumList = MetaComponentTypeAdapter.getEnumSource(property.getValue(), Kson.getBOSContext().getOriginLocale());
                if (enumList == null || enumList.size() == 0) {
                    properties.add("items", context.serialize((Object)property.getValue()));
                    continue;
                }
                properties.add("items", context.serialize((Object)enumList));
                continue;
            }
            String propertyName = property.getName().replace(".", "_");
            String propertyType = property.getType();
            if ("boolean".equalsIgnoreCase(propertyType)) {
                properties.addProperty(propertyName, Boolean.valueOf(Boolean.parseBoolean(property.getValue())));
                continue;
            }
            if ("int".equalsIgnoreCase(propertyType)) {
                properties.addProperty(propertyName, (Number)Integer.parseInt(property.getValue()));
                continue;
            }
            if ("Object".equalsIgnoreCase(propertyType)) {
                try {
                    HashMap objectMap = JSONUtils.convertJsonToObject((Context)Kson.getBOSContext(), (String)property.getValue());
                    properties.add(propertyName, context.serialize((Object)objectMap));
                }
                catch (Exception exception) {
                    properties.addProperty(propertyName, "" + property.getValue() + "");
                }
                continue;
            }
            String regEx = "en_US|zh_CN|zh_TW";
            boolean result = false;
            Pattern pattern = Pattern.compile(regEx);
            if (pattern != null && property.getValue() != null && (matcher = pattern.matcher(property.getValue())) != null) {
                result = matcher.find();
            }
            if (result) {
                properties.addProperty(propertyName, this.getMulLanValue(property.getValue(), Kson.getBOSContext().getOriginLocale()));
                continue;
            }
            properties.addProperty(propertyName, property.getValue());
        }
        JsonObject events = new JsonObject();
        for (int nIndex = 0; nIndex < component.getEventBindings().size(); ++nIndex) {
            MetaEventBinding event = (MetaEventBinding)component.getEventBindings().get(nIndex);
            properties.addProperty(event.getEventName(), "_self." + event.getListenerAdapter() + "");
        }
        jsonObject.add("properties", (JsonElement)properties);
        JsonArray childrenArray = new JsonArray();
        for (int nIndex = 0; nIndex < component.getComponents().size(); ++nIndex) {
            MetaComponent childElement = (MetaComponent)component.getComponents().get(nIndex);
            childrenArray.add(context.serialize((Object)childElement));
        }
        jsonObject.add("childrens", (JsonElement)childrenArray);
        return jsonObject;
    }

    public String getMulLanValue(String string, Locale locale) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            String realString = string.replaceAll("\"", "");
            String[] values = realString.substring(1, realString.length() - 1).split(",");
            for (int i = 0; i < values.length; ++i) {
                String[] value = values[i].split(":");
                map.put(value[0], value[1]);
            }
            for (String key : map.keySet()) {
                if (!locale.toString().equals(key.trim())) continue;
                string = ((String)map.get(key)).trim().toString();
                break;
            }
            return string;
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String genJSONObject(String value) {
        String result = null;
        if (value == null) {
            return null;
        }
        result = "<jsonobject>" + value + "</jsonObject>";
        return result;
    }

    public static List getEnumSource(String className, Locale locale) {
        ArrayList dataList = new ArrayList();
        try {
            List enumList = EnumUtils.getEnumList((String)className);
            if (enumList == null) {
                enumList = DynamicEnum.getEnumList((String)className);
            }
            for (int i = 0; i < enumList.size(); ++i) {
                Enum objEnum = (Enum)enumList.get(i);
                HashMap<String, Object> js = new HashMap<String, Object>();
                js.put("alias", objEnum.getAlias());
                js.put("value", MetaComponentTypeAdapter.getEnumValue(objEnum));
                dataList.add(js);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataList;
    }

    public static String getEnumAlias(Enum objEnum, Locale locale) {
        String str = "";
        if (LocaleUtils.locale_l1.equals(locale)) {
            str = objEnum.getAlias(locale);
            if (str == null || str.length() <= 0) {
                str = objEnum.getName();
            }
        } else {
            str = objEnum.getAlias(locale);
        }
        return str;
    }

    public static Object getEnumValue(Enum enumValue) {
        Object value = null;
        if (enumValue instanceof BooleanEnum) {
            value = new Integer(((IntEnum)enumValue).getValue());
        } else if (enumValue instanceof IntEnum) {
            value = new Integer(((IntEnum)enumValue).getValue());
        } else if (enumValue instanceof FloatEnum) {
            value = String.valueOf(((FloatEnum)enumValue).getValue());
        } else if (enumValue instanceof DoubleEnum) {
            value = String.valueOf(((DoubleEnum)enumValue).getValue());
        } else if (enumValue instanceof LongEnum) {
            value = String.valueOf(((LongEnum)enumValue).getValue());
        } else if (enumValue instanceof StringEnum) {
            value = ((StringEnum)enumValue).getValue();
        } else if (enumValue instanceof DynamicEnum) {
            value = ((DynamicEnum)enumValue).getValue();
        }
        return value;
    }
}

