/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.amqp;

import com.kingdee.bos.rabbitmq.amqp.AMQP;
import com.kingdee.bos.rabbitmq.amqp.Channel;
import com.kingdee.bos.rabbitmq.amqp.ConsumerCancelledException;
import com.kingdee.bos.rabbitmq.amqp.DefaultConsumer;
import com.kingdee.bos.rabbitmq.amqp.Envelope;
import com.kingdee.bos.rabbitmq.amqp.ShutdownSignalException;
import com.kingdee.bos.rabbitmq.utility.Utility;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class QueueingConsumer
extends DefaultConsumer {
    private final BlockingQueue<Delivery> _queue;
    private volatile ShutdownSignalException _shutdown;
    private volatile ConsumerCancelledException _cancelled;
    private static final Delivery POISON = new Delivery(null, null, null);

    public QueueingConsumer(Channel ch) {
        this(ch, new LinkedBlockingQueue<Delivery>());
    }

    public QueueingConsumer(Channel ch, BlockingQueue<Delivery> q) {
        super(ch);
        this._queue = q;
    }

    @Override
    public void handleShutdownSignal(String consumerTag, ShutdownSignalException sig) {
        this._shutdown = sig;
        this._queue.add(POISON);
    }

    @Override
    public void handleCancel(String consumerTag) throws IOException {
        this._cancelled = new ConsumerCancelledException();
        this._queue.add(POISON);
    }

    @Override
    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        this.checkShutdown();
        this._queue.add(new Delivery(envelope, properties, body));
    }

    private void checkShutdown() {
        if (this._shutdown != null) {
            throw Utility.fixStackTrace(this._shutdown);
        }
    }

    private Delivery handle(Delivery delivery) {
        if (delivery == POISON || delivery == null && (this._shutdown != null || this._cancelled != null)) {
            if (delivery == POISON) {
                this._queue.add(POISON);
                if (this._shutdown == null && this._cancelled == null) {
                    throw new IllegalStateException("POISON in queue, but null _shutdown and null _cancelled. This should never happen, please report as a BUG");
                }
            }
            if (null != this._shutdown) {
                throw Utility.fixStackTrace(this._shutdown);
            }
            if (null != this._cancelled) {
                throw Utility.fixStackTrace(this._cancelled);
            }
        }
        return delivery;
    }

    public Delivery nextDelivery() throws InterruptedException, ShutdownSignalException, ConsumerCancelledException {
        return this.handle(this._queue.take());
    }

    public Delivery nextDelivery(long timeout) throws InterruptedException, ShutdownSignalException, ConsumerCancelledException {
        return this.handle(this._queue.poll(timeout, TimeUnit.MILLISECONDS));
    }

    public static class Delivery {
        private final Envelope _envelope;
        private final AMQP.BasicProperties _properties;
        private final byte[] _body;

        public Delivery(Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
            this._envelope = envelope;
            this._properties = properties;
            this._body = body;
        }

        public Envelope getEnvelope() {
            return this._envelope;
        }

        public AMQP.BasicProperties getProperties() {
            return this._properties;
        }

        public byte[] getBody() {
            return this._body;
        }
    }
}

