/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.amqp;

import com.kingdee.bos.rabbitmq.amqp.AMQP;
import com.kingdee.bos.rabbitmq.amqp.Channel;
import com.kingdee.bos.rabbitmq.amqp.Consumer;
import com.kingdee.bos.rabbitmq.amqp.DefaultConsumer;
import com.kingdee.bos.rabbitmq.amqp.Envelope;
import com.kingdee.bos.rabbitmq.amqp.ShutdownSignalException;
import com.kingdee.bos.rabbitmq.amqp.impl.MethodArgumentReader;
import com.kingdee.bos.rabbitmq.amqp.impl.MethodArgumentWriter;
import com.kingdee.bos.rabbitmq.amqp.impl.ValueReader;
import com.kingdee.bos.rabbitmq.amqp.impl.ValueWriter;
import com.kingdee.bos.rabbitmq.utility.BlockingCell;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class RpcClient {
    private final Channel _channel;
    private final String _exchange;
    private final String _routingKey;
    private final String _replyTo;
    private final int _timeout;
    protected static final int NO_TIMEOUT = -1;
    private final Map<String, BlockingCell<Object>> _continuationMap = new HashMap<String, BlockingCell<Object>>();
    private int _correlationId;
    private DefaultConsumer _consumer;

    public RpcClient(Channel channel, String exchange, String routingKey, String replyTo, int timeout) throws IOException {
        this._channel = channel;
        this._exchange = exchange;
        this._routingKey = routingKey;
        this._replyTo = replyTo;
        if (timeout < -1) {
            throw new IllegalArgumentException("Timeout arguument must be NO_TIMEOUT(-1) or non-negative.");
        }
        this._timeout = timeout;
        this._correlationId = 0;
        this._consumer = this.setupConsumer();
    }

    public RpcClient(Channel channel, String exchange, String routingKey, String replyTo) throws IOException {
        this(channel, exchange, routingKey, replyTo, -1);
    }

    public RpcClient(Channel channel, String exchange, String routingKey) throws IOException {
        this(channel, exchange, routingKey, "amq.rabbitmq.reply-to", -1);
    }

    public RpcClient(Channel channel, String exchange, String routingKey, int timeout) throws IOException {
        this(channel, exchange, routingKey, "amq.rabbitmq.reply-to", timeout);
    }

    public void checkConsumer() throws IOException {
        if (this._consumer == null) {
            throw new EOFException("RpcClient is closed");
        }
    }

    public void close() throws IOException {
        if (this._consumer != null) {
            this._channel.basicCancel(this._consumer.getConsumerTag());
            this._consumer = null;
        }
    }

    protected DefaultConsumer setupConsumer() throws IOException {
        DefaultConsumer consumer = new DefaultConsumer(this._channel){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleShutdownSignal(String consumerTag, ShutdownSignalException signal) {
                Map map = RpcClient.this._continuationMap;
                synchronized (map) {
                    for (Map.Entry entry : RpcClient.this._continuationMap.entrySet()) {
                        ((BlockingCell)entry.getValue()).set(signal);
                    }
                    RpcClient.this._consumer = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                Map map = RpcClient.this._continuationMap;
                synchronized (map) {
                    String replyId = properties.getCorrelationId();
                    BlockingCell blocker = (BlockingCell)RpcClient.this._continuationMap.remove(replyId);
                    if (blocker == null) {
                        throw new IllegalStateException("No outstanding request for correlation ID " + replyId);
                    }
                    blocker.set(new Response(consumerTag, envelope, properties, body));
                }
            }
        };
        this._channel.basicConsume(this._replyTo, true, consumer);
        return consumer;
    }

    public void publish(AMQP.BasicProperties props, byte[] message) throws IOException {
        this._channel.basicPublish(this._exchange, this._routingKey, props, message);
    }

    public Response doCall(AMQP.BasicProperties props, byte[] message) throws IOException, TimeoutException {
        return this.doCall(props, message, this._timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response doCall(AMQP.BasicProperties props, byte[] message, int timeout) throws IOException, ShutdownSignalException, TimeoutException {
        this.checkConsumer();
        BlockingCell k = new BlockingCell();
        Map<String, BlockingCell<Object>> map = this._continuationMap;
        synchronized (map) {
            ++this._correlationId;
            String replyId = "" + this._correlationId;
            props = (props == null ? new AMQP.BasicProperties.Builder() : props.builder()).correlationId(replyId).replyTo(this._replyTo).build();
            this._continuationMap.put(replyId, k);
        }
        this.publish(props, message);
        Object reply = k.uninterruptibleGet(timeout);
        if (reply instanceof ShutdownSignalException) {
            ShutdownSignalException sig = (ShutdownSignalException)reply;
            ShutdownSignalException wrapper = new ShutdownSignalException(sig.isHardError(), sig.isInitiatedByApplication(), sig.getReason(), sig.getReference());
            wrapper.initCause(sig);
            throw wrapper;
        }
        return (Response)reply;
    }

    public byte[] primitiveCall(AMQP.BasicProperties props, byte[] message) throws IOException, ShutdownSignalException, TimeoutException {
        return this.primitiveCall(props, message, this._timeout);
    }

    public byte[] primitiveCall(AMQP.BasicProperties props, byte[] message, int timeout) throws IOException, ShutdownSignalException, TimeoutException {
        return this.doCall(props, message, timeout).getBody();
    }

    public byte[] primitiveCall(byte[] message) throws IOException, ShutdownSignalException, TimeoutException {
        return this.primitiveCall(null, message);
    }

    public Response responseCall(byte[] message) throws IOException, ShutdownSignalException, TimeoutException {
        return this.responseCall(message, this._timeout);
    }

    public Response responseCall(byte[] message, int timeout) throws IOException, ShutdownSignalException, TimeoutException {
        return this.doCall(null, message, timeout);
    }

    public String stringCall(String message) throws IOException, ShutdownSignalException, TimeoutException {
        byte[] request;
        try {
            request = message.getBytes("UTF-8");
        }
        catch (IOException _e) {
            request = message.getBytes();
        }
        byte[] reply = this.primitiveCall(request);
        try {
            return new String(reply, "UTF-8");
        }
        catch (IOException _e) {
            return new String(reply);
        }
    }

    public Map<String, Object> mapCall(Map<String, Object> message) throws IOException, ShutdownSignalException, TimeoutException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        MethodArgumentWriter writer = new MethodArgumentWriter(new ValueWriter(new DataOutputStream(buffer)));
        writer.writeTable(message);
        writer.flush();
        byte[] reply = this.primitiveCall(buffer.toByteArray());
        MethodArgumentReader reader = new MethodArgumentReader(new ValueReader(new DataInputStream(new ByteArrayInputStream(reply))));
        return reader.readTable();
    }

    public Map<String, Object> mapCall(Object[] keyValuePairs) throws IOException, ShutdownSignalException, TimeoutException {
        HashMap<String, Object> message = new HashMap<String, Object>();
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            message.put((String)keyValuePairs[i], keyValuePairs[i + 1]);
        }
        return this.mapCall(message);
    }

    public Channel getChannel() {
        return this._channel;
    }

    public String getExchange() {
        return this._exchange;
    }

    public String getRoutingKey() {
        return this._routingKey;
    }

    public Map<String, BlockingCell<Object>> getContinuationMap() {
        return this._continuationMap;
    }

    public int getCorrelationId() {
        return this._correlationId;
    }

    public Consumer getConsumer() {
        return this._consumer;
    }

    public static class Response {
        protected String consumerTag;
        protected Envelope envelope;
        protected AMQP.BasicProperties properties;
        protected byte[] body;

        public Response() {
        }

        public Response(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
            this.consumerTag = consumerTag;
            this.envelope = envelope;
            this.properties = properties;
            this.body = body;
        }

        public String getConsumerTag() {
            return this.consumerTag;
        }

        public Envelope getEnvelope() {
            return this.envelope;
        }

        public AMQP.BasicProperties getProperties() {
            return this.properties;
        }

        public byte[] getBody() {
            return this.body;
        }
    }
}

