/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.initialize;

import com.kingdee.bos.rabbitmq.consumer.QueueManager;
import com.kingdee.bos.rabbitmq.entity.ConnectionEntity;
import com.kingdee.bos.rabbitmq.entity.ConnectionsEntity;
import com.kingdee.bos.rabbitmq.entity.IERPConsumerParamEntity;
import com.kingdee.bos.rabbitmq.entity.IERPConsumerQueue;
import com.kingdee.bos.rabbitmq.entity.MQConfInfoEntity;
import com.kingdee.bos.rabbitmq.entity.ProductorEntity;
import com.kingdee.bos.rabbitmq.entity.ProductorsEntity;
import com.kingdee.bos.rabbitmq.entity.PublisherEntity;
import com.kingdee.bos.rabbitmq.entity.PublishersEntity;
import com.kingdee.bos.rabbitmq.initialize.InitConfig;
import com.kingdee.bos.rabbitmq.initialize.InitConsumer;
import com.kingdee.bos.rabbitmq.util.RabbitMQCacheUtils;
import com.kingdee.bos.rabbitmq.util.StringUtils;
import org.apache.log4j.Logger;

public class ConfigManager {
    private static Logger log = Logger.getLogger((String)ConfigManager.class.getName());

    private ConfigManager() {
    }

    public static void initConsumer() {
        log.info((Object)"Other system deal with MQ consumer init begin...");
        MQConfInfoEntity configInfo = InitConfig.getConfig();
        if (null != configInfo) {
            InitConsumer.initConsumer(configInfo.getConsumers());
        }
    }

    public static ProductorEntity getProductor(String name) {
        MQConfInfoEntity configInfo = InitConfig.getPublishConfig();
        ProductorsEntity productors = null;
        if (null != configInfo) {
            productors = configInfo.getProductors();
        }
        if (StringUtils.isNullObj(productors)) {
            log.error((Object)"MQ xml productors node config information is null.");
            return null;
        }
        for (ProductorEntity productor : productors.getProductors()) {
            if (!productor.getName().equals(name)) continue;
            return productor;
        }
        return null;
    }

    public static ConnectionEntity getConnection(String name) {
        MQConfInfoEntity configInfo = InitConfig.getPublishConfig();
        ConnectionsEntity connections = null;
        if (!StringUtils.isNullObj(configInfo)) {
            connections = configInfo.getConnections();
            for (ConnectionEntity con : connections.getConnections()) {
                if (!con.getName().equals(name)) continue;
                return con;
            }
        }
        return null;
    }

    public static PublisherEntity getPublisherEntity(String name) {
        MQConfInfoEntity configInfo = InitConfig.getPublishConfig();
        if (null == configInfo) {
            log.error((Object)"get mq xml config information is not exist.");
            return null;
        }
        PublishersEntity publishers = configInfo.getPublishers();
        if (null == publishers) {
            log.error((Object)"get mq xml config information,the <publishers> node information is null.");
            return null;
        }
        for (PublisherEntity p : publishers.getPublisherList()) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public static void initIerpConsumer(IERPConsumerParamEntity consumerParam) {
        log.info((Object)"IERP system deal with per MQ consumer server init begin...");
        if (null == consumerParam) {
            log.error((Object)"ierp system deal per consumer,method parameter is null.");
            throw new RuntimeException("ierp system deal per consumer,method parameter is null.");
        }
        try {
            InitConsumer.ierpDealPerConsumerServer(consumerParam);
        }
        catch (RuntimeException e) {
            log.error((Object)("ierp system deal consumer queue failed.exception info:" + e));
            throw e;
        }
    }

    public static void ierpEnableConsumer(IERPConsumerParamEntity consumerParam) {
        ConfigManager.initIerpConsumer(consumerParam);
    }

    public static void ierpDisableConsumer(IERPConsumerParamEntity consumerParam) {
        if (null == consumerParam) {
            log.error((Object)"ierp system deal per consumer,method parameter is null.");
            return;
        }
        ConnectionEntity conn = consumerParam.getConnectionEntity();
        if (null == conn) {
            log.error((Object)"ierp system deal per consumer,MQ connection is null.");
            return;
        }
        String realQueue = null;
        for (IERPConsumerQueue queue : consumerParam.getConsumerQueues()) {
            realQueue = QueueManager.getRealQueueName(conn.getUserName(), conn.getPassword(), queue.getRegion(), queue.getQueueName(), false, null);
            if (RabbitMQCacheUtils.containKey(realQueue)) continue;
            RabbitMQCacheUtils.put(realQueue, true);
        }
    }

    public static void ierpDealAutoSubscribeConsumer(IERPConsumerParamEntity consumerParam) {
        if (null == consumerParam) {
            log.error((Object)"ierp system deal per auto subscirbe consumer,method parameter is null.");
            throw new RuntimeException("ierp system deal per consumer,method parameter is null.");
        }
        try {
            InitConsumer.ierpDealPerAutoSubscribeConsumer(consumerParam);
        }
        catch (RuntimeException e) {
            log.error((Object)("ierp system deal auto subscribe consumer queue failed.exception info:" + e));
            throw e;
        }
    }
}

