/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.support;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.rabbitmq.constant.MQConstantEnum;
import com.kingdee.bos.rabbitmq.consumer.QueueManager;
import com.kingdee.bos.rabbitmq.entity.ConnectionEntity;
import com.kingdee.bos.rabbitmq.entity.IERPConsumerParamEntity;
import com.kingdee.bos.rabbitmq.entity.IERPConsumerQueue;
import com.kingdee.bos.rabbitmq.initialize.ConfigManager;
import com.kingdee.bos.rabbitmq.support.EASModelConvert;
import com.kingdee.bos.rabbitmq.util.PropertiesUtils;
import com.kingdee.bos.rabbitmq.util.RabbitMQCacheUtils;
import com.kingdee.bos.rabbitmq.util.StringUtils;
import com.kingdee.bos.rpc.io.loadbalance.IRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import com.kingdee.bos.service.ORMServiceLocation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class EASConsumerManager {
    private static volatile Set<String> hasInit = new HashSet<String>();
    private static final Logger logger = Logger.getLogger(EASConsumerManager.class);
    private static boolean isMainInstance = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context ctx) throws BOSException {
        String dcName = ctx.getAIS();
        if (hasInit.contains(dcName)) {
            return;
        }
        Class<EASConsumerManager> clazz = EASConsumerManager.class;
        synchronized (EASConsumerManager.class) {
            if (hasInit.contains(dcName)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            hasInit.add(dcName);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                RPCServerView sv = RPCServerView.getLast();
                if (sv == null) {
                    EASConsumerManager.innerInit(ctx);
                } else {
                    IRPCServer[] ss = sv.getServers();
                    if (isMainInstance && ss.length == 1 || !isMainInstance && ss.length > 1) {
                        EASConsumerManager.innerInit(ctx);
                    }
                }
            }
            catch (Throwable e) {
                logger.error((Object)("\u521d\u59cb\u5316\u6d88\u8d39\u8005\u5f02\u5e38\uff01\u5bf9\u5e94\u7684\u6570\u636e\u4e2d\u5fc3(" + dcName + ")"), e);
            }
            return;
        }
    }

    private static void innerInit(Context ctx) throws BOSException {
        PropertiesUtils.loadProperties();
        EASConsumerManager.execute(ctx);
    }

    private static synchronized void execute(Context ctx) throws BOSException {
        List<IERPConsumerParamEntity> consumerParams = EASModelConvert.converConsumerParam(ctx);
        for (IERPConsumerParamEntity consumer : consumerParams) {
            ConfigManager.initIerpConsumer(consumer);
        }
        EASConsumerManager.cacehEnableConsumer(consumerParams);
    }

    private static void cacehEnableConsumer(List<IERPConsumerParamEntity> consumerParams) {
        ConnectionEntity conn = null;
        List<IERPConsumerQueue> consumerQueues = null;
        String key = "";
        for (IERPConsumerParamEntity c : consumerParams) {
            conn = c.getConnectionEntity();
            consumerQueues = c.getConsumerQueues();
            key = !StringUtils.isEmpty(conn.getVhost()) ? conn.getVhost() + "_" : MQConstantEnum.DEFAULT_VHOST.getDesc() + "_";
            for (IERPConsumerQueue q : consumerQueues) {
                String tempKey = key + QueueManager.getRealQueueName(conn.getUserName(), conn.getPassword(), q.getRegion(), q.getQueueName(), q.isComeAutoSubscribe(), q.getTag());
                RabbitMQCacheUtils.put(tempKey, true);
            }
        }
    }

    static {
        RPCServerView sv = RPCServerView.getLast();
        if (sv == null) {
            isMainInstance = false;
        } else {
            ORMServiceLocation loc = new ORMServiceLocation("license");
            String url = loc.getServiceURL();
            if (url == null || url.trim().equals("") || url.equalsIgnoreCase("tcp://127.0.0.1")) {
                isMainInstance = true;
            }
        }
    }
}

