/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webservice;

import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BOSTypeConvertor {
    public static Object toBOSType(DataType dataType, Object val) {
        if (dataType.equals((Object)DataType.DATE)) {
            return BOSTypeConvertor.string2Date((String)val);
        }
        if (dataType.equals((Object)DataType.TIME)) {
            return BOSTypeConvertor.string2Time((String)val);
        }
        if (dataType.equals((Object)DataType.TIMESTAMP)) {
            return BOSTypeConvertor.string2TimeStamp((String)val);
        }
        if (dataType.equals((Object)DataType.BOSUUID)) {
            return BOSTypeConvertor.string2BosUuid((String)val);
        }
        if (dataType.equals((Object)DataType.UUID)) {
            return BOSTypeConvertor.string2Uuid((String)val);
        }
        if (dataType.equals((Object)DataType.DECIMAL)) {
            return BOSTypeConvertor.double2BigDecimal(val == null ? 0.0 : (Double)val);
        }
        return val;
    }

    public static Timestamp string2TimeStamp(String val) {
        String format = "yyyy-MM-dd HH:mm:ss.S";
        if (val == null || format == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = sdf.parse(val);
        }
        catch (Exception e) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public static Time string2Time(String val) {
        String format = "HH:mm:ss.S";
        if (val == null || format == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = sdf.parse(val);
        }
        catch (Exception e) {
            return null;
        }
        return new Time(date.getTime());
    }

    public static Date string2Date(String val) {
        String format = "yyyy-MM-dd";
        if (val == null || format == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = sdf.parse(val);
        }
        catch (Exception e) {
            return null;
        }
        return date;
    }

    public static Uuid string2Uuid(String val) {
        return Uuid.read((String)val);
    }

    public static BOSUuid string2BosUuid(String val) {
        if (val == null) {
            return null;
        }
        return BOSUuid.read((String)val);
    }

    public static Object toWSType(DataType type, Object val) {
        return null;
    }

    public static BigDecimal long2BigDecimal(long val) {
        return BigDecimal.valueOf(val);
    }

    public static long bigDecimal2Long(BigDecimal val) {
        return val.longValue();
    }

    public static BigDecimal double2BigDecimal(double val) {
        return new BigDecimal(val);
    }

    public static double bigDecimal2Double(BigDecimal val) {
        return val.doubleValue();
    }

    public static String getSimpleTypeDefaultVal(String realTypeName) {
        if ("byte".equals(realTypeName)) {
            return "'0'";
        }
        if ("short".equals(realTypeName)) {
            return "0";
        }
        if ("int".equals(realTypeName)) {
            return "0";
        }
        if ("long".equals(realTypeName)) {
            return "0l";
        }
        if ("float".equals(realTypeName)) {
            return "0f";
        }
        if ("double".equals(realTypeName)) {
            return "0d";
        }
        if ("char".equals(realTypeName)) {
            return "'0'";
        }
        if ("boolean".equals(realTypeName)) {
            return "false";
        }
        return "null";
    }
}

