/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webservice;

import com.kingdee.bos.webservice.WSAsycnReturn;
import com.kingdee.bos.webservice.WebServiceConfigUtils;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;

public class EASWebService {
    static ExecutorService es = Executors.newFixedThreadPool(8);
    static Map<String, WSAsycnReturn> invokeState = new ConcurrentHashMap<String, WSAsycnReturn>();

    public WSAsycnReturn invokeAsycn(String serviceName, String methodName, Object[] param) {
        try {
            Message message = MessageContext.getCurrentContext().getRequestMessage();
            SOAPEnvelope soap = message.getSOAPEnvelope();
            SOAPHeaderElement headerElement = soap.getHeaderByName("http://webservice.bos.kingdee.com", "stateHashCode");
            if (headerElement != null) {
                String stateHashCode = headerElement.getValue();
                if (invokeState != null && invokeState.get(stateHashCode) != null) {
                    WSAsycnReturn wsr = invokeState.get(stateHashCode);
                    if (wsr.getState() == 1 || wsr.getState() == -1) {
                        invokeState.remove(stateHashCode);
                    }
                    return wsr;
                }
            }
        }
        catch (Exception e) {
            WSAsycnReturn wsr = new WSAsycnReturn();
            wsr.setInvokeErrorCode(e.getMessage());
            return wsr;
        }
        WSAsycnReturn wsr = new WSAsycnReturn();
        wsr.setState(0);
        wsr.setStateHashCode(serviceName + "@" + methodName + "@" + new Random(1000000L).nextInt());
        while (invokeState.containsKey(wsr.getStateHashCode())) {
            wsr.setStateHashCode(serviceName + "@" + methodName + "@" + new Random(1000000L).nextInt());
        }
        invokeState.put(wsr.getStateHashCode(), wsr);
        es.execute(new Runner(serviceName, methodName, param, wsr.getStateHashCode()));
        return wsr;
    }

    class Runner
    implements Runnable {
        String serviceName;
        String methodName;
        Object[] param;
        String stateHashCode;

        public Runner(String serviceName, String methodName, Object[] param, String stateHashCode) {
            this.serviceName = serviceName;
            this.methodName = methodName;
            this.param = param;
            this.stateHashCode = stateHashCode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            WSAsycnReturn wsr = invokeState.get(this.stateHashCode);
            WebServiceConfigUtils.WSConfigInfo wsc = null;
            try {
                Method[] factoryMethods;
                wsc = WebServiceConfigUtils.getInstance().getConfigByService(this.serviceName);
                if (wsc == null) {
                    throw new Exception("not find service by name : " + this.serviceName);
                }
                Class<?> c = this.getClass().getClassLoader().loadClass(wsc.getMethodName());
                for (Method fMethod : factoryMethods = c.getMethods()) {
                    if (!this.methodName.equals(fMethod.getName()) || this.param.length != fMethod.getParameterTypes().length) continue;
                    Class<?>[] parmType = fMethod.getParameterTypes();
                    boolean isParamMatched = true;
                    for (int i = 0; i < this.param.length && isParamMatched; ++i) {
                        if (this.param[i].getClass().isAssignableFrom(parmType[i])) continue;
                        isParamMatched = false;
                    }
                    if (!isParamMatched) continue;
                    wsr.setReturnValue(fMethod.invoke(c.newInstance(), this.param));
                    wsr.setState(1);
                    return;
                }
                StringBuffer sb = new StringBuffer("not find the web service  method with parameter:\r\n" + this.serviceName + "@" + this.methodName + "@[");
                for (Object obj : this.param) {
                    sb.append(obj.getClass() + "  ,");
                }
                sb.setLength(sb.length() - 1);
                sb.append("] ");
                wsr.setInvokeErrorCode(sb.toString());
                wsr.setState(-1);
                throw new Exception(sb.toString());
            }
            catch (Exception e) {
                wsr.setInvokeErrorCode(e.getMessage() == null ? e.getMessage() + "\r\n" + e.getClass().getName() + "\r\n" + e.getStackTrace()[0].getFileName() + ":" + e.getStackTrace()[0].getLineNumber() : e.getMessage());
                wsr.setState(-1);
                e.printStackTrace();
            }
        }
    }
}

