/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webservice;

import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.webservice.WSParaMetersInfo;
import com.kingdee.bos.webservice.WSTypeInfo;
import java.util.ArrayList;
import java.util.List;

public class WSMethodInfo {
    private static final String NEWLINE = "\n";
    private static final String INDENT = "    ";
    private static final String TOBOS = "ToBOS";
    private static final String TOWS = "ToWS";
    private String methodName;
    private WSTypeInfo returnType;
    private List parameters = new ArrayList();

    public List getParameters() {
        return this.parameters;
    }

    public void setParameters(List parameters) {
        this.parameters = parameters;
    }

    public WSTypeInfo getReturnType() {
        return this.returnType;
    }

    public void setReturnType(WSTypeInfo returnType) {
        this.returnType = returnType;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public StringBuffer getMethodDefinition() {
        StringBuffer method = new StringBuffer();
        method.append("public " + this.returnType + " " + this.methodName + "(");
        for (int i = 0; i < this.parameters.size(); ++i) {
            WSParaMetersInfo para = (WSParaMetersInfo)this.parameters.get(i);
            method.append(" " + para.getParameterType() + " " + para.getParameterName() + " ");
            if (i >= this.parameters.size() - 1) continue;
            method.append(",");
        }
        method.append(") throws WSInvokeException");
        return method;
    }

    public StringBuffer getMethodConstraint() {
        StringBuffer method = new StringBuffer();
        method.append("public " + this.methodName + "(");
        for (int i = 0; i < this.parameters.size(); ++i) {
            WSParaMetersInfo para = (WSParaMetersInfo)this.parameters.get(i);
            method.append(" " + para.getParameterType());
            if (i >= this.parameters.size() - 1) continue;
            method.append(",");
        }
        method.append(") throws WSInvokeException");
        return method;
    }

    public StringBuffer getMethodContent() {
        StringBuffer content = new StringBuffer();
        content.append(INDENT);
        content.append(INDENT);
        content.append("try {");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append(INDENT);
        content.append(this.getMethodInfokeContent());
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append("}");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append("catch( Throwable e ) {");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append(INDENT);
        content.append("throw new WSInvokeException( e ) ;");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append("}");
        return content;
    }

    private StringBuffer getMethodInfokeContent() {
        StringBuffer content = new StringBuffer();
        if (this.returnType.isVoidType()) {
            content.append("getController()." + this.methodName + "(");
            content.append(this.getParametersStr());
            content.append(NEWLINE);
            content.append(INDENT);
            content.append(INDENT);
            content.append(INDENT);
            content.append(");");
        } else {
            String tmp = "getController()." + this.methodName + "(";
            tmp = tmp + this.getParametersStr() + ")";
            if (this.returnType.isBosCollectionType()) {
                content.append(this.getPrefix(this.returnType, tmp, TOWS));
            } else {
                content.append("return " + this.getPrefix(this.returnType, tmp, TOWS));
                content.append(";");
            }
        }
        return content;
    }

    private StringBuffer getParametersStr() {
        StringBuffer content = new StringBuffer();
        for (int i = 0; i < this.parameters.size(); ++i) {
            content.append(NEWLINE);
            content.append(INDENT);
            content.append(INDENT);
            content.append(INDENT);
            WSParaMetersInfo para = (WSParaMetersInfo)this.parameters.get(i);
            content.append(this.getPrefix(para.getParameterType(), para.getParameterName(), TOBOS));
            if (i >= this.parameters.size() - 1) continue;
            content.append(",");
        }
        return content;
    }

    private StringBuffer getPrefix(WSTypeInfo type, String varible, String direction) {
        StringBuffer content = new StringBuffer();
        if (type.isSimpleType()) {
            content.append(varible);
        } else if (type.isPkField()) {
            if (TOBOS.equals(direction)) {
                content.append("toBOSObjectPK(" + varible + ")");
            } else {
                content.append("toWSPK(" + varible + ")");
            }
        } else if (type.isBosType()) {
            if (type.getType().equals((Object)DataType.DATE)) {
                if (TOBOS.equals(direction)) {
                    content.append("BOSTypeConvertor.string2Date(" + varible + ")");
                } else {
                    content.append("BOSTypeConvertor.date2String(" + varible + ")");
                }
            } else if (type.getType().equals((Object)DataType.DECIMAL)) {
                if (TOBOS.equals(direction)) {
                    content.append("BOSTypeConvertor.double2BigDecimal(" + varible + ")");
                } else {
                    content.append("BOSTypeConvertor.bigDecimal2Double(" + varible + ")");
                }
            } else if (type.getType().equals((Object)DataType.TIME)) {
                if (TOBOS.equals(direction)) {
                    content.append("BOSTypeConvertor.string2Time(" + varible + ")");
                } else {
                    content.append("BOSTypeConvertor.time2String(" + varible + ")");
                }
            } else if (type.getType().equals((Object)DataType.TIMESTAMP)) {
                if (TOBOS.equals(direction)) {
                    content.append("BOSTypeConvertor.string2TimeStamp(" + varible + ")");
                } else {
                    content.append("BOSTypeConvertor.timeStamp2String(" + varible + ")");
                }
            } else if (type.getType().equals((Object)DataType.BOSUUID)) {
                if (TOBOS.equals(direction)) {
                    content.append("BOSTypeConvertor.string2BosUuid(" + varible + ")");
                } else {
                    content.append("BOSTypeConvertor.bosUuid2String(" + varible + ")");
                }
            } else if (type.getType().equals((Object)DataType.UUID)) {
                if (TOBOS.equals(direction)) {
                    content.append("BOSTypeConvertor.string2Uuid(" + varible + ")");
                } else {
                    content.append("BOSTypeConvertor.uuid2String(" + varible + ")");
                }
            } else if (type.getType().equals((Object)DataType.ENUM)) {
                if (TOBOS.equals(direction)) {
                    content.append("(" + type.getRefObjectName() + ")getBeanConvertor().toEnum( MetaDataHelper.getEnumMetaData( \"" + type.getRefObjectName() + "\" ) , " + varible + ")");
                } else {
                    content.append("getBeanConvertor().enumToWSType( " + varible + " ) ");
                }
            } else if (type.getType().equals((Object)DataType.OBJECTVALUE)) {
                if (TOBOS.equals(direction)) {
                    String packageName = type.getRefObjectName().substring(0, type.getRefObjectName().lastIndexOf("."));
                    String className = type.getRefObjectName().substring(type.getRefObjectName().lastIndexOf(".") + 1);
                    if (packageName.endsWith(".app")) {
                        packageName = packageName.substring(0, packageName.length() - 4);
                    }
                    String voClass = packageName + "." + className + "Info";
                    content.append("(" + voClass + ")getBeanConvertor().toValueObject( MetaDataHelper.getEntityMetaData( \"" + type.getRefObjectName() + "\" ) , " + varible + ")");
                } else {
                    content.append("(" + type.getName() + ")getBeanConvertor().toWSBean( " + varible + " , MetaDataHelper.getEntityMetaData( \"" + type.getRefObjectName() + "\" ) )");
                }
            } else if (type.getType().equals((Object)DataType.OBJECTCOLLECTION)) {
                if (TOBOS.equals(direction)) {
                    String packageName = type.getRefObjectName().substring(0, type.getRefObjectName().lastIndexOf("."));
                    String className = type.getRefObjectName().substring(type.getRefObjectName().lastIndexOf(".") + 1);
                    if (packageName.endsWith(".app")) {
                        packageName = packageName.substring(0, packageName.length() - 4);
                    }
                    String voClass = packageName + "." + className + "Collection";
                    content.append("(" + voClass + ")getBeanConvertor().toObjectCollection( MetaDataHelper.getEntityMetaData(\"" + type.getRefObjectName() + "\") , " + varible + " )");
                } else {
                    content.append("com.kingdee.bos.webservice.WSBean[] objs = getBeanConvertor().toWSBeanArray( " + varible + " );");
                    content.append(NEWLINE);
                    content.append(INDENT);
                    content.append(INDENT);
                    content.append(INDENT);
                    content.append(type.getName() + " rtns = new " + type.getName().substring(0, type.getName().indexOf(91)) + "[objs.length] ;");
                    content.append(NEWLINE);
                    content.append(INDENT);
                    content.append(INDENT);
                    content.append(INDENT);
                    content.append("for( int i = 0 ; i < objs.length ; i ++ ) {");
                    content.append(NEWLINE);
                    content.append(INDENT);
                    content.append(INDENT);
                    content.append(INDENT);
                    content.append(INDENT);
                    content.append("rtns[i] = (" + type.getName().substring(0, type.getName().indexOf(91)) + ")objs[i] ;");
                    content.append(NEWLINE);
                    content.append(INDENT);
                    content.append(INDENT);
                    content.append(INDENT);
                    content.append("}");
                    content.append(NEWLINE);
                    content.append(INDENT);
                    content.append(INDENT);
                    content.append(INDENT);
                    content.append("return rtns ;");
                }
            } else {
                content.append(varible);
            }
        } else if (type.isCustomType()) {
            if (type.getName().equals("com.kingdee.bos.webservice.WSEntityViewInfo")) {
                content.append("getBeanConvertor().toEntityViewInfo( " + varible + ")");
            } else {
                content.append(varible);
            }
        }
        return content;
    }
}

