/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webservice;

import com.kingdee.bos.util.NoBOMInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.JDOMFactory;
import org.jdom2.input.SAXBuilder;

public class WebServiceConfigUtils {
    private static final Logger logger = Logger.getLogger(WebServiceConfigUtils.class);
    private static WebServiceConfigUtils instance = null;
    private static Map<String, WSConfigInfo> config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSConfigInfo getConfigByService(String serviceName) {
        if (config == null || config.isEmpty()) {
            try {
                WebServiceConfigUtils webServiceConfigUtils = instance;
                synchronized (webServiceConfigUtils) {
                    this.initConfig();
                }
            }
            catch (IOException e) {
                logger.error((Object)("get web service wsdd configure error: \r\n" + e.getMessage()));
            }
            catch (JDOMException e) {
                logger.error((Object)("get web service wsdd configure error: \r\n" + e.getMessage()));
            }
        }
        return config.get(serviceName);
    }

    public static WebServiceConfigUtils getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConfig() throws IOException, JDOMException {
        WebServiceConfigUtils webServiceConfigUtils = instance;
        synchronized (webServiceConfigUtils) {
            if (config == null || config.isEmpty()) {
                config = new HashMap<String, WSConfigInfo>();
                String path = System.getProperty("EAS_HOME") + "/server/deploy/eas.ear/web.war";
                File file = new File(path);
                JarFile jarFile = new JarFile(file);
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (!this.traverse(entry)) continue;
                    Element root = WebServiceConfigUtils.parseXML(jarFile.getInputStream(entry)).getRootElement();
                    this.doPrase(root);
                }
            }
        }
    }

    private void doPrase(Element root) {
        for (Element element : root.getChildren()) {
            String name = element.getName();
            if (!"service".equals(name)) continue;
            WSConfigInfo ws = new WSConfigInfo();
            ws.serviceName = element.getAttribute("name").getValue();
            for (Element elementChild : element.getChildren()) {
                String nameC = elementChild.getName();
                if (!"parameter".equals(nameC)) continue;
                String keyC = elementChild.getAttribute("name").getValue();
                if ("allowedMethods".equals(keyC)) {
                    ws.allowMethod = elementChild.getAttribute("value").getValue();
                }
                if (!"className".equals(keyC)) continue;
                ws.classFullName = elementChild.getAttribute("value").getValue();
            }
            config.put(ws.serviceName, ws);
        }
    }

    private boolean traverse(JarEntry entry) {
        String name;
        return !entry.isDirectory() && (name = entry.getName()).endsWith("server-config.wsdd");
    }

    public static Document parseXML(InputStream inputStream) throws JDOMException, IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("The argument inputStream is null");
        }
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(JDOMFactory.class.getClassLoader());
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            doc = builder.build((InputStream)new NoBOMInputStream(inputStream));
        }
        catch (JDOMException je) {
            throw je;
        }
        finally {
            try {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
            catch (SecurityException securityException) {}
        }
        return doc;
    }

    static {
        if (null == instance) {
            instance = new WebServiceConfigUtils();
        }
        config = null;
    }

    class WSConfigInfo {
        private String serviceName;
        private String classFullName;
        private String allowMethod;

        WSConfigInfo() {
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public String getMethodName() {
            return this.classFullName;
        }

        public void setMethodName(String methodName) {
            this.classFullName = methodName;
        }

        public String getAllowMethod() {
            return this.allowMethod;
        }

        public void setAllowMethod(String allowMethod) {
            this.allowMethod = allowMethod;
        }
    }
}

