/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webservice.login;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.framework.session.ILoginModule;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.framework.session.LoginModuleFactory;
import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.util.CryptException;
import com.kingdee.bos.util.CryptoTean;
import com.kingdee.bos.webservice.ExceptionUtils;
import com.kingdee.bos.webservice.WSConfig;
import com.kingdee.bos.webservice.login.WSContext;
import java.util.Locale;
import org.apache.axis.AxisFault;
import org.apache.log4j.Logger;

public class EASLoginProxy1 {
    private static final Logger logger = Logger.getLogger(EASLoginProxy1.class);
    public static final String EAS_DEFAULT_AUTH_PATTERN = "BaseDB";

    public WSContext login(String userName, String password, String slnName, String dcName, String language, int dbType) throws AxisFault {
        return this.login(userName, password, slnName, dcName, language, dbType, EAS_DEFAULT_AUTH_PATTERN);
    }

    public WSContext login(String userName, String password, String slnName, String dcName, String language, int dbType, String authPattern) throws AxisFault {
        WSContext wsctx = new WSContext();
        wsctx.setUserName(userName);
        wsctx.setPassword(password);
        wsctx.setSlnName(slnName);
        wsctx.setDcName(dcName);
        wsctx.setDbType(dbType);
        String encodePwd = EASLoginProxy1.encodePassword(userName, password);
        try {
            String loginUrl = "tcp://localhost:" + ORMRPConfig.getTcpConnectionPort();
            ILoginModule loginModule = this.getLoginModule(loginUrl);
            if (loginModule == null) {
                return null;
            }
            Locale locale = new Locale(language);
            LoginContext ctx = new LoginContext(userName, encodePwd, slnName, dcName, locale);
            ctx.put("dbType", (Object)EASLoginProxy1.getDbType(dbType));
            ctx.put("UserAuthPattern", (Object)authPattern);
            String sessionId = loginModule.login(ctx);
            wsctx.setSessionId(sessionId);
            ORMRPCServiceLocator.setCurrentServiceURL((String)loginUrl);
        }
        catch (Throwable e) {
            wsctx.setSessionId(null);
            logger.error((Object)"WebService login fail:", e);
            AxisFault af = new AxisFault();
            af.setFaultActor("EAS.login");
            af.setFaultDetailString(ExceptionUtils.Exception2String(e));
            af.setFaultString("EAS Login fail:" + e.getMessage());
            throw af;
        }
        return wsctx;
    }

    private ILoginModule getLoginModule(String url) throws BOSException {
        if (WSConfig.getRomoteLocate() == null || WSConfig.getRomoteLocate().equals("true")) {
            return LoginModuleFactory.getRemoteInstance((String)url);
        }
        return LoginModuleFactory.getLocalInstance(null);
    }

    private static String encodePassword(String userName, String password) {
        String encodedPassword = "";
        try {
            encodedPassword = CryptoTean.encrypt((String)userName, (String)password);
        }
        catch (CryptException e) {
            e.printStackTrace();
        }
        if (encodedPassword == null) {
            encodedPassword = "";
        }
        return encodedPassword;
    }

    private static String getDbType(int dbType) {
        switch (dbType) {
            case 0: {
                return "MS SQL Server";
            }
            case 1: {
                return "DB2 UDB";
            }
            case 2: {
                return "Oracle";
            }
        }
        return "MS SQL Server";
    }
}

