/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webservice.tool;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.webservice.tool.FileGenerateException;
import com.kingdee.bos.webservice.tool.WSHelper;
import com.kingdee.bos.webservice.tool.config.DeployConfigDelegate;
import com.kingdee.bos.webservice.tool.config.DeployWebServiceConfigUtil;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public class DeployWebServiceByConfigFile {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.webservice.DeployWebServiceByConfigFile");

    private static void deployWebService(String configFilePath, String metadataPath, String deployPath, boolean deployJava, boolean deployWSDD) {
        if (StringUtils.isEmpty((String)configFilePath) || StringUtils.isEmpty((String)metadataPath) || StringUtils.isEmpty((String)deployPath)) {
            return;
        }
        List delegateList = DeployWebServiceConfigUtil.getAllDeployObject(configFilePath, metadataPath);
        if (delegateList == null) {
            logger.error((Object)"\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u8def\u5f84\u548c\u5143\u6570\u636e\u8def\u5f84\u662f\u5426\u6b63\u786e\uff01");
            return;
        }
        int size = delegateList.size();
        for (int i = 0; i < size; ++i) {
            DeployConfigDelegate delegate = (DeployConfigDelegate)delegateList.get(i);
            BusinessObjectInfo object = delegate.getObject();
            List methodList = delegate.getMethodList();
            Context ctx = new Context();
            ctx.put((Object)"METADATAPATH", (Object)metadataPath);
            WSHelper helper = new WSHelper(ctx);
            try {
                if (deployJava) {
                    helper.generateJavaFile(object, methodList, deployPath);
                }
                if (!deployWSDD) continue;
                helper.generateWSDDFile(object, methodList, deployPath);
                continue;
            }
            catch (FileGenerateException e) {
                logger.error((Object)"error", (Throwable)((Object)e));
                continue;
            }
            catch (IOException e) {
                logger.error((Object)"error", (Throwable)e);
            }
        }
    }

    public static void deployJavaFile(String configFilePath, String metadataPath, String deployPath) {
        if (StringUtils.isEmpty((String)configFilePath) || StringUtils.isEmpty((String)metadataPath) || StringUtils.isEmpty((String)deployPath)) {
            return;
        }
        DeployWebServiceByConfigFile.deployWebService(configFilePath, metadataPath, deployPath, true, false);
    }

    public static void deployWSDDFile(String configFilePath, String metadataPath, String deployPath) {
        if (StringUtils.isEmpty((String)configFilePath) || StringUtils.isEmpty((String)metadataPath) || StringUtils.isEmpty((String)deployPath)) {
            return;
        }
        DeployWebServiceByConfigFile.deployWebService(configFilePath, metadataPath, deployPath, false, true);
    }
}

