/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webservice.tool;

import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.webservice.BeanConvertUtil;
import com.kingdee.bos.webservice.WSPropertyInfo;
import com.kingdee.bos.webservice.tool.FileGenerateException;
import com.kingdee.bos.webservice.tool.IFileGenerator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class WSEntityFileGenerator
implements IFileGenerator {
    private BusinessObjectInfo objectInfo;
    private String fileName;
    private String packageName;
    private static final String NEWLINE = "\n";
    private Map files = new HashMap();

    public WSEntityFileGenerator() {
    }

    public WSEntityFileGenerator(BusinessObjectInfo objectInfo) {
        this.objectInfo = objectInfo;
    }

    public void generateJavaFile(EntityObjectInfo entityInfo) {
        WSPropertyInfo wsProperty;
        int j;
        StringBuffer fileContext = new StringBuffer();
        PropertyCollection properties = entityInfo.getInheritedNoDuplicatedProperties();
        HashSet<WSPropertyInfo> wsProperties = new HashSet<WSPropertyInfo>();
        String fileName = "WS" + entityInfo.getName();
        String packageName = entityInfo.getPackage();
        for (int i = 0; i < properties.size(); ++i) {
            OwnPropertyInfo ownerPropertyInfo;
            WSPropertyInfo wsPropertyInfo;
            PropertyInfo entityPropertyInfo = properties.get(i);
            if (entityPropertyInfo instanceof OwnPropertyInfo && (wsPropertyInfo = this.getWSPropertyByOwner(ownerPropertyInfo = (OwnPropertyInfo)entityPropertyInfo)) != null) {
                wsProperties.add(wsPropertyInfo);
            }
            if (!(entityPropertyInfo instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)entityPropertyInfo;
            EntityObjectInfo childEntityInfo = linkPropertyInfo.getRelationship().getChildObject(entityInfo);
            if (!this.files.containsKey(childEntityInfo.getPackage() + ".WS" + childEntityInfo.getName())) {
                this.files.put(childEntityInfo.getPackage() + ".WS" + childEntityInfo.getName(), fileContext);
                this.generateJavaFile(childEntityInfo);
            }
            if ((wsPropertyInfo = this.getWSPropertyByLink(linkPropertyInfo, entityInfo, childEntityInfo)) == null) continue;
            wsProperties.add(wsPropertyInfo);
        }
        fileContext.append("package " + packageName + ";");
        fileContext.append(NEWLINE);
        fileContext.append(NEWLINE);
        fileContext.append("import com.kingdee.bos.webservice.WSBean;");
        fileContext.append(NEWLINE);
        fileContext.append(NEWLINE);
        fileContext.append("public class " + fileName + " extends WSBean { ");
        fileContext.append(NEWLINE);
        for (j = 0; j < wsProperties.size(); ++j) {
            wsProperty = (WSPropertyInfo)wsProperties.toArray()[j];
            fileContext.append(wsProperty.getDefinition());
            fileContext.append(NEWLINE);
        }
        for (j = 0; j < wsProperties.size(); ++j) {
            wsProperty = (WSPropertyInfo)wsProperties.toArray()[j];
            fileContext.append(wsProperty.getGetter());
            fileContext.append(NEWLINE);
            fileContext.append(wsProperty.getSetter());
            fileContext.append(NEWLINE);
        }
        fileContext.append("}");
        this.files.put(packageName + "." + fileName, fileContext);
    }

    @Override
    public Map generateFiles(BusinessObjectInfo objectInfo) throws FileGenerateException {
        if (objectInfo == null) {
            return null;
        }
        EntityObjectInfo entityInfo = null;
        if (!(objectInfo instanceof EntityObjectInfo)) {
            return null;
        }
        entityInfo = (EntityObjectInfo)objectInfo;
        this.generateJavaFile(entityInfo);
        return this.files;
    }

    public WSPropertyInfo getWSPropertyByOwner(OwnPropertyInfo ownerPropertyInfo) {
        WSPropertyInfo wsPropertyInfo = new WSPropertyInfo();
        wsPropertyInfo.setPropertyName(ownerPropertyInfo.getName());
        if (BeanConvertUtil.getJavaType(ownerPropertyInfo.getDataType()) == null) {
            return null;
        }
        wsPropertyInfo.setJavaType(BeanConvertUtil.getJavaType(ownerPropertyInfo.getDataType()));
        return wsPropertyInfo;
    }

    public WSPropertyInfo getWSPropertyByLink(LinkPropertyInfo linkPropertyInfo, EntityObjectInfo parentEntityInfo, EntityObjectInfo childEntityInfo) {
        WSPropertyInfo wsPropertyInfo = new WSPropertyInfo();
        wsPropertyInfo.setPropertyName(linkPropertyInfo.getName());
        if (linkPropertyInfo.getRelationship().getChildCardinality(parentEntityInfo).equals((Object)CardinalityType.ONE)) {
            wsPropertyInfo.setJavaType(childEntityInfo.getPackage() + ".WS" + childEntityInfo.getName());
        } else if (linkPropertyInfo.getRelationship().getChildCardinality(parentEntityInfo).equals((Object)CardinalityType.ONE_TO_UNBOUNDED)) {
            wsPropertyInfo.setJavaType(childEntityInfo.getPackage() + ".WS" + childEntityInfo.getName() + "[]");
        } else if (linkPropertyInfo.getRelationship().getChildCardinality(parentEntityInfo).equals((Object)CardinalityType.ZERO_TO_ONE)) {
            wsPropertyInfo.setJavaType(childEntityInfo.getPackage() + ".WS" + childEntityInfo.getName());
        } else if (linkPropertyInfo.getRelationship().getChildCardinality(parentEntityInfo).equals((Object)CardinalityType.ZERO_TO_UNBOUNDED)) {
            wsPropertyInfo.setJavaType(childEntityInfo.getPackage() + ".WS" + childEntityInfo.getName() + "[]");
        }
        return wsPropertyInfo;
    }
}

