/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.apply.app.selfreq.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.base.apply.SelfReqBillInfo;
import com.kingdee.eas.base.apply.SelfReqException;
import com.kingdee.eas.base.apply.SelfReqTypeFactory;
import com.kingdee.eas.base.apply.SelfReqTypeInfo;
import com.kingdee.eas.base.apply.app.selfreq.handler.ISelfReqServiceHandler;
import com.kingdee.eas.base.apply.app.selfreq.handler.ReqBillExtendInfo;
import com.kingdee.eas.common.EASBizException;
import org.apache.log4j.Logger;

public class SelfReqServiceManager {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.apply.app.selfreq.handler.SelfReqServiceManager");
    private static SelfReqServiceManager selfReqServiceManager = new SelfReqServiceManager();

    private SelfReqServiceManager() {
    }

    public static SelfReqServiceManager getInstance() {
        return selfReqServiceManager;
    }

    public void reqServiceBefore(Context ctx, SelfReqBillInfo info, ReqBillExtendInfo reqBillExtendInfo) throws EASBizException, BOSException {
        SelfReqTypeInfo selfReqType = info.getSelfReqType();
        ISelfReqServiceHandler iSelfReqServiceHandler = this.createSelfReqServiceHandler(ctx, selfReqType);
        iSelfReqServiceHandler.reqServiceBefore(ctx, info, reqBillExtendInfo);
    }

    public boolean invokeServiceBefore(Context ctx, SelfReqBillInfo info, ReqBillExtendInfo reqBillExtendInfo) throws EASBizException, BOSException {
        SelfReqTypeInfo selfReqType = info.getSelfReqType();
        ISelfReqServiceHandler iSelfReqServiceHandler = this.createSelfReqServiceHandler(ctx, selfReqType);
        return iSelfReqServiceHandler.invokeServiceBefore(ctx, info, reqBillExtendInfo);
    }

    public void invokeService(Context ctx, SelfReqBillInfo info, ReqBillExtendInfo reqBillExtendInfo) throws EASBizException, BOSException {
        SelfReqTypeInfo selfReqType = info.getSelfReqType();
        ISelfReqServiceHandler iSelfReqServiceHandler = this.createSelfReqServiceHandler(ctx, selfReqType);
        iSelfReqServiceHandler.invokeService(ctx, info, reqBillExtendInfo);
    }

    public boolean invokeServiceAfter(Context ctx, SelfReqBillInfo info, ReqBillExtendInfo reqBillExtendInfo) throws EASBizException, BOSException {
        SelfReqTypeInfo selfReqType = info.getSelfReqType();
        ISelfReqServiceHandler iSelfReqServiceHandler = this.createSelfReqServiceHandler(ctx, selfReqType);
        return iSelfReqServiceHandler.invokeServiceAfter(ctx, info, reqBillExtendInfo);
    }

    private ISelfReqServiceHandler createSelfReqServiceHandler(Context ctx, SelfReqTypeInfo selfReqType) throws EASBizException, BOSException {
        SelfReqTypeInfo selfReqTypeInfo = SelfReqTypeFactory.getLocalInstance(ctx).getSelfReqTypeInfo((IObjectPK)new ObjectStringPK(selfReqType.getId().toString()));
        String reqDealHandler = selfReqTypeInfo.getReqDealHandler();
        ISelfReqServiceHandler iSelfReqServiceHandler = null;
        try {
            Class<?> reqDealHandlerClass = Class.forName(reqDealHandler);
            if (!ISelfReqServiceHandler.class.isAssignableFrom(reqDealHandlerClass)) {
                throw new SelfReqException(SelfReqException.UNVALID_SERVICE_HANDLER);
            }
            iSelfReqServiceHandler = (ISelfReqServiceHandler)reqDealHandlerClass.newInstance();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new SelfReqException(SelfReqException.UNVALID_SERVICE_HANDLER);
        }
        return iSelfReqServiceHandler;
    }
}

