/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.attachment.ConnectionObject;
import com.kingdee.eas.base.attachment.FtpConfigInfo;
import com.kingdee.eas.base.attachment.FtpException;
import com.kingdee.eas.base.attachment.app.AbstractFtpHandleFacadeControllerBean;
import com.kingdee.eas.base.attachment.app.FtpConnectionPool;
import com.kingdee.eas.base.attachment.util.SFTPClientTool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.CryptException;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.enterprisedt.net.ftp.FTPException;
import com.kingdee.enterprisedt.net.ftp.KDFileTransferClient;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class FtpHandleFacadeControllerBean
extends AbstractFtpHandleFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.attachment.app.FtpHandleFacadeControllerBean");
    private static int sftpStatus = 32;

    @Override
    protected boolean _upload(Context ctx, IObjectValue ftpConfigInfo, String localPath, String remotePath) throws BOSException, EASBizException {
        FtpConfigInfo ftpConfigInfo2 = (FtpConfigInfo)ftpConfigInfo;
        if (ftpConfigInfo2 != null && ftpConfigInfo2.getSftpStatus() == sftpStatus) {
            return this.uploadSftpByPath(ctx, ftpConfigInfo, localPath, remotePath);
        }
        try {
            return this.reUpload(ftpConfigInfo2, localPath, remotePath);
        }
        catch (Exception e) {
            logger.error((Object)"\u7b2c\u4e00\u6b21\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            try {
                logger.error((Object)"\u518d\u4e00\u6b21\u91cd\u65b0\u4e0a\u4f20");
                return this.reUpload(ftpConfigInfo2, localPath, remotePath);
            }
            catch (Exception e1) {
                logger.error((Object)"\u518d\u4e00\u6b21\u91cd\u65b0\u4e0a\u4f20\u5931\u8d25", (Throwable)e1);
                this.exceptionProcess(e1);
                return false;
            }
        }
    }

    private boolean reUpload(FtpConfigInfo ftpConfigInfo2, String localPath, String remotePath) throws Exception {
        ConnectionObject conn = this.getConn(ftpConfigInfo2);
        KDFileTransferClient fileTransferClient = null;
        if (conn != null && (fileTransferClient = conn.getFtpConn()) != null) {
            this.createDir(fileTransferClient, remotePath);
            if (fileTransferClient.exists(remotePath)) {
                fileTransferClient.deleteFile(remotePath);
            }
            fileTransferClient.uploadFile(localPath, remotePath);
            this.releaseConn(conn);
            return true;
        }
        return false;
    }

    @Override
    protected boolean _upload(Context ctx, IObjectValue ftpConfigInfo, byte[] fileBytes, String remotePath) throws BOSException, EASBizException {
        FtpConfigInfo ftpConfigInfo2 = (FtpConfigInfo)ftpConfigInfo;
        if (ftpConfigInfo2 != null && ftpConfigInfo2.getSftpStatus() == sftpStatus) {
            return this.uploadSftp(ctx, ftpConfigInfo, fileBytes, remotePath);
        }
        try {
            return this.reUpload(ftpConfigInfo2, fileBytes, remotePath);
        }
        catch (Exception e) {
            logger.error((Object)"\u7b2c\u4e00\u6b21\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            try {
                logger.error((Object)"\u518d\u4e00\u6b21\u91cd\u65b0\u4e0a\u4f20");
                return this.reUpload(ftpConfigInfo2, fileBytes, remotePath);
            }
            catch (Exception e1) {
                logger.error((Object)"\u518d\u4e00\u6b21\u4e0a\u4f20\u5931\u8d25", (Throwable)e1);
                this.exceptionProcess(e1);
                return false;
            }
        }
    }

    private boolean reUpload(FtpConfigInfo ftpConfigInfo2, byte[] fileBytes, String remotePath) throws Exception {
        ConnectionObject conn = this.getConn(ftpConfigInfo2);
        KDFileTransferClient fileTransferClient = null;
        if (conn != null && (fileTransferClient = conn.getFtpConn()) != null) {
            this.createDir(fileTransferClient, remotePath);
            if (fileTransferClient.exists(remotePath)) {
                fileTransferClient.deleteFile(remotePath);
            }
            fileTransferClient.uploadFile(fileBytes, remotePath);
            this.releaseConn(conn);
            return true;
        }
        return false;
    }

    protected boolean uploadSftp(Context ctx, IObjectValue ftpConfigInfo, byte[] fileBytes, String remotePath) throws BOSException, EASBizException {
        FtpConfigInfo ftpConfigInfo2 = (FtpConfigInfo)ftpConfigInfo;
        try {
            return this.reUploadSftp(ftpConfigInfo2, fileBytes, remotePath);
        }
        catch (Exception e) {
            logger.error((Object)"\u7b2c\u4e00\u6b21SFTP\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            try {
                logger.error((Object)"SFTP\u518d\u4e00\u6b21\u91cd\u65b0\u4e0a\u4f20");
                return this.reUploadSftp(ftpConfigInfo2, fileBytes, remotePath);
            }
            catch (Exception e1) {
                logger.error((Object)"SFTP\u518d\u4e00\u6b21\u4e0a\u4f20\u5931\u8d25", (Throwable)e1);
                this.exceptionProcess(e1);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reUploadSftp(FtpConfigInfo ftpConfigInfo, byte[] fileBytes, String remotePath) throws Exception {
        boolean isUpload = false;
        SFTPClientTool sftpClientTool = null;
        try {
            if (ftpConfigInfo != null) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(fileBytes);
                sftpClientTool = new SFTPClientTool(ftpConfigInfo.getHost(), ftpConfigInfo.getPort(), ftpConfigInfo.getUserName(), CryptoTean.decrypt((String)ftpConfigInfo.getUserName(), (String)ftpConfigInfo.getPassword()));
                sftpClientTool.connect();
                String uploadPath = sftpClientTool.getUploadPath(remotePath);
                String fileName = sftpClientTool.getFileName(remotePath);
                sftpClientTool.upload(uploadPath, fileName, inputStream);
                isUpload = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u4e0a\u4f20SFTP\u5931\u8d25\uff01\u539f\u56e0\uff1a" + e.getMessage()));
            isUpload = false;
            e.printStackTrace();
        }
        finally {
            if (sftpClientTool != null) {
                try {
                    sftpClientTool.disconnect();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return isUpload;
    }

    protected boolean uploadSftpByPath(Context ctx, IObjectValue ftpConfigInfo, String path, String remotePath) throws BOSException, EASBizException {
        FtpConfigInfo ftpConfigInfo2 = (FtpConfigInfo)ftpConfigInfo;
        try {
            return this.reUploadSftpByPath(ftpConfigInfo2, path, remotePath);
        }
        catch (Exception e) {
            logger.error((Object)"\u7b2c\u4e00\u6b21SFTP\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            try {
                logger.error((Object)"SFTP\u518d\u4e00\u6b21\u91cd\u65b0\u4e0a\u4f20");
                return this.reUploadSftpByPath(ftpConfigInfo2, path, remotePath);
            }
            catch (Exception e1) {
                logger.error((Object)"SFTP\u518d\u4e00\u6b21\u4e0a\u4f20\u5931\u8d25", (Throwable)e1);
                this.exceptionProcess(e1);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reUploadSftpByPath(FtpConfigInfo ftpConfigInfo, String localPath, String remotePath) throws Exception {
        boolean isUpload = false;
        FileInputStream inputStream = null;
        SFTPClientTool sftpClientTool = null;
        try {
            if (ftpConfigInfo != null) {
                inputStream = new FileInputStream(localPath);
                sftpClientTool = new SFTPClientTool(ftpConfigInfo.getHost(), ftpConfigInfo.getPort(), ftpConfigInfo.getUserName(), CryptoTean.decrypt((String)ftpConfigInfo.getUserName(), (String)ftpConfigInfo.getPassword()));
                sftpClientTool.connect();
                String uploadPath = sftpClientTool.getUploadPath(remotePath);
                String fileName = sftpClientTool.getFileName(remotePath);
                sftpClientTool.upload(uploadPath, fileName, inputStream);
                isUpload = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u4e0a\u4f20SFTP\u5931\u8d25\uff01");
            isUpload = false;
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (sftpClientTool != null) {
                try {
                    sftpClientTool.disconnect();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return isUpload;
    }

    private void exceptionProcess(Exception e) throws BOSException, EASBizException {
        if (e.getMessage().indexOf("Connection timed out") > -1 || e.getMessage().indexOf("Connection refused") > -1 || e.getMessage().indexOf("Access is denied") > -1 || e.getMessage().indexOf("No such file") > -1 || e.getMessage().indexOf("Software caused connection abort: recv failed") > -1 || e.getMessage().indexOf("Not logged in") > -1 || e.getMessage().indexOf("Control channel unexpectedly closed") > -1) {
            throw new FtpException(FtpException.FTPCONNECTEDFAIL);
        }
        if (e.getMessage().indexOf("Could not create file") > -1) {
            throw new FtpException(FtpException.DISKNOTENOUGH);
        }
        if (e.getMessage().indexOf("Broken pipe") > -1 || e.getMessage().indexOf("Software caused connection abort: socket write error") > -1) {
            throw new FtpException(FtpException.FTPSOCKETPROBLEM);
        }
        throw new BOSException((Throwable)e);
    }

    @Override
    protected byte[] _download(Context ctx, IObjectValue ftpConfigInfo, String remotePath) throws BOSException, EASBizException {
        FtpConfigInfo ftpConfigInfo2 = (FtpConfigInfo)ftpConfigInfo;
        if (ftpConfigInfo2 != null && ftpConfigInfo2.getSftpStatus() == sftpStatus) {
            return this.downloadBySFTP(ftpConfigInfo2, remotePath);
        }
        try {
            return this.reDownload(ftpConfigInfo2, remotePath);
        }
        catch (Exception e) {
            logger.error((Object)"\u7b2c\u4e00\u6b21\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
            try {
                logger.error((Object)"\u518d\u4e00\u6b21\u91cd\u65b0\u4e0b\u8f7d");
                return this.reDownload(ftpConfigInfo2, remotePath);
            }
            catch (Exception e2) {
                logger.error((Object)"\u518d\u4e00\u6b21\u4e0b\u8f7d\u5931\u8d25", (Throwable)e2);
                this.exceptionProcess(e2);
                return null;
            }
        }
    }

    private byte[] reDownload(FtpConfigInfo ftpConfigInfo2, String remotePath) throws Exception {
        KDFileTransferClient fileTransferClient;
        ConnectionObject conn = this.getConn(ftpConfigInfo2);
        if (conn != null && (fileTransferClient = conn.getFtpConn()) != null) {
            byte[] tmp = fileTransferClient.downloadByteArray(remotePath);
            this.releaseConn(conn);
            return tmp;
        }
        return null;
    }

    protected byte[] downloadBySFTP(FtpConfigInfo ftpConfigInfo, String remotePath) throws BOSException, EASBizException {
        try {
            return this.reDownloadBySFTP(ftpConfigInfo, remotePath);
        }
        catch (Exception e) {
            logger.error((Object)"\u4eceSFTP\u4e0b\u8f7d\u9644\u4ef6,\u7b2c\u4e00\u6b21\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
            try {
                logger.error((Object)"\u4eceSFTP\u4e0b\u8f7d\u9644\u4ef6,\u518d\u4e00\u6b21\u91cd\u65b0\u4e0b\u8f7d");
                return this.reDownloadBySFTP(ftpConfigInfo, remotePath);
            }
            catch (Exception e2) {
                logger.error((Object)"\u4eceSFTP\u4e0b\u8f7d\u9644\u4ef6,\u518d\u4e00\u6b21\u4e0b\u8f7d\u5931\u8d25", (Throwable)e2);
                this.exceptionProcess(e2);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] reDownloadBySFTP(FtpConfigInfo ftpConfigInfo, String remotePath) throws BOSException, EASBizException {
        SFTPClientTool sftpClientTool = null;
        try {
            if (ftpConfigInfo != null) {
                byte[] bytes;
                sftpClientTool = new SFTPClientTool(ftpConfigInfo.getHost(), ftpConfigInfo.getPort(), ftpConfigInfo.getUserName(), CryptoTean.decrypt((String)ftpConfigInfo.getUserName(), (String)ftpConfigInfo.getPassword()));
                sftpClientTool.connect();
                String uploadPath = sftpClientTool.getUploadPath(remotePath);
                String fileName = sftpClientTool.getFileName(remotePath);
                byte[] byArray = bytes = sftpClientTool.download(uploadPath, fileName);
                return byArray;
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u4e0b\u8f7dSFTP\u5931\u8d25\uff01" + e.getMessage()));
            e.printStackTrace();
        }
        finally {
            if (sftpClientTool != null) {
                try {
                    sftpClientTool.disconnect();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return null;
    }

    protected void downloadBySFTP(FtpConfigInfo ftpConfigInfo, String localPath, String remotePath) throws BOSException, EASBizException {
        try {
            this.reDownloadBySFTP(ftpConfigInfo, localPath, remotePath);
        }
        catch (Exception e) {
            logger.error((Object)"\u4eceSFTP\u4e0b\u8f7d\u9644\u4ef6,\u7b2c\u4e00\u6b21\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
            try {
                logger.error((Object)"\u4eceSFTP\u4e0b\u8f7d\u9644\u4ef6,\u518d\u4e00\u6b21\u91cd\u65b0\u4e0b\u8f7d");
                this.reDownloadBySFTP(ftpConfigInfo, localPath, remotePath);
            }
            catch (Exception e2) {
                logger.error((Object)"\u4eceSFTP\u4e0b\u8f7d\u9644\u4ef6,\u518d\u4e00\u6b21\u4e0b\u8f7d\u5931\u8d25", (Throwable)e2);
                this.exceptionProcess(e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reDownloadBySFTP(FtpConfigInfo ftpConfigInfo, String localPath, String remotePath) throws BOSException, EASBizException {
        block32: {
            SFTPClientTool sftpClientTool = null;
            InputStream inputStream = null;
            OutputStream out = null;
            try {
                if (ftpConfigInfo == null) break block32;
                File file = new File(localPath);
                if (!file.exists()) {
                    try {
                        file.createNewFile();
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                    }
                }
                sftpClientTool = new SFTPClientTool(ftpConfigInfo.getHost(), ftpConfigInfo.getPort(), ftpConfigInfo.getUserName(), CryptoTean.decrypt((String)ftpConfigInfo.getUserName(), (String)ftpConfigInfo.getPassword()));
                sftpClientTool.connect();
                String uploadPath = sftpClientTool.getUploadPath(remotePath);
                String fileName = sftpClientTool.getFileName(remotePath);
                inputStream = sftpClientTool.downloadStream(uploadPath, fileName);
                if (file.isDirectory()) {
                    localPath = localPath + File.separator + fileName;
                    logger.debug((Object)("Setting local path to " + localPath));
                }
                out = new FileOutputStream(localPath);
                int len = 0;
                byte[] buffer = new byte[10240];
                while ((len = inputStream.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
            }
            catch (Exception e) {
                File file;
                logger.error((Object)"\u4eceSFTP\u4e0b\u8f7d\u5931\u8d25\uff01");
                String attachmentFTpTmpFilePath2 = localPath;
                if (attachmentFTpTmpFilePath2 != null && attachmentFTpTmpFilePath2.length() != 0 && (file = new File(attachmentFTpTmpFilePath2)).exists()) {
                    file.getAbsoluteFile().delete();
                    logger.error((Object)"\u9644\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u5220\u9664\u672c\u5730\u4e34\u65f6\u6587\u4ef6:", (Throwable)e);
                }
            }
            finally {
                if (sftpClientTool != null) {
                    try {
                        sftpClientTool.disconnect();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    protected boolean _deleteFile(Context ctx, IObjectValue ftpConfigInfo, String remotePath) throws BOSException, EASBizException {
        FtpConfigInfo ftpConfigInfo2 = (FtpConfigInfo)ftpConfigInfo;
        if (ftpConfigInfo2 != null && ftpConfigInfo2.getSftpStatus() == sftpStatus) {
            return this.deleteFileBySftp(ftpConfigInfo2, remotePath);
        }
        try {
            KDFileTransferClient fileTransferClient;
            ConnectionObject conn = this.getConn(ftpConfigInfo2);
            if (conn != null && (fileTransferClient = conn.getFtpConn()) != null && fileTransferClient.exists(remotePath)) {
                fileTransferClient.deleteFile(remotePath);
                this.releaseConn(conn);
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private boolean deleteFileBySftp(FtpConfigInfo ftpConfigInfo, String remotePath) {
        boolean isUpload = false;
        try {
            if (ftpConfigInfo != null) {
                SFTPClientTool sftpClientTool = new SFTPClientTool(ftpConfigInfo.getHost(), ftpConfigInfo.getPort(), ftpConfigInfo.getUserName(), CryptoTean.decrypt((String)ftpConfigInfo.getUserName(), (String)ftpConfigInfo.getPassword()));
                sftpClientTool.connect();
                String uploadPath = sftpClientTool.getUploadPath(remotePath);
                String fileName = sftpClientTool.getFileName(remotePath);
                isUpload = sftpClientTool.delete(uploadPath, fileName);
                sftpClientTool.disconnect();
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u4e0b\u8f7dSFTP\u5931\u8d25\uff01" + e.getMessage()));
            isUpload = false;
            e.printStackTrace();
        }
        return isUpload;
    }

    private ConnectionObject getConn(FtpConfigInfo ftpConfigInfo) throws FTPException, IOException, CryptException {
        FtpConnectionPool ftpConnectionPool = FtpConnectionPool.getInstance();
        ConnectionObject conn = ftpConnectionPool.getConn(ftpConfigInfo);
        return conn;
    }

    private void releaseConn(ConnectionObject conn) throws FTPException, IOException {
        if (conn.getInPool()) {
            conn.setInUse(false);
        } else {
            conn.getFtpConn().disconnect();
        }
    }

    private void createDir(KDFileTransferClient fileTransferClient, String path) {
        block6: {
            String separator = "/";
            String directoryName = path.substring(0, path.lastIndexOf(separator));
            try {
                if (fileTransferClient.exists(directoryName)) break block6;
                String[] directoryNames = directoryName.split("\\" + separator);
                StringBuffer dir = new StringBuffer();
                for (int i = 0; i < directoryNames.length; ++i) {
                    dir.append(directoryNames[i]);
                    if (fileTransferClient.exists(dir.toString())) {
                        dir.append(separator);
                        continue;
                    }
                    try {
                        fileTransferClient.createDirectory(dir.toString());
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                    dir.append(separator);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    protected boolean _updateContent(Context ctx, IObjectValue ftpConfigInfo, String remotePath, byte[] content) throws BOSException, EASBizException {
        FtpConfigInfo ftpConfigInfo2 = (FtpConfigInfo)ftpConfigInfo;
        if (ftpConfigInfo2 != null && ftpConfigInfo2.getSftpStatus() == sftpStatus) {
            return this.uploadSftp(ctx, ftpConfigInfo, content, remotePath);
        }
        try {
            KDFileTransferClient fileTransferClient;
            ConnectionObject conn = this.getConn(ftpConfigInfo2);
            if (conn != null && (fileTransferClient = conn.getFtpConn()) != null) {
                fileTransferClient.deleteFile(remotePath);
                fileTransferClient.uploadFile(content, remotePath);
                this.releaseConn(conn);
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    @Override
    protected boolean _updateContent(Context ctx, IObjectValue ftpConfigInfo, String localPath, String remotePath) throws BOSException, EASBizException {
        FtpConfigInfo ftpConfigInfo2 = (FtpConfigInfo)ftpConfigInfo;
        if (ftpConfigInfo2 != null && ftpConfigInfo2.getSftpStatus() == sftpStatus) {
            return this.uploadSftpByPath(ctx, ftpConfigInfo, localPath, remotePath);
        }
        try {
            KDFileTransferClient fileTransferClient;
            ConnectionObject conn = this.getConn(ftpConfigInfo2);
            if (conn != null && (fileTransferClient = conn.getFtpConn()) != null) {
                fileTransferClient.deleteFile(remotePath);
                fileTransferClient.uploadFile(localPath, remotePath);
                this.releaseConn(conn);
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    @Override
    protected boolean _deleteFile(Context ctx, ConnectionObject connObject, String remotePath) throws BOSException, EASBizException {
        if (connObject != null && connObject.getConfig().getSftpStatus() == sftpStatus) {
            return this.deleteFileBySftp(connObject.getConfig(), remotePath);
        }
        try {
            KDFileTransferClient fileTransferClient;
            if (connObject != null && (fileTransferClient = connObject.getFtpConn()) != null && fileTransferClient.exists(remotePath)) {
                fileTransferClient.deleteFile(remotePath);
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    @Override
    protected boolean _upload(Context ctx, ConnectionObject connObject, byte[] fileBytes, String remotePath) throws BOSException, EASBizException {
        FtpConfigInfo ftpConfigInfo2 = connObject.getConfig();
        if (ftpConfigInfo2 != null && ftpConfigInfo2.getSftpStatus() == sftpStatus) {
            return this.uploadSftp(ctx, (IObjectValue)ftpConfigInfo2, fileBytes, remotePath);
        }
        try {
            return this.reUpload(connObject, fileBytes, remotePath);
        }
        catch (Exception e) {
            logger.error((Object)"\u7b2c\u4e00\u6b21\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
            try {
                logger.error((Object)"\u518d\u4e00\u6b21\u91cd\u65b0\u4e0a\u4f20");
                return this.reUpload(connObject, fileBytes, remotePath);
            }
            catch (Exception e1) {
                logger.error((Object)"\u518d\u4e00\u6b21\u4e0b\u8f7d\u5931\u8d25", (Throwable)e1);
                this.exceptionProcess(e1);
                return false;
            }
        }
    }

    private boolean reUpload(ConnectionObject connObject, byte[] fileBytes, String remotePath) throws Exception {
        KDFileTransferClient fileTransferClient = null;
        if (connObject != null && (fileTransferClient = connObject.getFtpConn()) != null) {
            if (fileTransferClient.exists(remotePath)) {
                fileTransferClient.deleteFile(remotePath);
            }
            this.createDir(fileTransferClient, remotePath);
            fileTransferClient.uploadFile(fileBytes, remotePath);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean testSFTPConnection(FtpConfigInfo ftpConfigInfo) throws BOSException, EASBizException {
        boolean isConn = false;
        SFTPClientTool sftpClientTool = null;
        try {
            if (ftpConfigInfo != null) {
                sftpClientTool = new SFTPClientTool(ftpConfigInfo.getHost(), ftpConfigInfo.getPort(), ftpConfigInfo.getUserName(), ftpConfigInfo.getPassword());
                isConn = sftpClientTool.checkConnect();
            }
        }
        catch (Exception e) {
            logger.error((Object)"SFTP\u8fde\u63a5\u5931\u8d25\uff01");
            isConn = false;
        }
        finally {
            if (sftpClientTool != null) {
                try {
                    sftpClientTool.disconnect();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return isConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _testConnection(Context ctx, IObjectValue ftpConfigInfo) throws BOSException, EASBizException {
        FtpConfigInfo newFtpConfigInfo = (FtpConfigInfo)ftpConfigInfo;
        if (newFtpConfigInfo != null && newFtpConfigInfo.getSftpStatus() == sftpStatus) {
            return this.testSFTPConnection(newFtpConfigInfo);
        }
        KDFileTransferClient fileTransferClient = new KDFileTransferClient();
        try {
            fileTransferClient.setRemoteHost(newFtpConfigInfo.getHost());
            fileTransferClient.setRemotePort(newFtpConfigInfo.getPort());
            fileTransferClient.setUserName(newFtpConfigInfo.getUserName());
            fileTransferClient.setPassword(newFtpConfigInfo.getPassword());
            fileTransferClient.setTimeout(10000);
            fileTransferClient.connect();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fileTransferClient.disconnect();
            }
            catch (Exception e1) {
                logger.error((Object)e1);
            }
        }
    }

    @Override
    protected void _download(Context ctx, String localPath, String remotePath, IObjectValue ftpConfigInfo) throws BOSException, EASBizException {
        FtpConfigInfo ftpConfigInfo2 = (FtpConfigInfo)ftpConfigInfo;
        if (ftpConfigInfo2 != null && ftpConfigInfo2.getSftpStatus() == sftpStatus) {
            this.downloadBySFTP(ftpConfigInfo2, localPath, remotePath);
            return;
        }
        try {
            this.reDownload(localPath, remotePath, ftpConfigInfo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            try {
                logger.error((Object)"\u518d\u4e00\u6b21\u91cd\u65b0\u4e0b\u8f7d");
                this.reDownload(localPath, remotePath, ftpConfigInfo);
            }
            catch (Exception e1) {
                File file;
                String attachmentFTpTmpFilePath2 = localPath;
                if (attachmentFTpTmpFilePath2 != null && attachmentFTpTmpFilePath2.length() != 0 && (file = new File(attachmentFTpTmpFilePath2)).exists()) {
                    file.getAbsoluteFile().delete();
                    logger.error((Object)"\u9644\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u5220\u9664\u672c\u5730\u4e34\u65f6\u6587\u4ef6:", (Throwable)e1);
                }
                logger.error((Object)"\u518d\u4e00\u6b21\u4e0b\u8f7d\u5931\u8d25", (Throwable)e1);
                this.exceptionProcess(e1);
            }
        }
    }

    private void reDownload(String localPath, String remotePath, IObjectValue ftpConfigInfo) throws Exception {
        KDFileTransferClient fileTransferClient;
        FtpConfigInfo ftpConfigInfo2;
        ConnectionObject conn;
        File file = new File(localPath);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
        if ((conn = this.getConn(ftpConfigInfo2 = (FtpConfigInfo)ftpConfigInfo)) != null && (fileTransferClient = conn.getFtpConn()) != null) {
            if (!fileTransferClient.exists(remotePath)) {
                throw new FtpException(FtpException.FILENOTFOUND);
            }
            fileTransferClient.downloadFile(localPath, remotePath);
            this.releaseConn(conn);
        }
    }
}

