/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.ftp;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.attachment.AttachmentException;
import com.kingdee.eas.base.attachment.ftp.AttachmentFtpInfo;
import com.kingdee.eas.base.attachment.obs.AttachmentObsInfo;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class AttachmentUploadServer {
    Logger logger = Logger.getLogger((String)AttachmentUploadServer.class.getName());

    public AttachmentFtpInfo addServerContent(String fileId, byte[] content) throws BOSException {
        RandomAccessFile outFile = null;
        try {
            AttachmentFtpInfo ftpInfo = new AttachmentFtpInfo();
            File out = this.getServerFile(fileId);
            outFile = new RandomAccessFile(out, "rw");
            outFile.seek(outFile.length());
            outFile.write(content);
            this.logger.info((Object)"write one record");
            ftpInfo.setFileSize(content.length);
            ftpInfo.setTempFileName(out.getPath());
            AttachmentFtpInfo attachmentFtpInfo = ftpInfo;
            return attachmentFtpInfo;
        }
        catch (IOException e) {
            this.logger.info((Object)"", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        finally {
            if (outFile != null) {
                try {
                    outFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public AttachmentObsInfo addServerContentByObs(String fileId, byte[] content) throws BOSException {
        RandomAccessFile outFile = null;
        try {
            AttachmentObsInfo obsInfo = new AttachmentObsInfo();
            File out = this.getServerFile(fileId);
            outFile = new RandomAccessFile(out, "rw");
            outFile.seek(outFile.length());
            outFile.write(content);
            this.logger.info((Object)"write one record");
            obsInfo.setFileSize(content.length);
            obsInfo.setTempFileName(out.getPath());
            AttachmentObsInfo attachmentObsInfo = obsInfo;
            return attachmentObsInfo;
        }
        catch (IOException e) {
            this.logger.info((Object)"", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        finally {
            if (outFile != null) {
                try {
                    outFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private OutputStream getOutputStream(String fileName) throws BOSException {
        File tempFile = this.getServerFile(fileName);
        try {
            return new FileOutputStream(tempFile);
        }
        catch (FileNotFoundException e) {
            this.logger.info((Object)"", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    public File getServerFile(String fileName) {
        try {
            if (!StringUtils.isEmpty((String)fileName)) {
                File file = new File(fileName);
                if (file.getParentFile().exists()) {
                    return file;
                }
                File parent = file.getParentFile();
                parent.mkdirs();
                return file;
            }
            File tempFile = File.createTempFile("attachment", "tmp");
            this.logger.info((Object)("create new file is:" + tempFile.getPath()));
            return tempFile;
        }
        catch (IOException e) {
            this.logger.info((Object)"", (Throwable)e);
            return null;
        }
    }

    private InputStream getInputStream(String fileName) throws AttachmentException {
        File tempFile = this.getServerFile(fileName);
        FileInputStream is = null;
        try {
            is = new FileInputStream(tempFile);
            return is;
        }
        catch (FileNotFoundException e) {
            this.logger.info((Object)"", (Throwable)e);
            throw new AttachmentException(AttachmentException.ASSOCIATIONREADONLY);
        }
    }

    public void fileToDb4Server(String fileId, String attachmentFId, Connection con) throws BOSException {
        this.logger.info((Object)".... save file to db");
        String sql = "update t_bas_attachment set ffile = ? where fid = ?";
        InputStream input = null;
        try {
            PreparedStatement ps = con.prepareStatement(sql);
            input = this.getInputStream(fileId);
            this.logger.info((Object)("......... size is:" + input.available()));
            ps.setBinaryStream(1, input, input.available());
            ps.setString(2, attachmentFId);
            ps.execute();
        }
        catch (SQLException e) {
            this.logger.info((Object)"", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        catch (AttachmentException e) {
            this.logger.info((Object)"", (Throwable)((Object)e));
            throw new BOSException(e.getMessage());
        }
        catch (IOException e) {
            this.logger.info((Object)"", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

