/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.security;

import com.kingdee.eas.base.attachment.AttachmentException;
import com.kingdee.eas.base.attachment.security.AbstractPatternInfo;
import com.kingdee.eas.base.attachment.security.PlainFileInfo;
import com.kingdee.eas.base.attachment.security.types.AVIPatternInfo;
import com.kingdee.eas.base.attachment.util.JarUtils;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AttachmentSecurityHelper {
    public static final String SEPARATOR = ";";
    public static final String registerPath = AVIPatternInfo.class.getResource("").getPath();
    public static final String registerPackage = "com.kingdee.eas.base.attachment.security.types";
    public static final Map<String, String> supportFiles = new HashMap<String, String>();
    static Logger logger = Logger.getLogger(AttachmentSecurityHelper.class);

    public static String[][] getPatternString(String pattern) {
        if (StringUtils.isEmpty((String)pattern)) {
            return new String[2][0];
        }
        String[] result = pattern.split(SEPARATOR);
        String[][] patterns = new String[2][result.length];
        int dotIndex = -1;
        int firstRowIndex = -1;
        int secondRowIndex = -1;
        String trimString = null;
        String[] forbidden = new String[]{"\uff1b", "\u3002", "\uffe5", "$", "\uff0c", "%"};
        boolean hasError = false;
        for (String item : result) {
            trimString = item.trim();
            dotIndex = item.indexOf(".");
            if (dotIndex >= 0) {
                for (int i = 0; i < forbidden.length; ++i) {
                    dotIndex = item.indexOf(forbidden[i]);
                    if (dotIndex < 0) continue;
                    patterns[1][++secondRowIndex] = trimString;
                    hasError = true;
                    break;
                }
                if (hasError) continue;
                patterns[0][++firstRowIndex] = trimString;
                continue;
            }
            patterns[1][++secondRowIndex] = trimString;
        }
        return patterns;
    }

    public static List<String> getPatternExtensions(String pattern) {
        if (StringUtils.isEmpty((String)pattern)) {
            return new LinkedList<String>();
        }
        String[] result = pattern.split(SEPARATOR);
        LinkedList<String> list = new LinkedList<String>();
        int dotIndex = -1;
        String trimString = null;
        for (String item : result) {
            trimString = item.trim();
            dotIndex = trimString.indexOf(".");
            if (dotIndex < 0) continue;
            list.add(trimString.substring(dotIndex));
        }
        return list;
    }

    public static void registerSupportFiles() throws AttachmentException {
        block15: {
            String regPath;
            int jarIndex;
            block16: {
                File[] files;
                if (StringUtils.isEmpty((String)registerPath)) {
                    throw new AttachmentException(AttachmentException.LOADINGEXTFILEERROR);
                }
                logger.error((Object)("||||||||||||||||||||||||regPath " + registerPath));
                if (supportFiles.size() > 0) {
                    return;
                }
                jarIndex = -1;
                File file = null;
                jarIndex = registerPath.indexOf(".jar");
                if (jarIndex < 0) {
                    File[] files2;
                    file = new File(registerPath);
                    for (File item : files2 = file.listFiles()) {
                        if (item.isDirectory()) continue;
                        AttachmentSecurityHelper.addSupportFile(item.getName());
                    }
                } else {
                    String jarPath = registerPath.substring(0, jarIndex + 4);
                    if (jarPath.startsWith("file:")) {
                        jarPath = jarPath.substring(5);
                    }
                    List<String> result = JarUtils.find(jarPath);
                    logger.error("||||||||||||||||||||||||result " + result == null ? "0" : Integer.valueOf(result.size()));
                    for (String item : result) {
                        AttachmentSecurityHelper.addSupportFile(item);
                    }
                }
                try {
                    Enumeration<URL> eurl = Thread.currentThread().getContextClassLoader().getResources("com/kingdee/eas/base/attachment/security/types/AVIPatternInfo.class");
                    while (eurl.hasMoreElements()) {
                        URL u = eurl.nextElement();
                        logger.error((Object)("||||||||||||||||||||||||eurl:" + u.toString()));
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"||||||||||||||||||||||||eurl:0");
                }
                URL otherRegPath = Thread.currentThread().getContextClassLoader().getResource("com/kingdee/eas/base/attachment/security/types/AVIPatternInfo.class");
                regPath = otherRegPath == null ? "" : otherRegPath.toString();
                logger.error((Object)("||||||||||||||||||||||||regPath2 " + regPath));
                regPath = regPath.substring(0, regPath.lastIndexOf("/") + 1);
                if ("".equals(regPath) || registerPath.equals(regPath)) break block15;
                jarIndex = regPath.indexOf(".jar");
                if (jarIndex >= 0) break block16;
                if (regPath.startsWith("file:/")) {
                    regPath = regPath.substring(5);
                }
                if ((files = (file = new File(regPath)).listFiles()) == null) break block15;
                for (File item : files) {
                    if (item.isDirectory()) continue;
                    AttachmentSecurityHelper.addSupportFile(item.getName());
                }
                break block15;
            }
            String jarPath = regPath.substring(0, jarIndex + 4);
            if (jarPath.startsWith("file:")) {
                jarPath = jarPath.substring(5);
            }
            if (jarPath.startsWith("jar:file:")) {
                jarPath = jarPath.substring(9);
            }
            List<String> result = JarUtils.find(jarPath);
            for (String item : result) {
                AttachmentSecurityHelper.addSupportFile(item);
            }
        }
    }

    private static void addSupportFile(String item) {
        int index = item.toLowerCase().indexOf("patterninfo");
        if (index >= 0) {
            String key = item.substring(0, index);
            index = item.indexOf(".");
            String value = "com.kingdee.eas.base.attachment.security.types." + item.substring(0, index);
            supportFiles.put(key.toLowerCase(), value);
        }
    }

    public static Map<String, String> getSupportFiles() throws AttachmentException {
        if (supportFiles.size() <= 0) {
            AttachmentSecurityHelper.registerSupportFiles();
        }
        logger.error((Object)("||||||||||||||||||||||||supportFiles " + supportFiles.size()));
        return supportFiles;
    }

    public static List<AbstractPatternInfo> getPatterns(PlainFileInfo plainInfo, String patternList) throws AttachmentException {
        return AttachmentSecurityHelper._getPatterns(plainInfo, patternList);
    }

    public static List<AbstractPatternInfo> getPatternsIncludingSelf(PlainFileInfo plainInfo, String patternList) throws AttachmentException {
        List<AbstractPatternInfo> results = AttachmentSecurityHelper._getPatterns(plainInfo, patternList);
        if (results.size() <= 0) {
            String extName = StringUtil4File.getExtendedFileName(plainInfo.getName()).toLowerCase();
            String value = AttachmentSecurityHelper.getSupportFiles().get(extName);
            String item = "\\\\d{999}." + extName;
            try {
                Object info = AttachmentSecurityHelper.newInstance(AbstractPatternInfo.class, value, new Class[]{PlainFileInfo.class, String.class}, new Object[]{plainInfo, item});
                results.add((AbstractPatternInfo)info);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    private static List<AbstractPatternInfo> _getPatterns(PlainFileInfo plainInfo, String patternList) throws AttachmentException {
        String[] patterns;
        if (StringUtils.isEmpty((String)plainInfo.getName())) {
            return new ArrayList<AbstractPatternInfo>();
        }
        ArrayList<AbstractPatternInfo> results = new ArrayList<AbstractPatternInfo>();
        Map<String, String> supportFiles = AttachmentSecurityHelper.getSupportFiles();
        String extentionName = null;
        String key = null;
        String value = null;
        for (String item : patterns = StringUtil4File.decodeStringBy(patternList, SEPARATOR)) {
            key = StringUtil4File.getExtendedFileName(item);
            extentionName = StringUtil4File.getExtendedFileName(plainInfo.getName());
            String string = extentionName = extentionName == null ? "" : extentionName.toLowerCase();
            if (supportFiles.get("") != null) {
                supportFiles.remove("");
            }
            logger.error((Object)("||||||||||||||||||||||||extentionName " + extentionName));
            value = supportFiles.get(extentionName);
            if (StringUtils.isEmpty((String)value) || value == null) {
                throw new AttachmentException(AttachmentException.UNSUPPORTSECURITYFILE, new Object[]{extentionName});
            }
            if (!key.equalsIgnoreCase(extentionName)) continue;
            try {
                Object info = AttachmentSecurityHelper.newInstance(AbstractPatternInfo.class, value, new Class[]{PlainFileInfo.class, String.class}, new Object[]{plainInfo, item});
                results.add((AbstractPatternInfo)info);
            }
            catch (Exception e) {
                logger.error((Object)"\u521b\u5efa\u9644\u4ef6\u5339\u914d\u5bf9\u8c61\u5931\u8d25:", (Throwable)e);
            }
        }
        return results;
    }

    public static <T extends AbstractPatternInfo> T newInstance(Class<?> castClass, String className, Object ... args) throws Exception {
        try {
            Class<?> _class = Class.forName(className);
            Constructor<?> _constructor = _class.getConstructor(_class.getClass(), String.class);
            Object _instance = _constructor.newInstance(args);
            return (T)((AbstractPatternInfo)castClass.cast(_instance));
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static <T extends AbstractPatternInfo> T newInstance(Class<?> castClass, String className, Class<?>[] argTypes, Object ... args) throws Exception {
        try {
            Class<?> _class = Class.forName(className);
            Constructor<?> _constructor = _class.getConstructor(argTypes);
            Object _instance = _constructor.newInstance(args);
            return (T)((AbstractPatternInfo)castClass.cast(_instance));
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }
}

