/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.enterprisedt.net.ftp.internal;

import com.kingdee.enterprisedt.net.ftp.internal.FTPDataSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;

public class FTPActiveDataSocket
implements FTPDataSocket {
    public static String cvsId = "@(#)$Id: FTPActiveDataSocket.java,v 1.1 2008-12-16 05:14:16 pengxu_ge Exp $";
    private static Logger log = Logger.getLogger(FTPActiveDataSocket.class);
    protected ServerSocket sock = null;
    protected Socket acceptedSock = null;

    public FTPActiveDataSocket(ServerSocket sock) {
        this.sock = sock;
    }

    @Override
    public void setTimeout(int millis) throws IOException {
        this.sock.setSoTimeout(millis);
        if (this.acceptedSock != null) {
            this.acceptedSock.setSoTimeout(millis);
        }
    }

    @Override
    public int getLocalPort() {
        return this.sock.getLocalPort();
    }

    protected void acceptConnection() throws IOException {
        log.debug((Object)"Calling accept()");
        this.acceptedSock = this.sock.accept();
        this.acceptedSock.setSoTimeout(this.sock.getSoTimeout());
        log.debug((Object)"accept() succeeded");
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.acceptConnection();
        return this.acceptedSock.getOutputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.acceptConnection();
        return this.acceptedSock.getInputStream();
    }

    @Override
    public void close() throws IOException {
        this.closeChild();
        this.sock.close();
        log.debug((Object)"close() succeeded");
    }

    @Override
    public void closeChild() throws IOException {
        if (this.acceptedSock != null) {
            this.acceptedSock.close();
            this.acceptedSock = null;
            log.debug((Object)"closeChild() succeeded");
        }
    }
}

