/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.billdigest.util.format;

import com.kingdee.bos.billdigest.util.format.Accessor;
import com.kingdee.bos.billdigest.util.format.FieldAccessor;
import com.kingdee.bos.billdigest.util.format.MapAccessor;
import com.kingdee.bos.billdigest.util.format.MethodAccessor;
import com.kingdee.bos.billdigest.util.format.PropertyContainerAccessor;
import com.kingdee.util.PropertyContainer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;

public class LazyAccessor
implements Accessor {
    private String property;
    private Class<?> c;
    private Accessor impl;

    public LazyAccessor(String property) {
        this.property = property;
    }

    @Override
    public Object getProperty(Object obj) {
        return this.getAccessor(obj).getProperty(obj);
    }

    private synchronized Accessor getAccessor(Object obj) {
        Class<?> c = obj.getClass();
        if (!c.equals(this.c)) {
            Accessor a = this.getFieldAccessor(c);
            if (a == null) {
                a = this.getMethodAccessor(c);
            }
            if (a == null) {
                a = this.getMapAccessor(c);
            }
            if (a == null) {
                a = this.getPropertyContainerAccessor(c);
            }
            if (a != null) {
                this.impl = a;
                this.c = c;
            } else {
                throw new RuntimeException("cloudn't find " + c.getName() + "'s" + this.property + "method");
            }
        }
        return this.impl;
    }

    private Accessor getPropertyContainerAccessor(Class<?> c2) {
        if (PropertyContainer.class.isAssignableFrom(c2)) {
            return new PropertyContainerAccessor(this.property);
        }
        return null;
    }

    private Accessor getMapAccessor(Class<?> c) {
        if (Map.class.isAssignableFrom(c)) {
            return new MapAccessor(this.property);
        }
        return null;
    }

    private Accessor getMethodAccessor(Class<?> c) {
        Method method;
        String name = "get" + this.property.substring(0, 1).toUpperCase() + this.property.substring(1);
        try {
            method = c.getMethod(name, new Class[0]);
        }
        catch (Exception e) {
            name = "is" + this.property.substring(0, 1).toUpperCase() + this.property.substring(1);
            try {
                method = c.getMethod(name, new Class[0]);
            }
            catch (Exception e1) {
                try {
                    method = c.getMethod(this.property, new Class[0]);
                }
                catch (Exception e2) {
                    return null;
                }
            }
        }
        return new MethodAccessor(method);
    }

    private Accessor getFieldAccessor(Class<?> c) {
        for (Field f : c.getDeclaredFields()) {
            if (!f.getName().equals(this.property)) continue;
            return new FieldAccessor(f);
        }
        return null;
    }
}

