/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bot.engine.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bot.engine.common.SqlBuilder;
import com.kingdee.bos.bot.engine.common.TableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.DBUpdateInfo;
import com.kingdee.bos.db.DBUpdateInfoSet;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataOptions;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.configure.IServerMetadataStore;
import com.kingdee.bos.metadata.configure.MetadataStoreFactory;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.util.CloneUtils;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.CustomizedSchemeCollection;
import com.kingdee.eas.ep.CustomizedSchemeFactory;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.CustomizedUnitFactory;
import com.kingdee.eas.ep.CustomizedUnitInfo;
import com.kingdee.eas.ep.EPException;
import com.kingdee.eas.ep.ICustomizedScheme;
import com.kingdee.eas.ep.ICustomizedUnit;
import com.kingdee.eas.ep.IUpdateSql;
import com.kingdee.eas.ep.NodeTypeEnum;
import com.kingdee.eas.ep.UpdateSqlFactory;
import com.kingdee.eas.ep.UpdateSqlInfo;
import com.kingdee.eas.ep.updater.CustomizedUnitNodeInfo;
import com.kingdee.eas.ep.updater.CustomizedUnitNodeInfoConverter;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DynamicExtendUtil {
    private static Logger logger = Logger.getLogger(DynamicExtendUtil.class);
    private static String DYNEXTENDPROPERTYLIST = "dynExtendPropertyList";
    private static String SyncSchemeName = "DEPAddSyncProperty";
    private static String SyncSchemeAlias = "DEP\u589e\u52a0\u82cd\u7a79\u540c\u6b65ID";
    private static String BIM_UNIT_DEFINEPREFIX = "UDF";
    private static String dynExtendPropertyList = "isForMapping|isForGrouping|isForMatching|isForWrittenBack";
    private static String SyncSchemeID;

    public static String addProperty(Context ctx, BOSObjectType type, String propName) throws Exception {
        if (StringUtils.isEmpty((String)propName)) {
            return null;
        }
        if (type == null) {
            throw new Exception("bosType is null!");
        }
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(type);
        return DynamicExtendUtil.addProperty(ctx, entity, propName);
    }

    public static String addProperty(Context ctx, EntityObjectInfo base, String propName) throws Exception {
        PropertyInfo prop = base.getPropertyByNameRuntime(propName);
        if (prop != null) {
            ColumnInfo col = prop.getMappingField();
            return col != null ? col.getName() : null;
        }
        return DynamicExtendUtil.addPropToTable(ctx, base, propName);
    }

    private static String addPropToTable(Context ctx, EntityObjectInfo base, String propName) {
        String colName = "CF" + propName.toUpperCase(Locale.ENGLISH);
        DataTableInfo table = base.getTable();
        String tableName = table.getRealName();
        String sql = "SELECT KSQL_COL_NAME FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME='" + colName + "' AND KSQL_COL_TABNAME='" + tableName + "'";
        try {
            if (DbUtil.executeQuery((Context)ctx, (String)sql).size() == 0) {
                sql = "ALTER Table " + tableName + " ADD " + colName + " DECIMAL(20,0) DEFAULT 0 NOT NULL";
                DynamicExtendUtil.executeSQL(ctx, sql);
                try {
                    DynamicExtendUtil.executeSQL(ctx, "create index " + DynamicExtendUtil.createTableIndexName(table.getRealName(), colName, true) + " on " + table.getRealName() + " (" + colName + ");");
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return colName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String addPropToScheme(Context ctx, EntityObjectInfo base, String propName) throws BOSException, Exception, EASBizException, CloneNotSupportedException {
        boolean needAdd2MD = true;
        String customizedSchemeID = "";
        if (!base.isDynamic()) {
            if (StringUtils.isEmpty((String)SyncSchemeID)) {
                CustomizedSchemeCollection col = CustomizedSchemeFactory.getLocalInstance((Context)ctx).getCustomizedSchemeCollection("where name ='" + SyncSchemeName + "'");
                SyncSchemeID = col.size() == 0 ? DynamicExtendUtil.addNewCustomSchemeAndUnit(ctx) : col.get(0).getId().toString();
            }
            customizedSchemeID = SyncSchemeID;
            DynamicExtendUtil.updateCustomizedUnit(ctx, (AbstractMetaDataValue)base, SyncSchemeID);
        } else {
            String sid = DynamicExtendUtil.getDynamicCustomizedSchemeID(ctx, base);
            if ("always_on".equals(sid)) {
                needAdd2MD = false;
            } else {
                customizedSchemeID = sid;
            }
        }
        ICustomizedScheme ics = CustomizedSchemeFactory.getLocalInstance((Context)ctx);
        CustomizedSchemeInfo csInfo = ics.getCustomizedSchemeInfo("where id='" + customizedSchemeID + "'");
        if (csInfo == null) {
            throw new Exception("dynamic project is not found! customizedSchemeID is " + customizedSchemeID);
        }
        try {
            MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).clear(MetaDataTypeList.ENTITY);
            base = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(base.getType(), Project.Projects.getProjects((Project[])new Project[]{new Project(customizedSchemeID)}, null));
            EntityObjectInfo entity = CloneUtils.clone((EntityObjectInfo)base);
            IUpdateSql updateSql = UpdateSqlFactory.getLocalInstance((Context)ctx);
            UpdateSqlInfo sqlInfo = null;
            if (entity.getTable() != null) {
                CoreBaseCollection col = updateSql.getCollection(" where customizedSchemeID = '" + customizedSchemeID + "' and entityPK='" + entity.getFullName() + "' and tablePK = '" + entity.getTable().getFullName() + "'");
                sqlInfo = col != null && col.size() > 0 && col.get(0) instanceof UpdateSqlInfo ? (UpdateSqlInfo)col.get(0) : DynamicExtendUtil.createSqlInfo(customizedSchemeID, entity);
            }
            DBUpdateInfoSet sqlSet = DBUpdateInfoSet.toDBUpdateInfoSet((String)sqlInfo.getSql());
            ArrayList sqlObjs = new ArrayList();
            OwnPropertyInfo property = new OwnPropertyInfo();
            property.setName(propName);
            property.setAlias(propName, LocaleUtils.locale_l1);
            property.setAlias(propName, LocaleUtils.locale_l2);
            property.setAlias(propName, LocaleUtils.locale_l3);
            property.setDataType(DataType.DECIMAL);
            property.setLength(20);
            property.setPrecision(20);
            property.setDecimalDigits(0);
            property.setMultilingual(false);
            property.setConfigured(true);
            ColumnInfo column = new ColumnInfo();
            column.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
            column.setDefaultValue("0");
            column.setNullable(false);
            column.setName("CF" + propName);
            column.setAlias("\u540c\u6b65\u82cd\u7a79ID");
            column.setMultilingual(false);
            column.setConfigured(true);
            column.setTypeName(SQLType.NUMERIC);
            column.setLength(20);
            column.setPrecision(20);
            column.setScale(0);
            if (needAdd2MD && entity.getTable() != null) {
                entity.getTable().getColumns().add(column);
            }
            property.setMappingField(column);
            property.setExtendedProperty("isForMapping", String.valueOf(false));
            property.setExtendedProperty("isForGrouping", String.valueOf(false));
            property.setExtendedProperty("isForMatching", String.valueOf(false));
            property.setExtendedProperty("isForWrittenBack", String.valueOf(false));
            property.setExtendedProperty(DYNEXTENDPROPERTYLIST, dynExtendPropertyList);
            DynamicExtendUtil.addSQL4DynCol(ctx, entity.getTable(), sqlObjs, property.getMappingField());
            if (needAdd2MD) {
                entity.getProperties().add((PropertyInfo)property);
                AbstractMetaDataValue[] mds = new AbstractMetaDataValue[]{entity.getTable(), entity};
                DynamicExtendUtil.saveMetadata(ctx, mds, customizedSchemeID);
                sqlSet.addDBUpdateInfo(sqlObjs);
                sqlInfo.setSql(sqlSet.toJSONObject().toString());
                updateSql.submit((CoreBaseInfo)sqlInfo);
            }
            String string = column.getName();
            return string;
        }
        finally {
            ArrayList<String> lists = new ArrayList<String>();
            lists.add(customizedSchemeID);
            DynamicExtendUtil.update4Used(ctx, lists);
        }
    }

    private static UpdateSqlInfo createSqlInfo(String customizedSchemeID, EntityObjectInfo entity) {
        UpdateSqlInfo sqlInfo = new UpdateSqlInfo();
        sqlInfo.setCustomizedSchemeID(customizedSchemeID);
        sqlInfo.setEntityPK(entity.getFullName());
        sqlInfo.setTablePK(entity.getTable().getFullName());
        return sqlInfo;
    }

    public static String addNewCustomSchemeAndUnit(Context ctx) throws Exception {
        try {
            ICustomizedScheme ics = CustomizedSchemeFactory.getLocalInstance((Context)ctx);
            CustomizedSchemeInfo csInfo = new CustomizedSchemeInfo();
            csInfo.setName(SyncSchemeName);
            csInfo.setAlias(SyncSchemeAlias);
            csInfo.setBuildNumber("CS_SYSTEM");
            csInfo.setStart(true);
            IObjectPK pk = ics.addnew(csInfo);
            ICustomizedUnit icu = CustomizedUnitFactory.getLocalInstance((Context)ctx);
            String oql = " where customizedschemeid='" + pk + "' and nodeType='ROOT' ";
            CustomizedUnitInfo rootNode = icu.getCustomizedUnitInfo(oql);
            CustomizedUnitNodeInfo cunInfo = new CustomizedUnitNodeInfo();
            cunInfo.setType("0");
            String xml = CustomizedUnitNodeInfoConverter.coverter2xml((CustomizedUnitNodeInfo)cunInfo);
            CustomizedUnitInfo cuInfo = new CustomizedUnitInfo();
            cuInfo.setName(SyncSchemeAlias);
            cuInfo.setDisplayName(SyncSchemeAlias);
            cuInfo.setDescription(SyncSchemeAlias);
            cuInfo.setNodeType(NodeTypeEnum.FLODER);
            cuInfo.setIsLeaf(false);
            cuInfo.setCustomizedUnitObject(xml);
            cuInfo.setId(BOSUuid.create((BOSObjectType)cuInfo.getBOSType()));
            cuInfo.setNumber(cuInfo.getId().toString());
            cuInfo.setNodeType(NodeTypeEnum.CUSTOMIZED_UNIT);
            cuInfo.setLevel(rootNode.getLevel() + 1);
            cuInfo.setParent(rootNode);
            cuInfo.setCustomizedSchemeID(pk.toString());
            icu.addnew((CoreBaseInfo)cuInfo);
            return pk.toString();
        }
        catch (EPException e) {
            if (!EPException.ITEM_CUSTOMIZED.getCode().equals(e.getSubCode())) {
                throw e;
            }
            return null;
        }
    }

    protected static void updateCustomizedUnit(Context ctx, AbstractMetaDataValue mdv, String customizedSchemeID) throws Exception {
        ICustomizedUnit icu = CustomizedUnitFactory.getLocalInstance((Context)ctx);
        CustomizedUnitInfo info = icu.getCustomizedUnitInfo("where name = '" + SyncSchemeAlias + "'and customizedSchemeID = '" + customizedSchemeID + "'");
        if (info != null) {
            CustomizedUnitNodeInfo cunInfo = CustomizedUnitNodeInfoConverter.converter2Object((String)info.getCustomizedUnitObject());
            CustomizedUnitNodeInfo.MetaDataInfo md = new CustomizedUnitNodeInfo.MetaDataInfo(mdv.getPackage(), mdv.getName(), mdv.getAlias());
            for (int i = 0; i < cunInfo.getEntity().size(); ++i) {
                if (!((CustomizedUnitNodeInfo.MetaDataInfo)cunInfo.getEntity().get(i)).getFullName().equals(md.getFullName())) continue;
                return;
            }
            cunInfo.getEntity().add(md);
            String xml = CustomizedUnitNodeInfoConverter.coverter2xml((CustomizedUnitNodeInfo)cunInfo);
            try {
                info.setCustomizedUnitObject(xml);
                ObjectUuidPK pk = new ObjectUuidPK(info.getId());
                icu.update((IObjectPK)pk, (IObjectValue)info, mdv.getFullName() + "!" + mdv.getBOSType());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String getDynamicCustomizedSchemeID(Context ctx, EntityObjectInfo entity) throws Exception {
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select fprojectid from t_con_dynamicmetadata where fmetadatapk = '" + entity.getFullName() + "'"));
            if (rs.next()) {
                return rs.getString(1);
            }
            throw new Exception("entity is dynamic,but can't find projectId!");
        }
        catch (Exception e) {
            logger.error((Object)"getDynamicProjectId error!", (Throwable)e);
            throw e;
        }
    }

    public static void update4Used(Context ctx, List<String> ids) throws EASBizException, BOSException {
        ICustomizedScheme ics = CustomizedSchemeFactory.getLocalInstance((Context)ctx);
        ics.update4Used(ids.toArray(new String[ids.size()]), true);
        DynamicExtendUtil.clearCache(ctx);
    }

    public static void clearCache(Context ctx) throws BOSException {
        ICustomizedScheme ics = CustomizedSchemeFactory.getLocalInstance((Context)ctx);
        CustomizedSchemeCollection col = ics.getCustomizedSchemeCollection();
        IServerMetadataStore mds = MetadataStoreFactory.getServerMetadataStore((Context)ctx);
        ArrayList<Project> ps = new ArrayList<Project>();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            CustomizedSchemeInfo csInfo = col.get(i);
            if (!csInfo.isStart()) continue;
            ps.add(new Project(csInfo.getId().toString()));
        }
        Project[] p = new Project[ps.size()];
        p = ps.toArray(p);
        mds.setProjects(p);
    }

    private static void addSQL4DynCol(Context ctx, DataTableInfo table, List sqlObjs, ColumnInfo column) throws Exception {
        if (table == null || sqlObjs == null || column == null) {
            return;
        }
        if (!column.isMultilingual()) {
            DBUpdateInfo info = new DBUpdateInfo(11, table.getName(), column.getName(), SqlBuilder.buildColumnSql((AbstractTableInfo)table, column), 0);
            sqlObjs.add(info);
            DynamicExtendUtil.executeSQL(ctx, info.getSql().getValue());
            try {
                DynamicExtendUtil.executeSQL(ctx, "create index " + DynamicExtendUtil.createTableIndexName(table.getRealName(), column.getName(), true) + " on " + table.getRealName() + " (" + column.getRealName() + ");");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static void executeSQL(Context ctx, String sql) throws SQLException {
        try {
            Method method = TableUtil.class.getMethod("executeSQL", String.class, String.class);
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)new TableUtil());
            txInvoker.invoke(method, new Object[]{ctx.getAIS(), sql}, 3);
        }
        catch (Throwable e) {
            Throwable t = e.getCause();
            if (t != null && t instanceof SQLException) {
                throw (SQLException)t;
            }
            throw new SQLException(e.getMessage());
        }
    }

    private static void saveMetadata(Context ctx, AbstractMetaDataValue[] mds, String customizedSchemeID) throws Exception {
        IServerMetadataStore mdstore = MetadataStoreFactory.getServerMetadataStore((Context)ctx);
        mdstore.saveMetadata(mds, customizedSchemeID, new Project[0]);
    }

    public static String createTableIndexName(String ltableName, String fieldName, boolean generateRandom) {
        String s;
        s = s.substring(0, (s = DynamicExtendUtil.createTableIndexName(ltableName, fieldName)).length() > 15 ? 15 : s.length());
        if (generateRandom) {
            s = s + DynamicExtendUtil.generateRandomNumber();
        }
        s = s.substring(0, s.length() > 18 ? 18 : s.length());
        return s;
    }

    public static String createTableIndexName(String ltableName, String fieldName) {
        String sPkName = "";
        String packageCode = DynamicExtendUtil.getPackageCodeByTableName(ltableName);
        int lTableLen = 8;
        int lFixLen = 18 - (packageCode.length() + 3) - lTableLen - fieldName.length();
        if (lFixLen < 0) {
            lFixLen = 0;
        }
        lTableLen += lFixLen;
        if (ltableName.length() > 1) {
            int lpos = (ltableName = DynamicExtendUtil.getNameNoDec(ltableName)).indexOf("_", MetaDataOptions.isDevelopVersion() ? 2 : 3);
            if (lpos >= 0) {
                if ((ltableName = ltableName.substring(lpos + 1)).indexOf(BIM_UNIT_DEFINEPREFIX) >= 0) {
                    ltableName = ltableName.substring(BIM_UNIT_DEFINEPREFIX.length());
                }
                if (ltableName.length() > lTableLen) {
                    ltableName = StringUtils.abbreviate((String)StringUtils.headCharUpperCase((String)ltableName), (int)lTableLen);
                }
            } else if (ltableName.length() > lTableLen) {
                if (ltableName.indexOf(BIM_UNIT_DEFINEPREFIX) >= 0) {
                    ltableName = ltableName.substring(BIM_UNIT_DEFINEPREFIX.length());
                }
                ltableName = StringUtils.abbreviate((String)StringUtils.headCharUpperCase((String)ltableName), (int)lTableLen);
            }
        }
        sPkName = "IDX_" + packageCode + "_" + StringUtils.headCharUpperCase((String)ltableName);
        if (fieldName.length() > 2 && (fieldName = fieldName.substring(1, fieldName.length())).length() > 18 - sPkName.length()) {
            fieldName = StringUtils.abbreviate((String)StringUtils.headCharUpperCase((String)fieldName), (int)(18 - sPkName.length()));
        }
        sPkName = sPkName + StringUtils.headCharUpperCase((String)fieldName);
        assert (sPkName.length() <= 18);
        return sPkName;
    }

    public static String getNameNoDec(String sName) {
        String strStr = "";
        String strDec = "";
        int strCount = 0;
        int decCount = 0;
        char[] chars = sName.toCharArray();
        char[] charStr = new char[chars.length];
        char[] charDec = new char[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            char temp = chars[i];
            if (temp >= '0' && temp <= '9') {
                charDec[decCount] = temp;
                ++decCount;
                continue;
            }
            charStr[strCount] = temp;
            ++strCount;
        }
        strStr = String.valueOf(charStr);
        strStr = strStr.trim();
        strDec = String.valueOf(charDec);
        if ((strDec = strDec.trim()).length() > String.valueOf(Long.MAX_VALUE).length()) {
            strDec = strDec.substring(0, String.valueOf(Long.MAX_VALUE).length());
        }
        if (!StringUtils.isEmpty((String)strDec)) {
            strDec = Long.toString(new Long(strDec), 32);
        }
        return strStr + strDec;
    }

    public static String generateRandomNumber() {
        String s = Long.toString(System.currentTimeMillis(), 32);
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length / 2 + 1; ++i) {
            char temp = chars[chars.length - 1 - i];
            chars[chars.length - 1 - i] = chars[i];
            chars[i] = temp;
        }
        s = String.valueOf(chars);
        return s;
    }

    private static String getPackageCodeByTableName(String ltableName) {
        if (StringUtils.isEmpty((String)ltableName)) {
            return "EP";
        }
        int index1 = ltableName.indexOf("_");
        int index2 = ltableName.indexOf("_", index1 + 1);
        if (index2 < 0) {
            return "EP";
        }
        return ltableName.substring(index1 + 1, index2);
    }
}

