/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bot.engine.sql;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bot.engine.sql.SQLSrcTableManager;
import com.kingdee.bos.kscript.dom.expr.BigDecimalExpr;
import com.kingdee.bos.kscript.dom.expr.BinaryOpExpr;
import com.kingdee.bos.kscript.dom.expr.BinaryOpType;
import com.kingdee.bos.kscript.dom.expr.BoolExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.expr.DoubleExpr;
import com.kingdee.bos.kscript.dom.expr.FloatExpr;
import com.kingdee.bos.kscript.dom.expr.IdentifierExpr;
import com.kingdee.bos.kscript.dom.expr.IntExpr;
import com.kingdee.bos.kscript.dom.expr.LongExpr;
import com.kingdee.bos.kscript.dom.expr.MethodInvokeExpr;
import com.kingdee.bos.kscript.dom.expr.NullExpr;
import com.kingdee.bos.kscript.dom.expr.PropertyExpr;
import com.kingdee.bos.kscript.dom.expr.StringExpr;
import com.kingdee.bos.kscript.dom.stmt.CodeStmt;
import com.kingdee.bos.kscript.dom.stmt.ExprStmt;
import com.kingdee.bos.kscript.parser.KScriptParser;
import com.kingdee.eas.common.EASBizException;
import java.util.List;

public class BotCodeExprConverter {
    public static String transform2SQL(ExprStmt stmt, SQLSrcTableManager srcTableManager) throws BOSException, EASBizException {
        if (stmt == null || srcTableManager == null) {
            return "";
        }
        CodeExpr expr = stmt.expr;
        String realSrcExpr = null;
        StringBuffer sb = new StringBuffer();
        BotCodeExprConverter.analyzeScriptCodeExpr(srcTableManager, sb, expr);
        realSrcExpr = sb.toString();
        return realSrcExpr;
    }

    public static String transform2SQL(String expression, SQLSrcTableManager srcTableManager) throws BOSException, EASBizException {
        KScriptParser parser = new KScriptParser(expression);
        parser.parse();
        List stmtList = parser.stmtList;
        if (stmtList.size() > 1) {
            throw new BOSException("Error,  expression=" + expression);
        }
        CodeStmt stmt = (CodeStmt)stmtList.get(0);
        if (stmt instanceof ExprStmt) {
            return BotCodeExprConverter.transform2SQL((ExprStmt)stmt, srcTableManager);
        }
        return "";
    }

    private static void analyzeScriptCodeExpr(SQLSrcTableManager srcTableManager, StringBuffer buff, CodeExpr expr) throws BOSException, EASBizException {
        if (expr == null) {
            return;
        }
        if (expr instanceof BigDecimalExpr || expr instanceof IntExpr || expr instanceof FloatExpr || expr instanceof BoolExpr || expr instanceof DoubleExpr || expr instanceof LongExpr || expr instanceof NullExpr) {
            expr.output(buff);
        } else if (expr instanceof StringExpr) {
            buff.append("'" + ((StringExpr)expr).getJavaString() + "'");
        } else if (expr instanceof IdentifierExpr) {
            expr.output(buff);
        } else if (expr instanceof PropertyExpr) {
            PropertyExpr propExpr = (PropertyExpr)expr;
            String srcOwner = propExpr.owner.toString();
            String srcPropName = propExpr.propName;
            String tableAlias = srcTableManager.getTableAliasByEntityPath(srcOwner);
            String columnName = srcTableManager.getColumnNameByPropName(tableAlias, srcPropName);
            buff.append(columnName);
        } else if (expr instanceof MethodInvokeExpr) {
            MethodInvokeExpr methodExpr = (MethodInvokeExpr)expr;
            String methodName = methodExpr.methodName;
            List params = methodExpr.paramList;
            buff.append(methodName);
            buff.append("(");
            for (int i = 0; i < params.size(); ++i) {
                if (i > 0) {
                    buff.append(",");
                }
                CodeExpr paramExpr = (CodeExpr)params.get(i);
                BotCodeExprConverter.analyzeScriptCodeExpr(srcTableManager, buff, paramExpr);
            }
            buff.append(")");
        } else if (expr instanceof BinaryOpExpr) {
            BinaryOpExpr binaryOpExpr = (BinaryOpExpr)expr;
            BotCodeExprConverter.analyzeScriptCodeExpr(srcTableManager, buff, binaryOpExpr.left);
            buff.append(BinaryOpType.getName((int)binaryOpExpr.operator));
            BotCodeExprConverter.analyzeScriptCodeExpr(srcTableManager, buff, binaryOpExpr.right);
        }
    }
}

