/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bot.engine.sql;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.Locale;

public class BotSqlNameMappingHelper {
    public static String getDataTypeStrByFieldName(EntityObjectInfo srcEntity, EntityObjectInfo destEntity, String fieldName) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)fieldName) || srcEntity == null || destEntity == null) {
            throw new BOSException("Illegal Argument, fieldName=" + fieldName + ", srcEntity=" + srcEntity + ", destEntity=" + destEntity);
        }
        String value = null;
        StringBuffer strDataType = new StringBuffer();
        String realFiledName = fieldName.toLowerCase(Locale.ENGLISH);
        if (realFiledName.startsWith("__src.")) {
            realFiledName = realFiledName.substring("__src".length() + 1);
            value = BotSqlNameMappingHelper.getDataTypeStrByFieldName(srcEntity, realFiledName);
        } else if (realFiledName.startsWith("__dest.")) {
            realFiledName = realFiledName.substring("__dest".length() + 1);
            value = BotSqlNameMappingHelper.getDataTypeStrByFieldName(destEntity, realFiledName);
        } else {
            value = BotSqlNameMappingHelper.getDataTypeStrByFieldName(destEntity, realFiledName);
        }
        if (StringUtils.isEmpty((String)value)) {
            throw new BOSException("The data type can't be null,  DataType=" + value + ", fieldName=" + fieldName + ", srcEntity=" + srcEntity + ", destEntity=" + destEntity);
        }
        return value;
    }

    private static String getDataTypeStrByFieldName(EntityObjectInfo entity, String fieldName) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)fieldName)) {
            throw new BOSException("Illegal Argument, fieldName=" + fieldName + ", entity=" + entity);
        }
        StringBuffer strDataType = new StringBuffer();
        String[] names = StringUtils.split((String)fieldName, (String)".");
        EntityObjectInfo currEntity = entity;
        for (int i = 0; i < names.length; ++i) {
            DataTableInfo tableInfo = currEntity.getTable();
            String name = names[i];
            PropertyCollection props = currEntity.getInheritedNoDuplicatedPropertiesRuntime();
            PropertyInfo prop = null;
            for (int j = 0; j < props.size(); ++j) {
                PropertyInfo tempProp = props.get(j);
                if (!name.equalsIgnoreCase(tempProp.getName())) continue;
                prop = tempProp;
                break;
            }
            if (prop != null) {
                boolean isSubField = true;
                if (prop instanceof OwnPropertyInfo) {
                    isSubField = false;
                } else if (prop instanceof LinkPropertyInfo) {
                    if (i == names.length - 1) {
                        isSubField = false;
                    } else {
                        EntityObjectInfo supplierObj;
                        LinkPropertyInfo linkProp = (LinkPropertyInfo)prop;
                        RelationshipInfo relationShip = linkProp.getRelationship();
                        EntityObjectInfo clientObj = relationShip.getClientObject();
                        currEntity = supplierObj = relationShip.getSupplierObject();
                    }
                } else {
                    throw new BOSException();
                }
                if (isSubField) continue;
                ColumnInfo columnField = prop.getMappingField();
                ColumnInfo columnInfo = tableInfo.getColumnByName(columnField.getName());
                String sDesc = BotSqlNameMappingHelper.getDataColumnDescFromTableField(columnInfo);
                strDataType.append(sDesc);
                continue;
            }
            return "VARCHAR(44)";
        }
        return strDataType.toString();
    }

    private static String getDataColumnDescFromTableField(ColumnInfo column) {
        StringBuffer strDataType = new StringBuffer();
        String sName = column.getName();
        int sqlType = column.getSQLType();
        String strSqlType = BotSqlNameMappingHelper.getSqlTypeStringFromInt(sqlType);
        int iLength = column.getLength();
        int iScale = column.getScale();
        int iPrecision = column.getPrecision();
        boolean isNullable = column.isNullable();
        String sDefaultValue = column.getDefaultValue();
        strDataType.append(strSqlType);
        if (BotSqlNameMappingHelper.isNeedDataTypeDesc(sqlType)) {
            if (BotSqlNameMappingHelper.isNeedDataDescPrecision(sqlType)) {
                strDataType.append("(").append(iPrecision);
                strDataType.append(",").append(iScale);
            } else {
                strDataType.append("(").append(iLength);
            }
            strDataType.append(")");
        }
        if (!StringUtils.isEmpty((String)sDefaultValue)) {
            strDataType.append(" DEFAULT ").append(sDefaultValue);
        }
        return strDataType.toString();
    }

    private static String getSqlTypeStringFromInt(int sqlType) {
        if (sqlType == 2003) {
            return "ARRAY";
        }
        if (sqlType == -5) {
            return "BIGINT";
        }
        if (sqlType == -2) {
            return "BINARY";
        }
        if (sqlType == -7) {
            return "BIT";
        }
        if (sqlType == 2004) {
            return "BLOB";
        }
        if (sqlType == 16) {
            return "BOOLEAN";
        }
        if (sqlType == 1) {
            return "CHAR";
        }
        if (sqlType == 2005) {
            return "CLOB";
        }
        if (sqlType == 70) {
            return "DATALINK";
        }
        if (sqlType == 91) {
            return "DATE";
        }
        if (sqlType == 3) {
            return "DECIMAL";
        }
        if (sqlType == 2001) {
            return "DISTINCT";
        }
        if (sqlType == 8) {
            return "DOUBLE";
        }
        if (sqlType == 6) {
            return "FLOAT";
        }
        if (sqlType == 4) {
            return "INTEGER";
        }
        if (sqlType == 2000) {
            return "JAVA_OBJECT";
        }
        if (sqlType == -4) {
            return "LONGVARBINARY";
        }
        if (sqlType == -1) {
            return "LONGVARCHAR";
        }
        if (sqlType == 0) {
            return "NULL";
        }
        if (sqlType == 2) {
            return "NUMERIC";
        }
        if (sqlType == 1111) {
            return "OTHER";
        }
        if (sqlType == 7) {
            return "REAL";
        }
        if (sqlType == 2006) {
            return "REF";
        }
        if (sqlType == 5) {
            return "SMALLINT";
        }
        if (sqlType == 2002) {
            return "STRUCT";
        }
        if (sqlType == 92) {
            return "TIME";
        }
        if (sqlType == 93) {
            return "TIMESTAMP";
        }
        if (sqlType == -6) {
            return "TINYINT";
        }
        if (sqlType == -3) {
            return "VARBINARY";
        }
        if (sqlType == 12) {
            return "VARCHAR";
        }
        return "";
    }

    private static boolean isNeedDataTypeDesc(int sqlType) {
        if (sqlType == 1 || sqlType == 12) {
            return true;
        }
        if (sqlType == 8 || sqlType == 6 || sqlType == 2) {
            return true;
        }
        if (sqlType == 91 || sqlType == 4 || sqlType == 2004 || sqlType == 2005 || sqlType == 5 || sqlType == -5) {
            return false;
        }
        return false;
    }

    private static boolean isNeedDataDescPrecision(int sqlType) {
        return sqlType == 8 || sqlType == 6 || sqlType == 2;
    }
}

