/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bot.engine.sql;

import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class FieldNameMappingManager {
    private static int TABLEFIELDNAME_LENGTH_MAX = 20;
    private Map entityFieldNameMap = new HashMap();
    private Map tableFieldNameMap = new HashMap();

    public void addNameMapping(String entityFieldName, String tableFieldName) {
        this.entityFieldNameMap.put(entityFieldName, tableFieldName);
        this.tableFieldNameMap.put(tableFieldName, entityFieldName);
    }

    public void removeNameMapping(String entityFieldName, String tableFieldName) {
        this.entityFieldNameMap.remove(entityFieldName);
        this.tableFieldNameMap.remove(tableFieldName);
    }

    public String getTableFieldNameByEntityFieldName(String entityFieldName) {
        if (StringUtils.isEmpty((String)entityFieldName)) {
            return entityFieldName;
        }
        String tempName = entityFieldName.toLowerCase(Locale.ENGLISH);
        String columnName = (String)this.entityFieldNameMap.get(tempName);
        if (columnName == null) {
            if (tempName.startsWith("__src.")) {
                tempName = "bot_src." + tempName.substring("__src".length() + 1);
            }
            if ((columnName = (String)this.entityFieldNameMap.get(tempName)) == null && !StringUtils.isEmpty((String)(columnName = this.buildTableFieldNameByEntityFieldName(tempName)))) {
                this.entityFieldNameMap.put(tempName, columnName);
                this.tableFieldNameMap.put(columnName, tempName);
            }
        }
        return columnName;
    }

    public String getEntityFieldNameByTableName(String tableFieldName) {
        return (String)this.tableFieldNameMap.get(tableFieldName);
    }

    public void clear() {
        this.entityFieldNameMap.clear();
        this.tableFieldNameMap.clear();
    }

    protected String buildTableFieldNameByEntityFieldName(String entityFieldName) {
        String newName = entityFieldName;
        if (StringUtils.isEmpty((String)newName)) {
            return newName;
        }
        if ((newName = newName.replace('.', '_')).length() <= TABLEFIELDNAME_LENGTH_MAX) {
            return newName;
        }
        String[] names = StringUtils.split((String)entityFieldName, (String)".");
        int len = 5;
        while (newName.length() > TABLEFIELDNAME_LENGTH_MAX) {
            newName = this.innerGetTableFieldName(names, newName, len);
            --len;
        }
        int idx = 1;
        String realName = newName;
        while (this.tableFieldNameMap.get(realName) != null) {
            realName = newName + idx;
            ++idx;
        }
        return realName;
    }

    private String innerGetTableFieldName(String[] names, String fullName, int len) {
        String tmpName = null;
        StringBuffer sb = new StringBuffer();
        if (len <= 0) {
            tmpName = fullName.substring(0, TABLEFIELDNAME_LENGTH_MAX - 1);
        } else {
            for (int i = 0; i < names.length; ++i) {
                if (i > 0) {
                    sb.append("_");
                }
                if (i == 0) {
                    sb.append(names[i]);
                    continue;
                }
                if (names[i].length() > len) {
                    sb.append(names[i].substring(0, len));
                    continue;
                }
                sb.append(names[i].substring(0, names[i].length()));
            }
            tmpName = sb.toString();
        }
        return tmpName;
    }

    public Map getEntityFieldNameMap() {
        return this.entityFieldNameMap;
    }

    public void setEntityFieldNameMap(Map entityFieldNameMap) {
        this.entityFieldNameMap = entityFieldNameMap;
    }

    public Map getTableFieldNameMap() {
        return this.tableFieldNameMap;
    }

    public void setTableFieldNameMap(Map tableFieldNameMap) {
        this.tableFieldNameMap = tableFieldNameMap;
    }
}

